<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CREDIT_INFO StructType
 * @subpackage Structs
 */
class CREDIT_INFO extends AbstractStructBase
{
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTITY;
    /**
     * The PARTY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY_TYPE_DB;
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NAME;
    /**
     * The LAST4Q_SALES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LAST4Q_SALES;
    /**
     * The NOTE_TEXT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NOTE_TEXT;
    /**
     * The CREDIT_NUMBER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_NUMBER;
    /**
     * The CREDIT_RATING
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_RATING;
    /**
     * The AVG_DAYS_FOR_PAYMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AVG_DAYS_FOR_PAYMENT;
    /**
     * The CREDIT_COMMENTS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_COMMENTS;
    /**
     * The CREDIT_ANALYST_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_ANALYST_CODE;
    /**
     * The MESSAGE_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MESSAGE_TYPE;
    /**
     * The CREDIT_LIMIT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CREDIT_LIMIT;
    /**
     * The CREDIT_BLOCK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_BLOCK;
    /**
     * The NEXT_REVIEW_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NEXT_REVIEW_DATE;
    /**
     * The CORP_CREDIT_RELATION_EXIST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CORP_CREDIT_RELATION_EXIST;
    /**
     * The CREDIT_RELATIONSHIP_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREDIT_RELATIONSHIP_TYPE_DB;
    /**
     * The PARENT_COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARENT_COMPANY;
    /**
     * The PARENT_IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARENT_IDENTITY;
    /**
     * The ALLOWED_DUE_DAYS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ALLOWED_DUE_DAYS;
    /**
     * The ALLOWED_DUE_AMOUNT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ALLOWED_DUE_AMOUNT;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * Constructor method for CREDIT_INFO
     * @uses CREDIT_INFO::setCOMPANY()
     * @uses CREDIT_INFO::setIDENTITY()
     * @uses CREDIT_INFO::setPARTY_TYPE_DB()
     * @uses CREDIT_INFO::setNAME()
     * @uses CREDIT_INFO::setLAST4Q_SALES()
     * @uses CREDIT_INFO::setNOTE_TEXT()
     * @uses CREDIT_INFO::setCREDIT_NUMBER()
     * @uses CREDIT_INFO::setCREDIT_RATING()
     * @uses CREDIT_INFO::setAVG_DAYS_FOR_PAYMENT()
     * @uses CREDIT_INFO::setCREDIT_COMMENTS()
     * @uses CREDIT_INFO::setCREDIT_ANALYST_CODE()
     * @uses CREDIT_INFO::setMESSAGE_TYPE()
     * @uses CREDIT_INFO::setCREDIT_LIMIT()
     * @uses CREDIT_INFO::setCREDIT_BLOCK()
     * @uses CREDIT_INFO::setNEXT_REVIEW_DATE()
     * @uses CREDIT_INFO::setCORP_CREDIT_RELATION_EXIST()
     * @uses CREDIT_INFO::setCREDIT_RELATIONSHIP_TYPE_DB()
     * @uses CREDIT_INFO::setPARENT_COMPANY()
     * @uses CREDIT_INFO::setPARENT_IDENTITY()
     * @uses CREDIT_INFO::setALLOWED_DUE_DAYS()
     * @uses CREDIT_INFO::setALLOWED_DUE_AMOUNT()
     * @uses CREDIT_INFO::setOPERATION()
     * @param string $cOMPANY
     * @param string $iDENTITY
     * @param string $pARTY_TYPE_DB
     * @param string $nAME
     * @param float $lAST4Q_SALES
     * @param string $nOTE_TEXT
     * @param string $cREDIT_NUMBER
     * @param string $cREDIT_RATING
     * @param string $aVG_DAYS_FOR_PAYMENT
     * @param string $cREDIT_COMMENTS
     * @param string $cREDIT_ANALYST_CODE
     * @param string $mESSAGE_TYPE
     * @param float $cREDIT_LIMIT
     * @param string $cREDIT_BLOCK
     * @param string $nEXT_REVIEW_DATE
     * @param string $cORP_CREDIT_RELATION_EXIST
     * @param string $cREDIT_RELATIONSHIP_TYPE_DB
     * @param string $pARENT_COMPANY
     * @param string $pARENT_IDENTITY
     * @param float $aLLOWED_DUE_DAYS
     * @param float $aLLOWED_DUE_AMOUNT
     * @param string $oPERATION
     */
    public function __construct($cOMPANY = null, $iDENTITY = null, $pARTY_TYPE_DB = null, $nAME = null, $lAST4Q_SALES = null, $nOTE_TEXT = null, $cREDIT_NUMBER = null, $cREDIT_RATING = null, $aVG_DAYS_FOR_PAYMENT = null, $cREDIT_COMMENTS = null, $cREDIT_ANALYST_CODE = null, $mESSAGE_TYPE = null, $cREDIT_LIMIT = null, $cREDIT_BLOCK = null, $nEXT_REVIEW_DATE = null, $cORP_CREDIT_RELATION_EXIST = null, $cREDIT_RELATIONSHIP_TYPE_DB = null, $pARENT_COMPANY = null, $pARENT_IDENTITY = null, $aLLOWED_DUE_DAYS = null, $aLLOWED_DUE_AMOUNT = null, $oPERATION = null)
    {
        $this
            ->setCOMPANY($cOMPANY)
            ->setIDENTITY($iDENTITY)
            ->setPARTY_TYPE_DB($pARTY_TYPE_DB)
            ->setNAME($nAME)
            ->setLAST4Q_SALES($lAST4Q_SALES)
            ->setNOTE_TEXT($nOTE_TEXT)
            ->setCREDIT_NUMBER($cREDIT_NUMBER)
            ->setCREDIT_RATING($cREDIT_RATING)
            ->setAVG_DAYS_FOR_PAYMENT($aVG_DAYS_FOR_PAYMENT)
            ->setCREDIT_COMMENTS($cREDIT_COMMENTS)
            ->setCREDIT_ANALYST_CODE($cREDIT_ANALYST_CODE)
            ->setMESSAGE_TYPE($mESSAGE_TYPE)
            ->setCREDIT_LIMIT($cREDIT_LIMIT)
            ->setCREDIT_BLOCK($cREDIT_BLOCK)
            ->setNEXT_REVIEW_DATE($nEXT_REVIEW_DATE)
            ->setCORP_CREDIT_RELATION_EXIST($cORP_CREDIT_RELATION_EXIST)
            ->setCREDIT_RELATIONSHIP_TYPE_DB($cREDIT_RELATIONSHIP_TYPE_DB)
            ->setPARENT_COMPANY($pARENT_COMPANY)
            ->setPARENT_IDENTITY($pARENT_IDENTITY)
            ->setALLOWED_DUE_DAYS($aLLOWED_DUE_DAYS)
            ->setALLOWED_DUE_AMOUNT($aLLOWED_DUE_AMOUNT)
            ->setOPERATION($oPERATION);
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\CREDIT_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTITY()
    {
        return isset($this->IDENTITY) ? $this->IDENTITY : null;
    }
    /**
     * Set IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTITY
     * @return \StructType\CREDIT_INFO
     */
    public function setIDENTITY($iDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTITY) && !is_string($iDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTITY)), __LINE__);
        }
        if (is_null($iDENTITY) || (is_array($iDENTITY) && empty($iDENTITY))) {
            unset($this->IDENTITY);
        } else {
            $this->IDENTITY = $iDENTITY;
        }
        return $this;
    }
    /**
     * Get PARTY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY_TYPE_DB()
    {
        return isset($this->PARTY_TYPE_DB) ? $this->PARTY_TYPE_DB : null;
    }
    /**
     * Set PARTY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY_TYPE_DB
     * @return \StructType\CREDIT_INFO
     */
    public function setPARTY_TYPE_DB($pARTY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY_TYPE_DB) && !is_string($pARTY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY_TYPE_DB)), __LINE__);
        }
        if (is_null($pARTY_TYPE_DB) || (is_array($pARTY_TYPE_DB) && empty($pARTY_TYPE_DB))) {
            unset($this->PARTY_TYPE_DB);
        } else {
            $this->PARTY_TYPE_DB = $pARTY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get NAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNAME()
    {
        return isset($this->NAME) ? $this->NAME : null;
    }
    /**
     * Set NAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nAME
     * @return \StructType\CREDIT_INFO
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        if (is_null($nAME) || (is_array($nAME) && empty($nAME))) {
            unset($this->NAME);
        } else {
            $this->NAME = $nAME;
        }
        return $this;
    }
    /**
     * Get LAST4Q_SALES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLAST4Q_SALES()
    {
        return isset($this->LAST4Q_SALES) ? $this->LAST4Q_SALES : null;
    }
    /**
     * Set LAST4Q_SALES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lAST4Q_SALES
     * @return \StructType\CREDIT_INFO
     */
    public function setLAST4Q_SALES($lAST4Q_SALES = null)
    {
        if (is_null($lAST4Q_SALES) || (is_array($lAST4Q_SALES) && empty($lAST4Q_SALES))) {
            unset($this->LAST4Q_SALES);
        } else {
            $this->LAST4Q_SALES = $lAST4Q_SALES;
        }
        return $this;
    }
    /**
     * Get NOTE_TEXT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNOTE_TEXT()
    {
        return isset($this->NOTE_TEXT) ? $this->NOTE_TEXT : null;
    }
    /**
     * Set NOTE_TEXT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nOTE_TEXT
     * @return \StructType\CREDIT_INFO
     */
    public function setNOTE_TEXT($nOTE_TEXT = null)
    {
        // validation for constraint: string
        if (!is_null($nOTE_TEXT) && !is_string($nOTE_TEXT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nOTE_TEXT)), __LINE__);
        }
        if (is_null($nOTE_TEXT) || (is_array($nOTE_TEXT) && empty($nOTE_TEXT))) {
            unset($this->NOTE_TEXT);
        } else {
            $this->NOTE_TEXT = $nOTE_TEXT;
        }
        return $this;
    }
    /**
     * Get CREDIT_NUMBER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_NUMBER()
    {
        return isset($this->CREDIT_NUMBER) ? $this->CREDIT_NUMBER : null;
    }
    /**
     * Set CREDIT_NUMBER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_NUMBER
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_NUMBER($cREDIT_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_NUMBER) && !is_string($cREDIT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_NUMBER)), __LINE__);
        }
        if (is_null($cREDIT_NUMBER) || (is_array($cREDIT_NUMBER) && empty($cREDIT_NUMBER))) {
            unset($this->CREDIT_NUMBER);
        } else {
            $this->CREDIT_NUMBER = $cREDIT_NUMBER;
        }
        return $this;
    }
    /**
     * Get CREDIT_RATING value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_RATING()
    {
        return isset($this->CREDIT_RATING) ? $this->CREDIT_RATING : null;
    }
    /**
     * Set CREDIT_RATING value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_RATING
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_RATING($cREDIT_RATING = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_RATING) && !is_string($cREDIT_RATING)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_RATING)), __LINE__);
        }
        if (is_null($cREDIT_RATING) || (is_array($cREDIT_RATING) && empty($cREDIT_RATING))) {
            unset($this->CREDIT_RATING);
        } else {
            $this->CREDIT_RATING = $cREDIT_RATING;
        }
        return $this;
    }
    /**
     * Get AVG_DAYS_FOR_PAYMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAVG_DAYS_FOR_PAYMENT()
    {
        return isset($this->AVG_DAYS_FOR_PAYMENT) ? $this->AVG_DAYS_FOR_PAYMENT : null;
    }
    /**
     * Set AVG_DAYS_FOR_PAYMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aVG_DAYS_FOR_PAYMENT
     * @return \StructType\CREDIT_INFO
     */
    public function setAVG_DAYS_FOR_PAYMENT($aVG_DAYS_FOR_PAYMENT = null)
    {
        // validation for constraint: string
        if (!is_null($aVG_DAYS_FOR_PAYMENT) && !is_string($aVG_DAYS_FOR_PAYMENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aVG_DAYS_FOR_PAYMENT)), __LINE__);
        }
        if (is_null($aVG_DAYS_FOR_PAYMENT) || (is_array($aVG_DAYS_FOR_PAYMENT) && empty($aVG_DAYS_FOR_PAYMENT))) {
            unset($this->AVG_DAYS_FOR_PAYMENT);
        } else {
            $this->AVG_DAYS_FOR_PAYMENT = $aVG_DAYS_FOR_PAYMENT;
        }
        return $this;
    }
    /**
     * Get CREDIT_COMMENTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_COMMENTS()
    {
        return isset($this->CREDIT_COMMENTS) ? $this->CREDIT_COMMENTS : null;
    }
    /**
     * Set CREDIT_COMMENTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_COMMENTS
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_COMMENTS($cREDIT_COMMENTS = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_COMMENTS) && !is_string($cREDIT_COMMENTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_COMMENTS)), __LINE__);
        }
        if (is_null($cREDIT_COMMENTS) || (is_array($cREDIT_COMMENTS) && empty($cREDIT_COMMENTS))) {
            unset($this->CREDIT_COMMENTS);
        } else {
            $this->CREDIT_COMMENTS = $cREDIT_COMMENTS;
        }
        return $this;
    }
    /**
     * Get CREDIT_ANALYST_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_ANALYST_CODE()
    {
        return isset($this->CREDIT_ANALYST_CODE) ? $this->CREDIT_ANALYST_CODE : null;
    }
    /**
     * Set CREDIT_ANALYST_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_ANALYST_CODE
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_ANALYST_CODE($cREDIT_ANALYST_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_ANALYST_CODE) && !is_string($cREDIT_ANALYST_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_ANALYST_CODE)), __LINE__);
        }
        if (is_null($cREDIT_ANALYST_CODE) || (is_array($cREDIT_ANALYST_CODE) && empty($cREDIT_ANALYST_CODE))) {
            unset($this->CREDIT_ANALYST_CODE);
        } else {
            $this->CREDIT_ANALYST_CODE = $cREDIT_ANALYST_CODE;
        }
        return $this;
    }
    /**
     * Get MESSAGE_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMESSAGE_TYPE()
    {
        return isset($this->MESSAGE_TYPE) ? $this->MESSAGE_TYPE : null;
    }
    /**
     * Set MESSAGE_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mESSAGE_TYPE
     * @return \StructType\CREDIT_INFO
     */
    public function setMESSAGE_TYPE($mESSAGE_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($mESSAGE_TYPE) && !is_string($mESSAGE_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mESSAGE_TYPE)), __LINE__);
        }
        if (is_null($mESSAGE_TYPE) || (is_array($mESSAGE_TYPE) && empty($mESSAGE_TYPE))) {
            unset($this->MESSAGE_TYPE);
        } else {
            $this->MESSAGE_TYPE = $mESSAGE_TYPE;
        }
        return $this;
    }
    /**
     * Get CREDIT_LIMIT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCREDIT_LIMIT()
    {
        return isset($this->CREDIT_LIMIT) ? $this->CREDIT_LIMIT : null;
    }
    /**
     * Set CREDIT_LIMIT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cREDIT_LIMIT
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_LIMIT($cREDIT_LIMIT = null)
    {
        if (is_null($cREDIT_LIMIT) || (is_array($cREDIT_LIMIT) && empty($cREDIT_LIMIT))) {
            unset($this->CREDIT_LIMIT);
        } else {
            $this->CREDIT_LIMIT = $cREDIT_LIMIT;
        }
        return $this;
    }
    /**
     * Get CREDIT_BLOCK value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_BLOCK()
    {
        return isset($this->CREDIT_BLOCK) ? $this->CREDIT_BLOCK : null;
    }
    /**
     * Set CREDIT_BLOCK value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_BLOCK
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_BLOCK($cREDIT_BLOCK = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_BLOCK) && !is_string($cREDIT_BLOCK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_BLOCK)), __LINE__);
        }
        if (is_null($cREDIT_BLOCK) || (is_array($cREDIT_BLOCK) && empty($cREDIT_BLOCK))) {
            unset($this->CREDIT_BLOCK);
        } else {
            $this->CREDIT_BLOCK = $cREDIT_BLOCK;
        }
        return $this;
    }
    /**
     * Get NEXT_REVIEW_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNEXT_REVIEW_DATE()
    {
        return isset($this->NEXT_REVIEW_DATE) ? $this->NEXT_REVIEW_DATE : null;
    }
    /**
     * Set NEXT_REVIEW_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nEXT_REVIEW_DATE
     * @return \StructType\CREDIT_INFO
     */
    public function setNEXT_REVIEW_DATE($nEXT_REVIEW_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($nEXT_REVIEW_DATE) && !is_string($nEXT_REVIEW_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nEXT_REVIEW_DATE)), __LINE__);
        }
        if (is_null($nEXT_REVIEW_DATE) || (is_array($nEXT_REVIEW_DATE) && empty($nEXT_REVIEW_DATE))) {
            unset($this->NEXT_REVIEW_DATE);
        } else {
            $this->NEXT_REVIEW_DATE = $nEXT_REVIEW_DATE;
        }
        return $this;
    }
    /**
     * Get CORP_CREDIT_RELATION_EXIST value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCORP_CREDIT_RELATION_EXIST()
    {
        return isset($this->CORP_CREDIT_RELATION_EXIST) ? $this->CORP_CREDIT_RELATION_EXIST : null;
    }
    /**
     * Set CORP_CREDIT_RELATION_EXIST value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cORP_CREDIT_RELATION_EXIST
     * @return \StructType\CREDIT_INFO
     */
    public function setCORP_CREDIT_RELATION_EXIST($cORP_CREDIT_RELATION_EXIST = null)
    {
        // validation for constraint: string
        if (!is_null($cORP_CREDIT_RELATION_EXIST) && !is_string($cORP_CREDIT_RELATION_EXIST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cORP_CREDIT_RELATION_EXIST)), __LINE__);
        }
        if (is_null($cORP_CREDIT_RELATION_EXIST) || (is_array($cORP_CREDIT_RELATION_EXIST) && empty($cORP_CREDIT_RELATION_EXIST))) {
            unset($this->CORP_CREDIT_RELATION_EXIST);
        } else {
            $this->CORP_CREDIT_RELATION_EXIST = $cORP_CREDIT_RELATION_EXIST;
        }
        return $this;
    }
    /**
     * Get CREDIT_RELATIONSHIP_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREDIT_RELATIONSHIP_TYPE_DB()
    {
        return isset($this->CREDIT_RELATIONSHIP_TYPE_DB) ? $this->CREDIT_RELATIONSHIP_TYPE_DB : null;
    }
    /**
     * Set CREDIT_RELATIONSHIP_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREDIT_RELATIONSHIP_TYPE_DB
     * @return \StructType\CREDIT_INFO
     */
    public function setCREDIT_RELATIONSHIP_TYPE_DB($cREDIT_RELATIONSHIP_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cREDIT_RELATIONSHIP_TYPE_DB) && !is_string($cREDIT_RELATIONSHIP_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREDIT_RELATIONSHIP_TYPE_DB)), __LINE__);
        }
        if (is_null($cREDIT_RELATIONSHIP_TYPE_DB) || (is_array($cREDIT_RELATIONSHIP_TYPE_DB) && empty($cREDIT_RELATIONSHIP_TYPE_DB))) {
            unset($this->CREDIT_RELATIONSHIP_TYPE_DB);
        } else {
            $this->CREDIT_RELATIONSHIP_TYPE_DB = $cREDIT_RELATIONSHIP_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get PARENT_COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARENT_COMPANY()
    {
        return isset($this->PARENT_COMPANY) ? $this->PARENT_COMPANY : null;
    }
    /**
     * Set PARENT_COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARENT_COMPANY
     * @return \StructType\CREDIT_INFO
     */
    public function setPARENT_COMPANY($pARENT_COMPANY = null)
    {
        // validation for constraint: string
        if (!is_null($pARENT_COMPANY) && !is_string($pARENT_COMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARENT_COMPANY)), __LINE__);
        }
        if (is_null($pARENT_COMPANY) || (is_array($pARENT_COMPANY) && empty($pARENT_COMPANY))) {
            unset($this->PARENT_COMPANY);
        } else {
            $this->PARENT_COMPANY = $pARENT_COMPANY;
        }
        return $this;
    }
    /**
     * Get PARENT_IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARENT_IDENTITY()
    {
        return isset($this->PARENT_IDENTITY) ? $this->PARENT_IDENTITY : null;
    }
    /**
     * Set PARENT_IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARENT_IDENTITY
     * @return \StructType\CREDIT_INFO
     */
    public function setPARENT_IDENTITY($pARENT_IDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($pARENT_IDENTITY) && !is_string($pARENT_IDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARENT_IDENTITY)), __LINE__);
        }
        if (is_null($pARENT_IDENTITY) || (is_array($pARENT_IDENTITY) && empty($pARENT_IDENTITY))) {
            unset($this->PARENT_IDENTITY);
        } else {
            $this->PARENT_IDENTITY = $pARENT_IDENTITY;
        }
        return $this;
    }
    /**
     * Get ALLOWED_DUE_DAYS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getALLOWED_DUE_DAYS()
    {
        return isset($this->ALLOWED_DUE_DAYS) ? $this->ALLOWED_DUE_DAYS : null;
    }
    /**
     * Set ALLOWED_DUE_DAYS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aLLOWED_DUE_DAYS
     * @return \StructType\CREDIT_INFO
     */
    public function setALLOWED_DUE_DAYS($aLLOWED_DUE_DAYS = null)
    {
        if (is_null($aLLOWED_DUE_DAYS) || (is_array($aLLOWED_DUE_DAYS) && empty($aLLOWED_DUE_DAYS))) {
            unset($this->ALLOWED_DUE_DAYS);
        } else {
            $this->ALLOWED_DUE_DAYS = $aLLOWED_DUE_DAYS;
        }
        return $this;
    }
    /**
     * Get ALLOWED_DUE_AMOUNT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getALLOWED_DUE_AMOUNT()
    {
        return isset($this->ALLOWED_DUE_AMOUNT) ? $this->ALLOWED_DUE_AMOUNT : null;
    }
    /**
     * Set ALLOWED_DUE_AMOUNT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aLLOWED_DUE_AMOUNT
     * @return \StructType\CREDIT_INFO
     */
    public function setALLOWED_DUE_AMOUNT($aLLOWED_DUE_AMOUNT = null)
    {
        if (is_null($aLLOWED_DUE_AMOUNT) || (is_array($aLLOWED_DUE_AMOUNT) && empty($aLLOWED_DUE_AMOUNT))) {
            unset($this->ALLOWED_DUE_AMOUNT);
        } else {
            $this->ALLOWED_DUE_AMOUNT = $aLLOWED_DUE_AMOUNT;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CREDIT_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CREDIT_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
