<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receivecustomer ServiceType
 * @subpackage Services
 */
class Receivecustomer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named receive_customer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CUSTOMER_INFO_RESPONSE $request_body
     * @return \StructType\CRM_RESPONSE|bool
     */
    public function receive_customer(\StructType\CUSTOMER_INFO_RESPONSE $request_body)
    {
        try {
            $this->setResult(self::getSoapClient()->receive_customer($request_body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CRM_RESPONSE
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
