<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SUPP_BLANKET_RESPONSE StructType
 * @subpackage Structs
 */
class SUPP_BLANKET_RESPONSE extends AbstractStructBase
{
    /**
     * The RESULT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $RESULT;
    /**
     * The ERROR_INFO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 2000
     * @var string
     */
    public $ERROR_INFO;
    /**
     * The BLANKET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BLANKET
     */
    public $BLANKET;
    /**
     * Constructor method for SUPP_BLANKET_RESPONSE
     * @uses SUPP_BLANKET_RESPONSE::setRESULT()
     * @uses SUPP_BLANKET_RESPONSE::setERROR_INFO()
     * @uses SUPP_BLANKET_RESPONSE::setBLANKET()
     * @param string $rESULT
     * @param string $eRROR_INFO
     * @param \StructType\BLANKET $bLANKET
     */
    public function __construct($rESULT = null, $eRROR_INFO = null, \StructType\BLANKET $bLANKET = null)
    {
        $this
            ->setRESULT($rESULT)
            ->setERROR_INFO($eRROR_INFO)
            ->setBLANKET($bLANKET);
    }
    /**
     * Get RESULT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRESULT()
    {
        return isset($this->RESULT) ? $this->RESULT : null;
    }
    /**
     * Set RESULT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rESULT
     * @return \StructType\SUPP_BLANKET_RESPONSE
     */
    public function setRESULT($rESULT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rESULT) && strlen($rESULT) > 10) || (is_array($rESULT) && count($rESULT) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($rESULT) ? strlen($rESULT) : count($rESULT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rESULT) && !is_string($rESULT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rESULT)), __LINE__);
        }
        if (is_null($rESULT) || (is_array($rESULT) && empty($rESULT))) {
            unset($this->RESULT);
        } else {
            $this->RESULT = $rESULT;
        }
        return $this;
    }
    /**
     * Get ERROR_INFO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getERROR_INFO()
    {
        return isset($this->ERROR_INFO) ? $this->ERROR_INFO : null;
    }
    /**
     * Set ERROR_INFO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eRROR_INFO
     * @return \StructType\SUPP_BLANKET_RESPONSE
     */
    public function setERROR_INFO($eRROR_INFO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eRROR_INFO) && strlen($eRROR_INFO) > 2000) || (is_array($eRROR_INFO) && count($eRROR_INFO) > 2000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2000 element(s) or a scalar of 2000 character(s) at most, "%d" length given', is_scalar($eRROR_INFO) ? strlen($eRROR_INFO) : count($eRROR_INFO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eRROR_INFO) && !is_string($eRROR_INFO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eRROR_INFO)), __LINE__);
        }
        if (is_null($eRROR_INFO) || (is_array($eRROR_INFO) && empty($eRROR_INFO))) {
            unset($this->ERROR_INFO);
        } else {
            $this->ERROR_INFO = $eRROR_INFO;
        }
        return $this;
    }
    /**
     * Get BLANKET value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BLANKET|null
     */
    public function getBLANKET()
    {
        return isset($this->BLANKET) ? $this->BLANKET : null;
    }
    /**
     * Set BLANKET value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BLANKET $bLANKET
     * @return \StructType\SUPP_BLANKET_RESPONSE
     */
    public function setBLANKET(\StructType\BLANKET $bLANKET = null)
    {
        if (is_null($bLANKET) || (is_array($bLANKET) && empty($bLANKET))) {
            unset($this->BLANKET);
        } else {
            $this->BLANKET = $bLANKET;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SUPP_BLANKET_RESPONSE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
