<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVENTORY_PART StructType
 * @subpackage Structs
 */
class INVENTORY_PART extends AbstractStructBase
{
    /**
     * The CONTRACT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CONTRACT;
    /**
     * The PART_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PART_NO;
    /**
     * The ACCOUNTING_GROUP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ACCOUNTING_GROUP;
    /**
     * The ASSET_CLASS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ASSET_CLASS;
    /**
     * The COUNTRY_OF_ORIGIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $COUNTRY_OF_ORIGIN;
    /**
     * The HAZARD_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HAZARD_CODE;
    /**
     * The NOTE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NOTE_ID;
    /**
     * The ESTIMATED_MATERIAL_COST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ESTIMATED_MATERIAL_COST;
    /**
     * The PART_PRODUCT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PART_PRODUCT_CODE;
    /**
     * The PART_PRODUCT_FAMILY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PART_PRODUCT_FAMILY;
    /**
     * The PART_STATUS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PART_STATUS;
    /**
     * The PLANNER_BUYER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PLANNER_BUYER;
    /**
     * The PRIME_COMMODITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PRIME_COMMODITY;
    /**
     * The SECOND_COMMODITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SECOND_COMMODITY;
    /**
     * The UNIT_MEAS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UNIT_MEAS;
    /**
     * The CATCH_UNIT_MEAS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CATCH_UNIT_MEAS;
    /**
     * The DESCRIPTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DESCRIPTION;
    /**
     * The DESCRIPTION_COPY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DESCRIPTION_COPY;
    /**
     * The ABC_CLASS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ABC_CLASS;
    /**
     * The COUNT_VARIANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $COUNT_VARIANCE;
    /**
     * The CREATE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREATE_DATE;
    /**
     * The CYCLE_CODE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYCLE_CODE_DB;
    /**
     * The CYCLE_PERIOD
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CYCLE_PERIOD;
    /**
     * The DIM_QUALITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DIM_QUALITY;
    /**
     * The DURABILITY_DAY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DURABILITY_DAY;
    /**
     * The EXPECTED_LEADTIME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $EXPECTED_LEADTIME;
    /**
     * The LAST_ACTIVITY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LAST_ACTIVITY_DATE;
    /**
     * The LEAD_TIME_CODE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LEAD_TIME_CODE_DB;
    /**
     * The MANUF_LEADTIME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MANUF_LEADTIME;
    /**
     * The NOTE_TEXT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NOTE_TEXT;
    /**
     * The OE_ALLOC_ASSIGN_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OE_ALLOC_ASSIGN_FLAG_DB;
    /**
     * The ONHAND_ANALYSIS_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ONHAND_ANALYSIS_FLAG_DB;
    /**
     * The PURCH_LEADTIME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PURCH_LEADTIME;
    /**
     * The EARLIEST_ULTD_SUPPLY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EARLIEST_ULTD_SUPPLY_DATE;
    /**
     * The SUPERSEDES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPERSEDES;
    /**
     * The SUPPLY_CODE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLY_CODE_DB;
    /**
     * The TYPE_CODE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TYPE_CODE_DB;
    /**
     * The CUSTOMS_STAT_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CUSTOMS_STAT_NO;
    /**
     * The TYPE_DESIGNATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TYPE_DESIGNATION;
    /**
     * The ZERO_COST_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZERO_COST_FLAG_DB;
    /**
     * The AVAIL_ACTIVITY_STATUS_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AVAIL_ACTIVITY_STATUS_DB;
    /**
     * The ENG_ATTRIBUTE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ENG_ATTRIBUTE;
    /**
     * The SHORTAGE_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SHORTAGE_FLAG_DB;
    /**
     * The FORECAST_CONSUMPTION_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FORECAST_CONSUMPTION_FLAG_DB;
    /**
     * The STOCK_MANAGEMENT_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $STOCK_MANAGEMENT_DB;
    /**
     * The INTRASTAT_CONV_FACTOR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $INTRASTAT_CONV_FACTOR;
    /**
     * The PART_COST_GROUP_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PART_COST_GROUP_ID;
    /**
     * The DOP_CONNECTION_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DOP_CONNECTION_DB;
    /**
     * The STD_NAME_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STD_NAME_ID;
    /**
     * The INVENTORY_VALUATION_METHOD_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVENTORY_VALUATION_METHOD_DB;
    /**
     * The NEGATIVE_ON_HAND_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NEGATIVE_ON_HAND_DB;
    /**
     * The TECHNICAL_COORDINATOR_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TECHNICAL_COORDINATOR_ID;
    /**
     * The INVOICE_CONSIDERATION_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVOICE_CONSIDERATION_DB;
    /**
     * The ACTUAL_COST_ACTIVATED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ACTUAL_COST_ACTIVATED;
    /**
     * The MAX_ACTUAL_COST_UPDATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MAX_ACTUAL_COST_UPDATE;
    /**
     * The CUST_WARRANTY_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CUST_WARRANTY_ID;
    /**
     * The SUP_WARRANTY_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SUP_WARRANTY_ID;
    /**
     * The REGION_OF_ORIGIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $REGION_OF_ORIGIN;
    /**
     * The INVENTORY_PART_COST_LEVEL_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVENTORY_PART_COST_LEVEL_DB;
    /**
     * The EXT_SERVICE_COST_METHOD_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EXT_SERVICE_COST_METHOD_DB;
    /**
     * The SUPPLY_CHAIN_PART_GROUP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLY_CHAIN_PART_GROUP;
    /**
     * The AUTOMATIC_CAPABILITY_CHECK_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AUTOMATIC_CAPABILITY_CHECK_DB;
    /**
     * The INPUT_UNIT_MEAS_GROUP_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INPUT_UNIT_MEAS_GROUP_ID;
    /**
     * The DOP_NETTING_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DOP_NETTING_DB;
    /**
     * The CO_RESERVE_ONH_ANALYS_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CO_RESERVE_ONH_ANALYS_FLAG_DB;
    /**
     * The QTY_CALC_ROUNDING
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QTY_CALC_ROUNDING;
    /**
     * The LIFECYCLE_STAGE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LIFECYCLE_STAGE_DB;
    /**
     * The FREQUENCY_CLASS_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FREQUENCY_CLASS_DB;
    /**
     * The FIRST_STAT_ISSUE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FIRST_STAT_ISSUE_DATE;
    /**
     * The LATEST_STAT_ISSUE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LATEST_STAT_ISSUE_DATE;
    /**
     * The DECLINE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DECLINE_DATE;
    /**
     * The EXPIRED_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EXPIRED_DATE;
    /**
     * The DECLINE_ISSUE_COUNTER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DECLINE_ISSUE_COUNTER;
    /**
     * The EXPIRED_ISSUE_COUNTER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $EXPIRED_ISSUE_COUNTER;
    /**
     * The MIN_DURAB_DAYS_CO_DELIV
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MIN_DURAB_DAYS_CO_DELIV;
    /**
     * The MIN_DURAB_DAYS_PLANNING
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MIN_DURAB_DAYS_PLANNING;
    /**
     * The AUTO_CREATED_GTIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AUTO_CREATED_GTIN;
    /**
     * The STORAGE_WIDTH_REQUIREMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STORAGE_WIDTH_REQUIREMENT;
    /**
     * The STORAGE_HEIGHT_REQUIREMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STORAGE_HEIGHT_REQUIREMENT;
    /**
     * The STORAGE_DEPTH_REQUIREMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STORAGE_DEPTH_REQUIREMENT;
    /**
     * The STORAGE_VOLUME_REQUIREMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STORAGE_VOLUME_REQUIREMENT;
    /**
     * The STORAGE_WEIGHT_REQUIREMENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STORAGE_WEIGHT_REQUIREMENT;
    /**
     * The MIN_STORAGE_TEMPERATURE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MIN_STORAGE_TEMPERATURE;
    /**
     * The MAX_STORAGE_TEMPERATURE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MAX_STORAGE_TEMPERATURE;
    /**
     * The MIN_STORAGE_HUMIDITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MIN_STORAGE_HUMIDITY;
    /**
     * The MAX_STORAGE_HUMIDITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MAX_STORAGE_HUMIDITY;
    /**
     * The STANDARD_PUTAWAY_QTY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $STANDARD_PUTAWAY_QTY;
    /**
     * The PALLET_HANDLED_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PALLET_HANDLED_DB;
    /**
     * The PUTAWAY_ZONE_REFILL_OPTION_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PUTAWAY_ZONE_REFILL_OPTION_DB;
    /**
     * The RESET_CONFIG_STD_COST_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RESET_CONFIG_STD_COST_DB;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The C_SEGMENTATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $C_SEGMENTATION;
    /**
     * The COSTS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\COSTS
     */
    public $COSTS;
    /**
     * Constructor method for INVENTORY_PART
     * @uses INVENTORY_PART::setCONTRACT()
     * @uses INVENTORY_PART::setPART_NO()
     * @uses INVENTORY_PART::setACCOUNTING_GROUP()
     * @uses INVENTORY_PART::setASSET_CLASS()
     * @uses INVENTORY_PART::setCOUNTRY_OF_ORIGIN()
     * @uses INVENTORY_PART::setHAZARD_CODE()
     * @uses INVENTORY_PART::setNOTE_ID()
     * @uses INVENTORY_PART::setESTIMATED_MATERIAL_COST()
     * @uses INVENTORY_PART::setPART_PRODUCT_CODE()
     * @uses INVENTORY_PART::setPART_PRODUCT_FAMILY()
     * @uses INVENTORY_PART::setPART_STATUS()
     * @uses INVENTORY_PART::setPLANNER_BUYER()
     * @uses INVENTORY_PART::setPRIME_COMMODITY()
     * @uses INVENTORY_PART::setSECOND_COMMODITY()
     * @uses INVENTORY_PART::setUNIT_MEAS()
     * @uses INVENTORY_PART::setCATCH_UNIT_MEAS()
     * @uses INVENTORY_PART::setDESCRIPTION()
     * @uses INVENTORY_PART::setDESCRIPTION_COPY()
     * @uses INVENTORY_PART::setABC_CLASS()
     * @uses INVENTORY_PART::setCOUNT_VARIANCE()
     * @uses INVENTORY_PART::setCREATE_DATE()
     * @uses INVENTORY_PART::setCYCLE_CODE_DB()
     * @uses INVENTORY_PART::setCYCLE_PERIOD()
     * @uses INVENTORY_PART::setDIM_QUALITY()
     * @uses INVENTORY_PART::setDURABILITY_DAY()
     * @uses INVENTORY_PART::setEXPECTED_LEADTIME()
     * @uses INVENTORY_PART::setLAST_ACTIVITY_DATE()
     * @uses INVENTORY_PART::setLEAD_TIME_CODE_DB()
     * @uses INVENTORY_PART::setMANUF_LEADTIME()
     * @uses INVENTORY_PART::setNOTE_TEXT()
     * @uses INVENTORY_PART::setOE_ALLOC_ASSIGN_FLAG_DB()
     * @uses INVENTORY_PART::setONHAND_ANALYSIS_FLAG_DB()
     * @uses INVENTORY_PART::setPURCH_LEADTIME()
     * @uses INVENTORY_PART::setEARLIEST_ULTD_SUPPLY_DATE()
     * @uses INVENTORY_PART::setSUPERSEDES()
     * @uses INVENTORY_PART::setSUPPLY_CODE_DB()
     * @uses INVENTORY_PART::setTYPE_CODE_DB()
     * @uses INVENTORY_PART::setCUSTOMS_STAT_NO()
     * @uses INVENTORY_PART::setTYPE_DESIGNATION()
     * @uses INVENTORY_PART::setZERO_COST_FLAG_DB()
     * @uses INVENTORY_PART::setAVAIL_ACTIVITY_STATUS_DB()
     * @uses INVENTORY_PART::setENG_ATTRIBUTE()
     * @uses INVENTORY_PART::setSHORTAGE_FLAG_DB()
     * @uses INVENTORY_PART::setFORECAST_CONSUMPTION_FLAG_DB()
     * @uses INVENTORY_PART::setSTOCK_MANAGEMENT_DB()
     * @uses INVENTORY_PART::setINTRASTAT_CONV_FACTOR()
     * @uses INVENTORY_PART::setPART_COST_GROUP_ID()
     * @uses INVENTORY_PART::setDOP_CONNECTION_DB()
     * @uses INVENTORY_PART::setSTD_NAME_ID()
     * @uses INVENTORY_PART::setINVENTORY_VALUATION_METHOD_DB()
     * @uses INVENTORY_PART::setNEGATIVE_ON_HAND_DB()
     * @uses INVENTORY_PART::setTECHNICAL_COORDINATOR_ID()
     * @uses INVENTORY_PART::setINVOICE_CONSIDERATION_DB()
     * @uses INVENTORY_PART::setACTUAL_COST_ACTIVATED()
     * @uses INVENTORY_PART::setMAX_ACTUAL_COST_UPDATE()
     * @uses INVENTORY_PART::setCUST_WARRANTY_ID()
     * @uses INVENTORY_PART::setSUP_WARRANTY_ID()
     * @uses INVENTORY_PART::setREGION_OF_ORIGIN()
     * @uses INVENTORY_PART::setINVENTORY_PART_COST_LEVEL_DB()
     * @uses INVENTORY_PART::setEXT_SERVICE_COST_METHOD_DB()
     * @uses INVENTORY_PART::setSUPPLY_CHAIN_PART_GROUP()
     * @uses INVENTORY_PART::setAUTOMATIC_CAPABILITY_CHECK_DB()
     * @uses INVENTORY_PART::setINPUT_UNIT_MEAS_GROUP_ID()
     * @uses INVENTORY_PART::setDOP_NETTING_DB()
     * @uses INVENTORY_PART::setCO_RESERVE_ONH_ANALYS_FLAG_DB()
     * @uses INVENTORY_PART::setQTY_CALC_ROUNDING()
     * @uses INVENTORY_PART::setLIFECYCLE_STAGE_DB()
     * @uses INVENTORY_PART::setFREQUENCY_CLASS_DB()
     * @uses INVENTORY_PART::setFIRST_STAT_ISSUE_DATE()
     * @uses INVENTORY_PART::setLATEST_STAT_ISSUE_DATE()
     * @uses INVENTORY_PART::setDECLINE_DATE()
     * @uses INVENTORY_PART::setEXPIRED_DATE()
     * @uses INVENTORY_PART::setDECLINE_ISSUE_COUNTER()
     * @uses INVENTORY_PART::setEXPIRED_ISSUE_COUNTER()
     * @uses INVENTORY_PART::setMIN_DURAB_DAYS_CO_DELIV()
     * @uses INVENTORY_PART::setMIN_DURAB_DAYS_PLANNING()
     * @uses INVENTORY_PART::setAUTO_CREATED_GTIN()
     * @uses INVENTORY_PART::setSTORAGE_WIDTH_REQUIREMENT()
     * @uses INVENTORY_PART::setSTORAGE_HEIGHT_REQUIREMENT()
     * @uses INVENTORY_PART::setSTORAGE_DEPTH_REQUIREMENT()
     * @uses INVENTORY_PART::setSTORAGE_VOLUME_REQUIREMENT()
     * @uses INVENTORY_PART::setSTORAGE_WEIGHT_REQUIREMENT()
     * @uses INVENTORY_PART::setMIN_STORAGE_TEMPERATURE()
     * @uses INVENTORY_PART::setMAX_STORAGE_TEMPERATURE()
     * @uses INVENTORY_PART::setMIN_STORAGE_HUMIDITY()
     * @uses INVENTORY_PART::setMAX_STORAGE_HUMIDITY()
     * @uses INVENTORY_PART::setSTANDARD_PUTAWAY_QTY()
     * @uses INVENTORY_PART::setPALLET_HANDLED_DB()
     * @uses INVENTORY_PART::setPUTAWAY_ZONE_REFILL_OPTION_DB()
     * @uses INVENTORY_PART::setRESET_CONFIG_STD_COST_DB()
     * @uses INVENTORY_PART::setOPERATION()
     * @uses INVENTORY_PART::setC_SEGMENTATION()
     * @uses INVENTORY_PART::setCOSTS()
     * @param string $cONTRACT
     * @param string $pART_NO
     * @param string $aCCOUNTING_GROUP
     * @param string $aSSET_CLASS
     * @param string $cOUNTRY_OF_ORIGIN
     * @param string $hAZARD_CODE
     * @param float $nOTE_ID
     * @param float $eSTIMATED_MATERIAL_COST
     * @param string $pART_PRODUCT_CODE
     * @param string $pART_PRODUCT_FAMILY
     * @param string $pART_STATUS
     * @param string $pLANNER_BUYER
     * @param string $pRIME_COMMODITY
     * @param string $sECOND_COMMODITY
     * @param string $uNIT_MEAS
     * @param string $cATCH_UNIT_MEAS
     * @param string $dESCRIPTION
     * @param string $dESCRIPTION_COPY
     * @param string $aBC_CLASS
     * @param float $cOUNT_VARIANCE
     * @param string $cREATE_DATE
     * @param string $cYCLE_CODE_DB
     * @param float $cYCLE_PERIOD
     * @param string $dIM_QUALITY
     * @param float $dURABILITY_DAY
     * @param float $eXPECTED_LEADTIME
     * @param string $lAST_ACTIVITY_DATE
     * @param string $lEAD_TIME_CODE_DB
     * @param float $mANUF_LEADTIME
     * @param string $nOTE_TEXT
     * @param string $oE_ALLOC_ASSIGN_FLAG_DB
     * @param string $oNHAND_ANALYSIS_FLAG_DB
     * @param float $pURCH_LEADTIME
     * @param string $eARLIEST_ULTD_SUPPLY_DATE
     * @param string $sUPERSEDES
     * @param string $sUPPLY_CODE_DB
     * @param string $tYPE_CODE_DB
     * @param string $cUSTOMS_STAT_NO
     * @param string $tYPE_DESIGNATION
     * @param string $zERO_COST_FLAG_DB
     * @param string $aVAIL_ACTIVITY_STATUS_DB
     * @param string $eNG_ATTRIBUTE
     * @param string $sHORTAGE_FLAG_DB
     * @param string $fORECAST_CONSUMPTION_FLAG_DB
     * @param string $sTOCK_MANAGEMENT_DB
     * @param float $iNTRASTAT_CONV_FACTOR
     * @param string $pART_COST_GROUP_ID
     * @param string $dOP_CONNECTION_DB
     * @param float $sTD_NAME_ID
     * @param string $iNVENTORY_VALUATION_METHOD_DB
     * @param string $nEGATIVE_ON_HAND_DB
     * @param string $tECHNICAL_COORDINATOR_ID
     * @param string $iNVOICE_CONSIDERATION_DB
     * @param string $aCTUAL_COST_ACTIVATED
     * @param float $mAX_ACTUAL_COST_UPDATE
     * @param float $cUST_WARRANTY_ID
     * @param float $sUP_WARRANTY_ID
     * @param string $rEGION_OF_ORIGIN
     * @param string $iNVENTORY_PART_COST_LEVEL_DB
     * @param string $eXT_SERVICE_COST_METHOD_DB
     * @param string $sUPPLY_CHAIN_PART_GROUP
     * @param string $aUTOMATIC_CAPABILITY_CHECK_DB
     * @param string $iNPUT_UNIT_MEAS_GROUP_ID
     * @param string $dOP_NETTING_DB
     * @param string $cO_RESERVE_ONH_ANALYS_FLAG_DB
     * @param float $qTY_CALC_ROUNDING
     * @param string $lIFECYCLE_STAGE_DB
     * @param string $fREQUENCY_CLASS_DB
     * @param string $fIRST_STAT_ISSUE_DATE
     * @param string $lATEST_STAT_ISSUE_DATE
     * @param string $dECLINE_DATE
     * @param string $eXPIRED_DATE
     * @param float $dECLINE_ISSUE_COUNTER
     * @param float $eXPIRED_ISSUE_COUNTER
     * @param float $mIN_DURAB_DAYS_CO_DELIV
     * @param float $mIN_DURAB_DAYS_PLANNING
     * @param string $aUTO_CREATED_GTIN
     * @param float $sTORAGE_WIDTH_REQUIREMENT
     * @param float $sTORAGE_HEIGHT_REQUIREMENT
     * @param float $sTORAGE_DEPTH_REQUIREMENT
     * @param float $sTORAGE_VOLUME_REQUIREMENT
     * @param float $sTORAGE_WEIGHT_REQUIREMENT
     * @param float $mIN_STORAGE_TEMPERATURE
     * @param float $mAX_STORAGE_TEMPERATURE
     * @param float $mIN_STORAGE_HUMIDITY
     * @param float $mAX_STORAGE_HUMIDITY
     * @param float $sTANDARD_PUTAWAY_QTY
     * @param string $pALLET_HANDLED_DB
     * @param string $pUTAWAY_ZONE_REFILL_OPTION_DB
     * @param string $rESET_CONFIG_STD_COST_DB
     * @param string $oPERATION
     * @param string $c_SEGMENTATION
     * @param \StructType\COSTS $cOSTS
     */
    public function __construct($cONTRACT = null, $pART_NO = null, $aCCOUNTING_GROUP = null, $aSSET_CLASS = null, $cOUNTRY_OF_ORIGIN = null, $hAZARD_CODE = null, $nOTE_ID = null, $eSTIMATED_MATERIAL_COST = null, $pART_PRODUCT_CODE = null, $pART_PRODUCT_FAMILY = null, $pART_STATUS = null, $pLANNER_BUYER = null, $pRIME_COMMODITY = null, $sECOND_COMMODITY = null, $uNIT_MEAS = null, $cATCH_UNIT_MEAS = null, $dESCRIPTION = null, $dESCRIPTION_COPY = null, $aBC_CLASS = null, $cOUNT_VARIANCE = null, $cREATE_DATE = null, $cYCLE_CODE_DB = null, $cYCLE_PERIOD = null, $dIM_QUALITY = null, $dURABILITY_DAY = null, $eXPECTED_LEADTIME = null, $lAST_ACTIVITY_DATE = null, $lEAD_TIME_CODE_DB = null, $mANUF_LEADTIME = null, $nOTE_TEXT = null, $oE_ALLOC_ASSIGN_FLAG_DB = null, $oNHAND_ANALYSIS_FLAG_DB = null, $pURCH_LEADTIME = null, $eARLIEST_ULTD_SUPPLY_DATE = null, $sUPERSEDES = null, $sUPPLY_CODE_DB = null, $tYPE_CODE_DB = null, $cUSTOMS_STAT_NO = null, $tYPE_DESIGNATION = null, $zERO_COST_FLAG_DB = null, $aVAIL_ACTIVITY_STATUS_DB = null, $eNG_ATTRIBUTE = null, $sHORTAGE_FLAG_DB = null, $fORECAST_CONSUMPTION_FLAG_DB = null, $sTOCK_MANAGEMENT_DB = null, $iNTRASTAT_CONV_FACTOR = null, $pART_COST_GROUP_ID = null, $dOP_CONNECTION_DB = null, $sTD_NAME_ID = null, $iNVENTORY_VALUATION_METHOD_DB = null, $nEGATIVE_ON_HAND_DB = null, $tECHNICAL_COORDINATOR_ID = null, $iNVOICE_CONSIDERATION_DB = null, $aCTUAL_COST_ACTIVATED = null, $mAX_ACTUAL_COST_UPDATE = null, $cUST_WARRANTY_ID = null, $sUP_WARRANTY_ID = null, $rEGION_OF_ORIGIN = null, $iNVENTORY_PART_COST_LEVEL_DB = null, $eXT_SERVICE_COST_METHOD_DB = null, $sUPPLY_CHAIN_PART_GROUP = null, $aUTOMATIC_CAPABILITY_CHECK_DB = null, $iNPUT_UNIT_MEAS_GROUP_ID = null, $dOP_NETTING_DB = null, $cO_RESERVE_ONH_ANALYS_FLAG_DB = null, $qTY_CALC_ROUNDING = null, $lIFECYCLE_STAGE_DB = null, $fREQUENCY_CLASS_DB = null, $fIRST_STAT_ISSUE_DATE = null, $lATEST_STAT_ISSUE_DATE = null, $dECLINE_DATE = null, $eXPIRED_DATE = null, $dECLINE_ISSUE_COUNTER = null, $eXPIRED_ISSUE_COUNTER = null, $mIN_DURAB_DAYS_CO_DELIV = null, $mIN_DURAB_DAYS_PLANNING = null, $aUTO_CREATED_GTIN = null, $sTORAGE_WIDTH_REQUIREMENT = null, $sTORAGE_HEIGHT_REQUIREMENT = null, $sTORAGE_DEPTH_REQUIREMENT = null, $sTORAGE_VOLUME_REQUIREMENT = null, $sTORAGE_WEIGHT_REQUIREMENT = null, $mIN_STORAGE_TEMPERATURE = null, $mAX_STORAGE_TEMPERATURE = null, $mIN_STORAGE_HUMIDITY = null, $mAX_STORAGE_HUMIDITY = null, $sTANDARD_PUTAWAY_QTY = null, $pALLET_HANDLED_DB = null, $pUTAWAY_ZONE_REFILL_OPTION_DB = null, $rESET_CONFIG_STD_COST_DB = null, $oPERATION = null, $c_SEGMENTATION = null, \StructType\COSTS $cOSTS = null)
    {
        $this
            ->setCONTRACT($cONTRACT)
            ->setPART_NO($pART_NO)
            ->setACCOUNTING_GROUP($aCCOUNTING_GROUP)
            ->setASSET_CLASS($aSSET_CLASS)
            ->setCOUNTRY_OF_ORIGIN($cOUNTRY_OF_ORIGIN)
            ->setHAZARD_CODE($hAZARD_CODE)
            ->setNOTE_ID($nOTE_ID)
            ->setESTIMATED_MATERIAL_COST($eSTIMATED_MATERIAL_COST)
            ->setPART_PRODUCT_CODE($pART_PRODUCT_CODE)
            ->setPART_PRODUCT_FAMILY($pART_PRODUCT_FAMILY)
            ->setPART_STATUS($pART_STATUS)
            ->setPLANNER_BUYER($pLANNER_BUYER)
            ->setPRIME_COMMODITY($pRIME_COMMODITY)
            ->setSECOND_COMMODITY($sECOND_COMMODITY)
            ->setUNIT_MEAS($uNIT_MEAS)
            ->setCATCH_UNIT_MEAS($cATCH_UNIT_MEAS)
            ->setDESCRIPTION($dESCRIPTION)
            ->setDESCRIPTION_COPY($dESCRIPTION_COPY)
            ->setABC_CLASS($aBC_CLASS)
            ->setCOUNT_VARIANCE($cOUNT_VARIANCE)
            ->setCREATE_DATE($cREATE_DATE)
            ->setCYCLE_CODE_DB($cYCLE_CODE_DB)
            ->setCYCLE_PERIOD($cYCLE_PERIOD)
            ->setDIM_QUALITY($dIM_QUALITY)
            ->setDURABILITY_DAY($dURABILITY_DAY)
            ->setEXPECTED_LEADTIME($eXPECTED_LEADTIME)
            ->setLAST_ACTIVITY_DATE($lAST_ACTIVITY_DATE)
            ->setLEAD_TIME_CODE_DB($lEAD_TIME_CODE_DB)
            ->setMANUF_LEADTIME($mANUF_LEADTIME)
            ->setNOTE_TEXT($nOTE_TEXT)
            ->setOE_ALLOC_ASSIGN_FLAG_DB($oE_ALLOC_ASSIGN_FLAG_DB)
            ->setONHAND_ANALYSIS_FLAG_DB($oNHAND_ANALYSIS_FLAG_DB)
            ->setPURCH_LEADTIME($pURCH_LEADTIME)
            ->setEARLIEST_ULTD_SUPPLY_DATE($eARLIEST_ULTD_SUPPLY_DATE)
            ->setSUPERSEDES($sUPERSEDES)
            ->setSUPPLY_CODE_DB($sUPPLY_CODE_DB)
            ->setTYPE_CODE_DB($tYPE_CODE_DB)
            ->setCUSTOMS_STAT_NO($cUSTOMS_STAT_NO)
            ->setTYPE_DESIGNATION($tYPE_DESIGNATION)
            ->setZERO_COST_FLAG_DB($zERO_COST_FLAG_DB)
            ->setAVAIL_ACTIVITY_STATUS_DB($aVAIL_ACTIVITY_STATUS_DB)
            ->setENG_ATTRIBUTE($eNG_ATTRIBUTE)
            ->setSHORTAGE_FLAG_DB($sHORTAGE_FLAG_DB)
            ->setFORECAST_CONSUMPTION_FLAG_DB($fORECAST_CONSUMPTION_FLAG_DB)
            ->setSTOCK_MANAGEMENT_DB($sTOCK_MANAGEMENT_DB)
            ->setINTRASTAT_CONV_FACTOR($iNTRASTAT_CONV_FACTOR)
            ->setPART_COST_GROUP_ID($pART_COST_GROUP_ID)
            ->setDOP_CONNECTION_DB($dOP_CONNECTION_DB)
            ->setSTD_NAME_ID($sTD_NAME_ID)
            ->setINVENTORY_VALUATION_METHOD_DB($iNVENTORY_VALUATION_METHOD_DB)
            ->setNEGATIVE_ON_HAND_DB($nEGATIVE_ON_HAND_DB)
            ->setTECHNICAL_COORDINATOR_ID($tECHNICAL_COORDINATOR_ID)
            ->setINVOICE_CONSIDERATION_DB($iNVOICE_CONSIDERATION_DB)
            ->setACTUAL_COST_ACTIVATED($aCTUAL_COST_ACTIVATED)
            ->setMAX_ACTUAL_COST_UPDATE($mAX_ACTUAL_COST_UPDATE)
            ->setCUST_WARRANTY_ID($cUST_WARRANTY_ID)
            ->setSUP_WARRANTY_ID($sUP_WARRANTY_ID)
            ->setREGION_OF_ORIGIN($rEGION_OF_ORIGIN)
            ->setINVENTORY_PART_COST_LEVEL_DB($iNVENTORY_PART_COST_LEVEL_DB)
            ->setEXT_SERVICE_COST_METHOD_DB($eXT_SERVICE_COST_METHOD_DB)
            ->setSUPPLY_CHAIN_PART_GROUP($sUPPLY_CHAIN_PART_GROUP)
            ->setAUTOMATIC_CAPABILITY_CHECK_DB($aUTOMATIC_CAPABILITY_CHECK_DB)
            ->setINPUT_UNIT_MEAS_GROUP_ID($iNPUT_UNIT_MEAS_GROUP_ID)
            ->setDOP_NETTING_DB($dOP_NETTING_DB)
            ->setCO_RESERVE_ONH_ANALYS_FLAG_DB($cO_RESERVE_ONH_ANALYS_FLAG_DB)
            ->setQTY_CALC_ROUNDING($qTY_CALC_ROUNDING)
            ->setLIFECYCLE_STAGE_DB($lIFECYCLE_STAGE_DB)
            ->setFREQUENCY_CLASS_DB($fREQUENCY_CLASS_DB)
            ->setFIRST_STAT_ISSUE_DATE($fIRST_STAT_ISSUE_DATE)
            ->setLATEST_STAT_ISSUE_DATE($lATEST_STAT_ISSUE_DATE)
            ->setDECLINE_DATE($dECLINE_DATE)
            ->setEXPIRED_DATE($eXPIRED_DATE)
            ->setDECLINE_ISSUE_COUNTER($dECLINE_ISSUE_COUNTER)
            ->setEXPIRED_ISSUE_COUNTER($eXPIRED_ISSUE_COUNTER)
            ->setMIN_DURAB_DAYS_CO_DELIV($mIN_DURAB_DAYS_CO_DELIV)
            ->setMIN_DURAB_DAYS_PLANNING($mIN_DURAB_DAYS_PLANNING)
            ->setAUTO_CREATED_GTIN($aUTO_CREATED_GTIN)
            ->setSTORAGE_WIDTH_REQUIREMENT($sTORAGE_WIDTH_REQUIREMENT)
            ->setSTORAGE_HEIGHT_REQUIREMENT($sTORAGE_HEIGHT_REQUIREMENT)
            ->setSTORAGE_DEPTH_REQUIREMENT($sTORAGE_DEPTH_REQUIREMENT)
            ->setSTORAGE_VOLUME_REQUIREMENT($sTORAGE_VOLUME_REQUIREMENT)
            ->setSTORAGE_WEIGHT_REQUIREMENT($sTORAGE_WEIGHT_REQUIREMENT)
            ->setMIN_STORAGE_TEMPERATURE($mIN_STORAGE_TEMPERATURE)
            ->setMAX_STORAGE_TEMPERATURE($mAX_STORAGE_TEMPERATURE)
            ->setMIN_STORAGE_HUMIDITY($mIN_STORAGE_HUMIDITY)
            ->setMAX_STORAGE_HUMIDITY($mAX_STORAGE_HUMIDITY)
            ->setSTANDARD_PUTAWAY_QTY($sTANDARD_PUTAWAY_QTY)
            ->setPALLET_HANDLED_DB($pALLET_HANDLED_DB)
            ->setPUTAWAY_ZONE_REFILL_OPTION_DB($pUTAWAY_ZONE_REFILL_OPTION_DB)
            ->setRESET_CONFIG_STD_COST_DB($rESET_CONFIG_STD_COST_DB)
            ->setOPERATION($oPERATION)
            ->setC_SEGMENTATION($c_SEGMENTATION)
            ->setCOSTS($cOSTS);
    }
    /**
     * Get CONTRACT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCONTRACT()
    {
        return isset($this->CONTRACT) ? $this->CONTRACT : null;
    }
    /**
     * Set CONTRACT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cONTRACT
     * @return \StructType\INVENTORY_PART
     */
    public function setCONTRACT($cONTRACT = null)
    {
        // validation for constraint: string
        if (!is_null($cONTRACT) && !is_string($cONTRACT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cONTRACT)), __LINE__);
        }
        if (is_null($cONTRACT) || (is_array($cONTRACT) && empty($cONTRACT))) {
            unset($this->CONTRACT);
        } else {
            $this->CONTRACT = $cONTRACT;
        }
        return $this;
    }
    /**
     * Get PART_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPART_NO()
    {
        return isset($this->PART_NO) ? $this->PART_NO : null;
    }
    /**
     * Set PART_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pART_NO
     * @return \StructType\INVENTORY_PART
     */
    public function setPART_NO($pART_NO = null)
    {
        // validation for constraint: string
        if (!is_null($pART_NO) && !is_string($pART_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pART_NO)), __LINE__);
        }
        if (is_null($pART_NO) || (is_array($pART_NO) && empty($pART_NO))) {
            unset($this->PART_NO);
        } else {
            $this->PART_NO = $pART_NO;
        }
        return $this;
    }
    /**
     * Get ACCOUNTING_GROUP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getACCOUNTING_GROUP()
    {
        return isset($this->ACCOUNTING_GROUP) ? $this->ACCOUNTING_GROUP : null;
    }
    /**
     * Set ACCOUNTING_GROUP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aCCOUNTING_GROUP
     * @return \StructType\INVENTORY_PART
     */
    public function setACCOUNTING_GROUP($aCCOUNTING_GROUP = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNTING_GROUP) && !is_string($aCCOUNTING_GROUP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCCOUNTING_GROUP)), __LINE__);
        }
        if (is_null($aCCOUNTING_GROUP) || (is_array($aCCOUNTING_GROUP) && empty($aCCOUNTING_GROUP))) {
            unset($this->ACCOUNTING_GROUP);
        } else {
            $this->ACCOUNTING_GROUP = $aCCOUNTING_GROUP;
        }
        return $this;
    }
    /**
     * Get ASSET_CLASS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getASSET_CLASS()
    {
        return isset($this->ASSET_CLASS) ? $this->ASSET_CLASS : null;
    }
    /**
     * Set ASSET_CLASS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aSSET_CLASS
     * @return \StructType\INVENTORY_PART
     */
    public function setASSET_CLASS($aSSET_CLASS = null)
    {
        // validation for constraint: string
        if (!is_null($aSSET_CLASS) && !is_string($aSSET_CLASS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aSSET_CLASS)), __LINE__);
        }
        if (is_null($aSSET_CLASS) || (is_array($aSSET_CLASS) && empty($aSSET_CLASS))) {
            unset($this->ASSET_CLASS);
        } else {
            $this->ASSET_CLASS = $aSSET_CLASS;
        }
        return $this;
    }
    /**
     * Get COUNTRY_OF_ORIGIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOUNTRY_OF_ORIGIN()
    {
        return isset($this->COUNTRY_OF_ORIGIN) ? $this->COUNTRY_OF_ORIGIN : null;
    }
    /**
     * Set COUNTRY_OF_ORIGIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOUNTRY_OF_ORIGIN
     * @return \StructType\INVENTORY_PART
     */
    public function setCOUNTRY_OF_ORIGIN($cOUNTRY_OF_ORIGIN = null)
    {
        // validation for constraint: string
        if (!is_null($cOUNTRY_OF_ORIGIN) && !is_string($cOUNTRY_OF_ORIGIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOUNTRY_OF_ORIGIN)), __LINE__);
        }
        if (is_null($cOUNTRY_OF_ORIGIN) || (is_array($cOUNTRY_OF_ORIGIN) && empty($cOUNTRY_OF_ORIGIN))) {
            unset($this->COUNTRY_OF_ORIGIN);
        } else {
            $this->COUNTRY_OF_ORIGIN = $cOUNTRY_OF_ORIGIN;
        }
        return $this;
    }
    /**
     * Get HAZARD_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHAZARD_CODE()
    {
        return isset($this->HAZARD_CODE) ? $this->HAZARD_CODE : null;
    }
    /**
     * Set HAZARD_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hAZARD_CODE
     * @return \StructType\INVENTORY_PART
     */
    public function setHAZARD_CODE($hAZARD_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($hAZARD_CODE) && !is_string($hAZARD_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hAZARD_CODE)), __LINE__);
        }
        if (is_null($hAZARD_CODE) || (is_array($hAZARD_CODE) && empty($hAZARD_CODE))) {
            unset($this->HAZARD_CODE);
        } else {
            $this->HAZARD_CODE = $hAZARD_CODE;
        }
        return $this;
    }
    /**
     * Get NOTE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNOTE_ID()
    {
        return isset($this->NOTE_ID) ? $this->NOTE_ID : null;
    }
    /**
     * Set NOTE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nOTE_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setNOTE_ID($nOTE_ID = null)
    {
        if (is_null($nOTE_ID) || (is_array($nOTE_ID) && empty($nOTE_ID))) {
            unset($this->NOTE_ID);
        } else {
            $this->NOTE_ID = $nOTE_ID;
        }
        return $this;
    }
    /**
     * Get ESTIMATED_MATERIAL_COST value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getESTIMATED_MATERIAL_COST()
    {
        return isset($this->ESTIMATED_MATERIAL_COST) ? $this->ESTIMATED_MATERIAL_COST : null;
    }
    /**
     * Set ESTIMATED_MATERIAL_COST value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eSTIMATED_MATERIAL_COST
     * @return \StructType\INVENTORY_PART
     */
    public function setESTIMATED_MATERIAL_COST($eSTIMATED_MATERIAL_COST = null)
    {
        if (is_null($eSTIMATED_MATERIAL_COST) || (is_array($eSTIMATED_MATERIAL_COST) && empty($eSTIMATED_MATERIAL_COST))) {
            unset($this->ESTIMATED_MATERIAL_COST);
        } else {
            $this->ESTIMATED_MATERIAL_COST = $eSTIMATED_MATERIAL_COST;
        }
        return $this;
    }
    /**
     * Get PART_PRODUCT_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPART_PRODUCT_CODE()
    {
        return isset($this->PART_PRODUCT_CODE) ? $this->PART_PRODUCT_CODE : null;
    }
    /**
     * Set PART_PRODUCT_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pART_PRODUCT_CODE
     * @return \StructType\INVENTORY_PART
     */
    public function setPART_PRODUCT_CODE($pART_PRODUCT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($pART_PRODUCT_CODE) && !is_string($pART_PRODUCT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pART_PRODUCT_CODE)), __LINE__);
        }
        if (is_null($pART_PRODUCT_CODE) || (is_array($pART_PRODUCT_CODE) && empty($pART_PRODUCT_CODE))) {
            unset($this->PART_PRODUCT_CODE);
        } else {
            $this->PART_PRODUCT_CODE = $pART_PRODUCT_CODE;
        }
        return $this;
    }
    /**
     * Get PART_PRODUCT_FAMILY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPART_PRODUCT_FAMILY()
    {
        return isset($this->PART_PRODUCT_FAMILY) ? $this->PART_PRODUCT_FAMILY : null;
    }
    /**
     * Set PART_PRODUCT_FAMILY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pART_PRODUCT_FAMILY
     * @return \StructType\INVENTORY_PART
     */
    public function setPART_PRODUCT_FAMILY($pART_PRODUCT_FAMILY = null)
    {
        // validation for constraint: string
        if (!is_null($pART_PRODUCT_FAMILY) && !is_string($pART_PRODUCT_FAMILY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pART_PRODUCT_FAMILY)), __LINE__);
        }
        if (is_null($pART_PRODUCT_FAMILY) || (is_array($pART_PRODUCT_FAMILY) && empty($pART_PRODUCT_FAMILY))) {
            unset($this->PART_PRODUCT_FAMILY);
        } else {
            $this->PART_PRODUCT_FAMILY = $pART_PRODUCT_FAMILY;
        }
        return $this;
    }
    /**
     * Get PART_STATUS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPART_STATUS()
    {
        return isset($this->PART_STATUS) ? $this->PART_STATUS : null;
    }
    /**
     * Set PART_STATUS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pART_STATUS
     * @return \StructType\INVENTORY_PART
     */
    public function setPART_STATUS($pART_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($pART_STATUS) && !is_string($pART_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pART_STATUS)), __LINE__);
        }
        if (is_null($pART_STATUS) || (is_array($pART_STATUS) && empty($pART_STATUS))) {
            unset($this->PART_STATUS);
        } else {
            $this->PART_STATUS = $pART_STATUS;
        }
        return $this;
    }
    /**
     * Get PLANNER_BUYER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPLANNER_BUYER()
    {
        return isset($this->PLANNER_BUYER) ? $this->PLANNER_BUYER : null;
    }
    /**
     * Set PLANNER_BUYER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pLANNER_BUYER
     * @return \StructType\INVENTORY_PART
     */
    public function setPLANNER_BUYER($pLANNER_BUYER = null)
    {
        // validation for constraint: string
        if (!is_null($pLANNER_BUYER) && !is_string($pLANNER_BUYER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pLANNER_BUYER)), __LINE__);
        }
        if (is_null($pLANNER_BUYER) || (is_array($pLANNER_BUYER) && empty($pLANNER_BUYER))) {
            unset($this->PLANNER_BUYER);
        } else {
            $this->PLANNER_BUYER = $pLANNER_BUYER;
        }
        return $this;
    }
    /**
     * Get PRIME_COMMODITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPRIME_COMMODITY()
    {
        return isset($this->PRIME_COMMODITY) ? $this->PRIME_COMMODITY : null;
    }
    /**
     * Set PRIME_COMMODITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pRIME_COMMODITY
     * @return \StructType\INVENTORY_PART
     */
    public function setPRIME_COMMODITY($pRIME_COMMODITY = null)
    {
        // validation for constraint: string
        if (!is_null($pRIME_COMMODITY) && !is_string($pRIME_COMMODITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRIME_COMMODITY)), __LINE__);
        }
        if (is_null($pRIME_COMMODITY) || (is_array($pRIME_COMMODITY) && empty($pRIME_COMMODITY))) {
            unset($this->PRIME_COMMODITY);
        } else {
            $this->PRIME_COMMODITY = $pRIME_COMMODITY;
        }
        return $this;
    }
    /**
     * Get SECOND_COMMODITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSECOND_COMMODITY()
    {
        return isset($this->SECOND_COMMODITY) ? $this->SECOND_COMMODITY : null;
    }
    /**
     * Set SECOND_COMMODITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sECOND_COMMODITY
     * @return \StructType\INVENTORY_PART
     */
    public function setSECOND_COMMODITY($sECOND_COMMODITY = null)
    {
        // validation for constraint: string
        if (!is_null($sECOND_COMMODITY) && !is_string($sECOND_COMMODITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sECOND_COMMODITY)), __LINE__);
        }
        if (is_null($sECOND_COMMODITY) || (is_array($sECOND_COMMODITY) && empty($sECOND_COMMODITY))) {
            unset($this->SECOND_COMMODITY);
        } else {
            $this->SECOND_COMMODITY = $sECOND_COMMODITY;
        }
        return $this;
    }
    /**
     * Get UNIT_MEAS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUNIT_MEAS()
    {
        return isset($this->UNIT_MEAS) ? $this->UNIT_MEAS : null;
    }
    /**
     * Set UNIT_MEAS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uNIT_MEAS
     * @return \StructType\INVENTORY_PART
     */
    public function setUNIT_MEAS($uNIT_MEAS = null)
    {
        // validation for constraint: string
        if (!is_null($uNIT_MEAS) && !is_string($uNIT_MEAS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uNIT_MEAS)), __LINE__);
        }
        if (is_null($uNIT_MEAS) || (is_array($uNIT_MEAS) && empty($uNIT_MEAS))) {
            unset($this->UNIT_MEAS);
        } else {
            $this->UNIT_MEAS = $uNIT_MEAS;
        }
        return $this;
    }
    /**
     * Get CATCH_UNIT_MEAS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCATCH_UNIT_MEAS()
    {
        return isset($this->CATCH_UNIT_MEAS) ? $this->CATCH_UNIT_MEAS : null;
    }
    /**
     * Set CATCH_UNIT_MEAS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cATCH_UNIT_MEAS
     * @return \StructType\INVENTORY_PART
     */
    public function setCATCH_UNIT_MEAS($cATCH_UNIT_MEAS = null)
    {
        // validation for constraint: string
        if (!is_null($cATCH_UNIT_MEAS) && !is_string($cATCH_UNIT_MEAS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cATCH_UNIT_MEAS)), __LINE__);
        }
        if (is_null($cATCH_UNIT_MEAS) || (is_array($cATCH_UNIT_MEAS) && empty($cATCH_UNIT_MEAS))) {
            unset($this->CATCH_UNIT_MEAS);
        } else {
            $this->CATCH_UNIT_MEAS = $cATCH_UNIT_MEAS;
        }
        return $this;
    }
    /**
     * Get DESCRIPTION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDESCRIPTION()
    {
        return isset($this->DESCRIPTION) ? $this->DESCRIPTION : null;
    }
    /**
     * Set DESCRIPTION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dESCRIPTION
     * @return \StructType\INVENTORY_PART
     */
    public function setDESCRIPTION($dESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($dESCRIPTION) && !is_string($dESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dESCRIPTION)), __LINE__);
        }
        if (is_null($dESCRIPTION) || (is_array($dESCRIPTION) && empty($dESCRIPTION))) {
            unset($this->DESCRIPTION);
        } else {
            $this->DESCRIPTION = $dESCRIPTION;
        }
        return $this;
    }
    /**
     * Get DESCRIPTION_COPY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDESCRIPTION_COPY()
    {
        return isset($this->DESCRIPTION_COPY) ? $this->DESCRIPTION_COPY : null;
    }
    /**
     * Set DESCRIPTION_COPY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dESCRIPTION_COPY
     * @return \StructType\INVENTORY_PART
     */
    public function setDESCRIPTION_COPY($dESCRIPTION_COPY = null)
    {
        // validation for constraint: string
        if (!is_null($dESCRIPTION_COPY) && !is_string($dESCRIPTION_COPY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dESCRIPTION_COPY)), __LINE__);
        }
        if (is_null($dESCRIPTION_COPY) || (is_array($dESCRIPTION_COPY) && empty($dESCRIPTION_COPY))) {
            unset($this->DESCRIPTION_COPY);
        } else {
            $this->DESCRIPTION_COPY = $dESCRIPTION_COPY;
        }
        return $this;
    }
    /**
     * Get ABC_CLASS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getABC_CLASS()
    {
        return isset($this->ABC_CLASS) ? $this->ABC_CLASS : null;
    }
    /**
     * Set ABC_CLASS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aBC_CLASS
     * @return \StructType\INVENTORY_PART
     */
    public function setABC_CLASS($aBC_CLASS = null)
    {
        // validation for constraint: string
        if (!is_null($aBC_CLASS) && !is_string($aBC_CLASS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aBC_CLASS)), __LINE__);
        }
        if (is_null($aBC_CLASS) || (is_array($aBC_CLASS) && empty($aBC_CLASS))) {
            unset($this->ABC_CLASS);
        } else {
            $this->ABC_CLASS = $aBC_CLASS;
        }
        return $this;
    }
    /**
     * Get COUNT_VARIANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCOUNT_VARIANCE()
    {
        return isset($this->COUNT_VARIANCE) ? $this->COUNT_VARIANCE : null;
    }
    /**
     * Set COUNT_VARIANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cOUNT_VARIANCE
     * @return \StructType\INVENTORY_PART
     */
    public function setCOUNT_VARIANCE($cOUNT_VARIANCE = null)
    {
        if (is_null($cOUNT_VARIANCE) || (is_array($cOUNT_VARIANCE) && empty($cOUNT_VARIANCE))) {
            unset($this->COUNT_VARIANCE);
        } else {
            $this->COUNT_VARIANCE = $cOUNT_VARIANCE;
        }
        return $this;
    }
    /**
     * Get CREATE_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREATE_DATE()
    {
        return isset($this->CREATE_DATE) ? $this->CREATE_DATE : null;
    }
    /**
     * Set CREATE_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREATE_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setCREATE_DATE($cREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($cREATE_DATE) && !is_string($cREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREATE_DATE)), __LINE__);
        }
        if (is_null($cREATE_DATE) || (is_array($cREATE_DATE) && empty($cREATE_DATE))) {
            unset($this->CREATE_DATE);
        } else {
            $this->CREATE_DATE = $cREATE_DATE;
        }
        return $this;
    }
    /**
     * Get CYCLE_CODE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYCLE_CODE_DB()
    {
        return isset($this->CYCLE_CODE_DB) ? $this->CYCLE_CODE_DB : null;
    }
    /**
     * Set CYCLE_CODE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYCLE_CODE_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setCYCLE_CODE_DB($cYCLE_CODE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cYCLE_CODE_DB) && !is_string($cYCLE_CODE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cYCLE_CODE_DB)), __LINE__);
        }
        if (is_null($cYCLE_CODE_DB) || (is_array($cYCLE_CODE_DB) && empty($cYCLE_CODE_DB))) {
            unset($this->CYCLE_CODE_DB);
        } else {
            $this->CYCLE_CODE_DB = $cYCLE_CODE_DB;
        }
        return $this;
    }
    /**
     * Get CYCLE_PERIOD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCYCLE_PERIOD()
    {
        return isset($this->CYCLE_PERIOD) ? $this->CYCLE_PERIOD : null;
    }
    /**
     * Set CYCLE_PERIOD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cYCLE_PERIOD
     * @return \StructType\INVENTORY_PART
     */
    public function setCYCLE_PERIOD($cYCLE_PERIOD = null)
    {
        if (is_null($cYCLE_PERIOD) || (is_array($cYCLE_PERIOD) && empty($cYCLE_PERIOD))) {
            unset($this->CYCLE_PERIOD);
        } else {
            $this->CYCLE_PERIOD = $cYCLE_PERIOD;
        }
        return $this;
    }
    /**
     * Get DIM_QUALITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDIM_QUALITY()
    {
        return isset($this->DIM_QUALITY) ? $this->DIM_QUALITY : null;
    }
    /**
     * Set DIM_QUALITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dIM_QUALITY
     * @return \StructType\INVENTORY_PART
     */
    public function setDIM_QUALITY($dIM_QUALITY = null)
    {
        // validation for constraint: string
        if (!is_null($dIM_QUALITY) && !is_string($dIM_QUALITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dIM_QUALITY)), __LINE__);
        }
        if (is_null($dIM_QUALITY) || (is_array($dIM_QUALITY) && empty($dIM_QUALITY))) {
            unset($this->DIM_QUALITY);
        } else {
            $this->DIM_QUALITY = $dIM_QUALITY;
        }
        return $this;
    }
    /**
     * Get DURABILITY_DAY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDURABILITY_DAY()
    {
        return isset($this->DURABILITY_DAY) ? $this->DURABILITY_DAY : null;
    }
    /**
     * Set DURABILITY_DAY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dURABILITY_DAY
     * @return \StructType\INVENTORY_PART
     */
    public function setDURABILITY_DAY($dURABILITY_DAY = null)
    {
        if (is_null($dURABILITY_DAY) || (is_array($dURABILITY_DAY) && empty($dURABILITY_DAY))) {
            unset($this->DURABILITY_DAY);
        } else {
            $this->DURABILITY_DAY = $dURABILITY_DAY;
        }
        return $this;
    }
    /**
     * Get EXPECTED_LEADTIME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEXPECTED_LEADTIME()
    {
        return isset($this->EXPECTED_LEADTIME) ? $this->EXPECTED_LEADTIME : null;
    }
    /**
     * Set EXPECTED_LEADTIME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eXPECTED_LEADTIME
     * @return \StructType\INVENTORY_PART
     */
    public function setEXPECTED_LEADTIME($eXPECTED_LEADTIME = null)
    {
        if (is_null($eXPECTED_LEADTIME) || (is_array($eXPECTED_LEADTIME) && empty($eXPECTED_LEADTIME))) {
            unset($this->EXPECTED_LEADTIME);
        } else {
            $this->EXPECTED_LEADTIME = $eXPECTED_LEADTIME;
        }
        return $this;
    }
    /**
     * Get LAST_ACTIVITY_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLAST_ACTIVITY_DATE()
    {
        return isset($this->LAST_ACTIVITY_DATE) ? $this->LAST_ACTIVITY_DATE : null;
    }
    /**
     * Set LAST_ACTIVITY_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lAST_ACTIVITY_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setLAST_ACTIVITY_DATE($lAST_ACTIVITY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($lAST_ACTIVITY_DATE) && !is_string($lAST_ACTIVITY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lAST_ACTIVITY_DATE)), __LINE__);
        }
        if (is_null($lAST_ACTIVITY_DATE) || (is_array($lAST_ACTIVITY_DATE) && empty($lAST_ACTIVITY_DATE))) {
            unset($this->LAST_ACTIVITY_DATE);
        } else {
            $this->LAST_ACTIVITY_DATE = $lAST_ACTIVITY_DATE;
        }
        return $this;
    }
    /**
     * Get LEAD_TIME_CODE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLEAD_TIME_CODE_DB()
    {
        return isset($this->LEAD_TIME_CODE_DB) ? $this->LEAD_TIME_CODE_DB : null;
    }
    /**
     * Set LEAD_TIME_CODE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lEAD_TIME_CODE_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setLEAD_TIME_CODE_DB($lEAD_TIME_CODE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($lEAD_TIME_CODE_DB) && !is_string($lEAD_TIME_CODE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEAD_TIME_CODE_DB)), __LINE__);
        }
        if (is_null($lEAD_TIME_CODE_DB) || (is_array($lEAD_TIME_CODE_DB) && empty($lEAD_TIME_CODE_DB))) {
            unset($this->LEAD_TIME_CODE_DB);
        } else {
            $this->LEAD_TIME_CODE_DB = $lEAD_TIME_CODE_DB;
        }
        return $this;
    }
    /**
     * Get MANUF_LEADTIME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMANUF_LEADTIME()
    {
        return isset($this->MANUF_LEADTIME) ? $this->MANUF_LEADTIME : null;
    }
    /**
     * Set MANUF_LEADTIME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mANUF_LEADTIME
     * @return \StructType\INVENTORY_PART
     */
    public function setMANUF_LEADTIME($mANUF_LEADTIME = null)
    {
        if (is_null($mANUF_LEADTIME) || (is_array($mANUF_LEADTIME) && empty($mANUF_LEADTIME))) {
            unset($this->MANUF_LEADTIME);
        } else {
            $this->MANUF_LEADTIME = $mANUF_LEADTIME;
        }
        return $this;
    }
    /**
     * Get NOTE_TEXT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNOTE_TEXT()
    {
        return isset($this->NOTE_TEXT) ? $this->NOTE_TEXT : null;
    }
    /**
     * Set NOTE_TEXT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nOTE_TEXT
     * @return \StructType\INVENTORY_PART
     */
    public function setNOTE_TEXT($nOTE_TEXT = null)
    {
        // validation for constraint: string
        if (!is_null($nOTE_TEXT) && !is_string($nOTE_TEXT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nOTE_TEXT)), __LINE__);
        }
        if (is_null($nOTE_TEXT) || (is_array($nOTE_TEXT) && empty($nOTE_TEXT))) {
            unset($this->NOTE_TEXT);
        } else {
            $this->NOTE_TEXT = $nOTE_TEXT;
        }
        return $this;
    }
    /**
     * Get OE_ALLOC_ASSIGN_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOE_ALLOC_ASSIGN_FLAG_DB()
    {
        return isset($this->OE_ALLOC_ASSIGN_FLAG_DB) ? $this->OE_ALLOC_ASSIGN_FLAG_DB : null;
    }
    /**
     * Set OE_ALLOC_ASSIGN_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oE_ALLOC_ASSIGN_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setOE_ALLOC_ASSIGN_FLAG_DB($oE_ALLOC_ASSIGN_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($oE_ALLOC_ASSIGN_FLAG_DB) && !is_string($oE_ALLOC_ASSIGN_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oE_ALLOC_ASSIGN_FLAG_DB)), __LINE__);
        }
        if (is_null($oE_ALLOC_ASSIGN_FLAG_DB) || (is_array($oE_ALLOC_ASSIGN_FLAG_DB) && empty($oE_ALLOC_ASSIGN_FLAG_DB))) {
            unset($this->OE_ALLOC_ASSIGN_FLAG_DB);
        } else {
            $this->OE_ALLOC_ASSIGN_FLAG_DB = $oE_ALLOC_ASSIGN_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get ONHAND_ANALYSIS_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getONHAND_ANALYSIS_FLAG_DB()
    {
        return isset($this->ONHAND_ANALYSIS_FLAG_DB) ? $this->ONHAND_ANALYSIS_FLAG_DB : null;
    }
    /**
     * Set ONHAND_ANALYSIS_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oNHAND_ANALYSIS_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setONHAND_ANALYSIS_FLAG_DB($oNHAND_ANALYSIS_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($oNHAND_ANALYSIS_FLAG_DB) && !is_string($oNHAND_ANALYSIS_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oNHAND_ANALYSIS_FLAG_DB)), __LINE__);
        }
        if (is_null($oNHAND_ANALYSIS_FLAG_DB) || (is_array($oNHAND_ANALYSIS_FLAG_DB) && empty($oNHAND_ANALYSIS_FLAG_DB))) {
            unset($this->ONHAND_ANALYSIS_FLAG_DB);
        } else {
            $this->ONHAND_ANALYSIS_FLAG_DB = $oNHAND_ANALYSIS_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get PURCH_LEADTIME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPURCH_LEADTIME()
    {
        return isset($this->PURCH_LEADTIME) ? $this->PURCH_LEADTIME : null;
    }
    /**
     * Set PURCH_LEADTIME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pURCH_LEADTIME
     * @return \StructType\INVENTORY_PART
     */
    public function setPURCH_LEADTIME($pURCH_LEADTIME = null)
    {
        if (is_null($pURCH_LEADTIME) || (is_array($pURCH_LEADTIME) && empty($pURCH_LEADTIME))) {
            unset($this->PURCH_LEADTIME);
        } else {
            $this->PURCH_LEADTIME = $pURCH_LEADTIME;
        }
        return $this;
    }
    /**
     * Get EARLIEST_ULTD_SUPPLY_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEARLIEST_ULTD_SUPPLY_DATE()
    {
        return isset($this->EARLIEST_ULTD_SUPPLY_DATE) ? $this->EARLIEST_ULTD_SUPPLY_DATE : null;
    }
    /**
     * Set EARLIEST_ULTD_SUPPLY_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eARLIEST_ULTD_SUPPLY_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setEARLIEST_ULTD_SUPPLY_DATE($eARLIEST_ULTD_SUPPLY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($eARLIEST_ULTD_SUPPLY_DATE) && !is_string($eARLIEST_ULTD_SUPPLY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eARLIEST_ULTD_SUPPLY_DATE)), __LINE__);
        }
        if (is_null($eARLIEST_ULTD_SUPPLY_DATE) || (is_array($eARLIEST_ULTD_SUPPLY_DATE) && empty($eARLIEST_ULTD_SUPPLY_DATE))) {
            unset($this->EARLIEST_ULTD_SUPPLY_DATE);
        } else {
            $this->EARLIEST_ULTD_SUPPLY_DATE = $eARLIEST_ULTD_SUPPLY_DATE;
        }
        return $this;
    }
    /**
     * Get SUPERSEDES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPERSEDES()
    {
        return isset($this->SUPERSEDES) ? $this->SUPERSEDES : null;
    }
    /**
     * Set SUPERSEDES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPERSEDES
     * @return \StructType\INVENTORY_PART
     */
    public function setSUPERSEDES($sUPERSEDES = null)
    {
        // validation for constraint: string
        if (!is_null($sUPERSEDES) && !is_string($sUPERSEDES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPERSEDES)), __LINE__);
        }
        if (is_null($sUPERSEDES) || (is_array($sUPERSEDES) && empty($sUPERSEDES))) {
            unset($this->SUPERSEDES);
        } else {
            $this->SUPERSEDES = $sUPERSEDES;
        }
        return $this;
    }
    /**
     * Get SUPPLY_CODE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLY_CODE_DB()
    {
        return isset($this->SUPPLY_CODE_DB) ? $this->SUPPLY_CODE_DB : null;
    }
    /**
     * Set SUPPLY_CODE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLY_CODE_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setSUPPLY_CODE_DB($sUPPLY_CODE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLY_CODE_DB) && !is_string($sUPPLY_CODE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLY_CODE_DB)), __LINE__);
        }
        if (is_null($sUPPLY_CODE_DB) || (is_array($sUPPLY_CODE_DB) && empty($sUPPLY_CODE_DB))) {
            unset($this->SUPPLY_CODE_DB);
        } else {
            $this->SUPPLY_CODE_DB = $sUPPLY_CODE_DB;
        }
        return $this;
    }
    /**
     * Get TYPE_CODE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTYPE_CODE_DB()
    {
        return isset($this->TYPE_CODE_DB) ? $this->TYPE_CODE_DB : null;
    }
    /**
     * Set TYPE_CODE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tYPE_CODE_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setTYPE_CODE_DB($tYPE_CODE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE_CODE_DB) && !is_string($tYPE_CODE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tYPE_CODE_DB)), __LINE__);
        }
        if (is_null($tYPE_CODE_DB) || (is_array($tYPE_CODE_DB) && empty($tYPE_CODE_DB))) {
            unset($this->TYPE_CODE_DB);
        } else {
            $this->TYPE_CODE_DB = $tYPE_CODE_DB;
        }
        return $this;
    }
    /**
     * Get CUSTOMS_STAT_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMS_STAT_NO()
    {
        return isset($this->CUSTOMS_STAT_NO) ? $this->CUSTOMS_STAT_NO : null;
    }
    /**
     * Set CUSTOMS_STAT_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMS_STAT_NO
     * @return \StructType\INVENTORY_PART
     */
    public function setCUSTOMS_STAT_NO($cUSTOMS_STAT_NO = null)
    {
        // validation for constraint: string
        if (!is_null($cUSTOMS_STAT_NO) && !is_string($cUSTOMS_STAT_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMS_STAT_NO)), __LINE__);
        }
        if (is_null($cUSTOMS_STAT_NO) || (is_array($cUSTOMS_STAT_NO) && empty($cUSTOMS_STAT_NO))) {
            unset($this->CUSTOMS_STAT_NO);
        } else {
            $this->CUSTOMS_STAT_NO = $cUSTOMS_STAT_NO;
        }
        return $this;
    }
    /**
     * Get TYPE_DESIGNATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTYPE_DESIGNATION()
    {
        return isset($this->TYPE_DESIGNATION) ? $this->TYPE_DESIGNATION : null;
    }
    /**
     * Set TYPE_DESIGNATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tYPE_DESIGNATION
     * @return \StructType\INVENTORY_PART
     */
    public function setTYPE_DESIGNATION($tYPE_DESIGNATION = null)
    {
        // validation for constraint: string
        if (!is_null($tYPE_DESIGNATION) && !is_string($tYPE_DESIGNATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tYPE_DESIGNATION)), __LINE__);
        }
        if (is_null($tYPE_DESIGNATION) || (is_array($tYPE_DESIGNATION) && empty($tYPE_DESIGNATION))) {
            unset($this->TYPE_DESIGNATION);
        } else {
            $this->TYPE_DESIGNATION = $tYPE_DESIGNATION;
        }
        return $this;
    }
    /**
     * Get ZERO_COST_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZERO_COST_FLAG_DB()
    {
        return isset($this->ZERO_COST_FLAG_DB) ? $this->ZERO_COST_FLAG_DB : null;
    }
    /**
     * Set ZERO_COST_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zERO_COST_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setZERO_COST_FLAG_DB($zERO_COST_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($zERO_COST_FLAG_DB) && !is_string($zERO_COST_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zERO_COST_FLAG_DB)), __LINE__);
        }
        if (is_null($zERO_COST_FLAG_DB) || (is_array($zERO_COST_FLAG_DB) && empty($zERO_COST_FLAG_DB))) {
            unset($this->ZERO_COST_FLAG_DB);
        } else {
            $this->ZERO_COST_FLAG_DB = $zERO_COST_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get AVAIL_ACTIVITY_STATUS_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAVAIL_ACTIVITY_STATUS_DB()
    {
        return isset($this->AVAIL_ACTIVITY_STATUS_DB) ? $this->AVAIL_ACTIVITY_STATUS_DB : null;
    }
    /**
     * Set AVAIL_ACTIVITY_STATUS_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aVAIL_ACTIVITY_STATUS_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setAVAIL_ACTIVITY_STATUS_DB($aVAIL_ACTIVITY_STATUS_DB = null)
    {
        // validation for constraint: string
        if (!is_null($aVAIL_ACTIVITY_STATUS_DB) && !is_string($aVAIL_ACTIVITY_STATUS_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aVAIL_ACTIVITY_STATUS_DB)), __LINE__);
        }
        if (is_null($aVAIL_ACTIVITY_STATUS_DB) || (is_array($aVAIL_ACTIVITY_STATUS_DB) && empty($aVAIL_ACTIVITY_STATUS_DB))) {
            unset($this->AVAIL_ACTIVITY_STATUS_DB);
        } else {
            $this->AVAIL_ACTIVITY_STATUS_DB = $aVAIL_ACTIVITY_STATUS_DB;
        }
        return $this;
    }
    /**
     * Get ENG_ATTRIBUTE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getENG_ATTRIBUTE()
    {
        return isset($this->ENG_ATTRIBUTE) ? $this->ENG_ATTRIBUTE : null;
    }
    /**
     * Set ENG_ATTRIBUTE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eNG_ATTRIBUTE
     * @return \StructType\INVENTORY_PART
     */
    public function setENG_ATTRIBUTE($eNG_ATTRIBUTE = null)
    {
        // validation for constraint: string
        if (!is_null($eNG_ATTRIBUTE) && !is_string($eNG_ATTRIBUTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eNG_ATTRIBUTE)), __LINE__);
        }
        if (is_null($eNG_ATTRIBUTE) || (is_array($eNG_ATTRIBUTE) && empty($eNG_ATTRIBUTE))) {
            unset($this->ENG_ATTRIBUTE);
        } else {
            $this->ENG_ATTRIBUTE = $eNG_ATTRIBUTE;
        }
        return $this;
    }
    /**
     * Get SHORTAGE_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSHORTAGE_FLAG_DB()
    {
        return isset($this->SHORTAGE_FLAG_DB) ? $this->SHORTAGE_FLAG_DB : null;
    }
    /**
     * Set SHORTAGE_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sHORTAGE_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setSHORTAGE_FLAG_DB($sHORTAGE_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($sHORTAGE_FLAG_DB) && !is_string($sHORTAGE_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sHORTAGE_FLAG_DB)), __LINE__);
        }
        if (is_null($sHORTAGE_FLAG_DB) || (is_array($sHORTAGE_FLAG_DB) && empty($sHORTAGE_FLAG_DB))) {
            unset($this->SHORTAGE_FLAG_DB);
        } else {
            $this->SHORTAGE_FLAG_DB = $sHORTAGE_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get FORECAST_CONSUMPTION_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFORECAST_CONSUMPTION_FLAG_DB()
    {
        return isset($this->FORECAST_CONSUMPTION_FLAG_DB) ? $this->FORECAST_CONSUMPTION_FLAG_DB : null;
    }
    /**
     * Set FORECAST_CONSUMPTION_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fORECAST_CONSUMPTION_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setFORECAST_CONSUMPTION_FLAG_DB($fORECAST_CONSUMPTION_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($fORECAST_CONSUMPTION_FLAG_DB) && !is_string($fORECAST_CONSUMPTION_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fORECAST_CONSUMPTION_FLAG_DB)), __LINE__);
        }
        if (is_null($fORECAST_CONSUMPTION_FLAG_DB) || (is_array($fORECAST_CONSUMPTION_FLAG_DB) && empty($fORECAST_CONSUMPTION_FLAG_DB))) {
            unset($this->FORECAST_CONSUMPTION_FLAG_DB);
        } else {
            $this->FORECAST_CONSUMPTION_FLAG_DB = $fORECAST_CONSUMPTION_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get STOCK_MANAGEMENT_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSTOCK_MANAGEMENT_DB()
    {
        return isset($this->STOCK_MANAGEMENT_DB) ? $this->STOCK_MANAGEMENT_DB : null;
    }
    /**
     * Set STOCK_MANAGEMENT_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sTOCK_MANAGEMENT_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setSTOCK_MANAGEMENT_DB($sTOCK_MANAGEMENT_DB = null)
    {
        // validation for constraint: string
        if (!is_null($sTOCK_MANAGEMENT_DB) && !is_string($sTOCK_MANAGEMENT_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sTOCK_MANAGEMENT_DB)), __LINE__);
        }
        if (is_null($sTOCK_MANAGEMENT_DB) || (is_array($sTOCK_MANAGEMENT_DB) && empty($sTOCK_MANAGEMENT_DB))) {
            unset($this->STOCK_MANAGEMENT_DB);
        } else {
            $this->STOCK_MANAGEMENT_DB = $sTOCK_MANAGEMENT_DB;
        }
        return $this;
    }
    /**
     * Get INTRASTAT_CONV_FACTOR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getINTRASTAT_CONV_FACTOR()
    {
        return isset($this->INTRASTAT_CONV_FACTOR) ? $this->INTRASTAT_CONV_FACTOR : null;
    }
    /**
     * Set INTRASTAT_CONV_FACTOR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $iNTRASTAT_CONV_FACTOR
     * @return \StructType\INVENTORY_PART
     */
    public function setINTRASTAT_CONV_FACTOR($iNTRASTAT_CONV_FACTOR = null)
    {
        if (is_null($iNTRASTAT_CONV_FACTOR) || (is_array($iNTRASTAT_CONV_FACTOR) && empty($iNTRASTAT_CONV_FACTOR))) {
            unset($this->INTRASTAT_CONV_FACTOR);
        } else {
            $this->INTRASTAT_CONV_FACTOR = $iNTRASTAT_CONV_FACTOR;
        }
        return $this;
    }
    /**
     * Get PART_COST_GROUP_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPART_COST_GROUP_ID()
    {
        return isset($this->PART_COST_GROUP_ID) ? $this->PART_COST_GROUP_ID : null;
    }
    /**
     * Set PART_COST_GROUP_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pART_COST_GROUP_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setPART_COST_GROUP_ID($pART_COST_GROUP_ID = null)
    {
        // validation for constraint: string
        if (!is_null($pART_COST_GROUP_ID) && !is_string($pART_COST_GROUP_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pART_COST_GROUP_ID)), __LINE__);
        }
        if (is_null($pART_COST_GROUP_ID) || (is_array($pART_COST_GROUP_ID) && empty($pART_COST_GROUP_ID))) {
            unset($this->PART_COST_GROUP_ID);
        } else {
            $this->PART_COST_GROUP_ID = $pART_COST_GROUP_ID;
        }
        return $this;
    }
    /**
     * Get DOP_CONNECTION_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDOP_CONNECTION_DB()
    {
        return isset($this->DOP_CONNECTION_DB) ? $this->DOP_CONNECTION_DB : null;
    }
    /**
     * Set DOP_CONNECTION_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dOP_CONNECTION_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setDOP_CONNECTION_DB($dOP_CONNECTION_DB = null)
    {
        // validation for constraint: string
        if (!is_null($dOP_CONNECTION_DB) && !is_string($dOP_CONNECTION_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOP_CONNECTION_DB)), __LINE__);
        }
        if (is_null($dOP_CONNECTION_DB) || (is_array($dOP_CONNECTION_DB) && empty($dOP_CONNECTION_DB))) {
            unset($this->DOP_CONNECTION_DB);
        } else {
            $this->DOP_CONNECTION_DB = $dOP_CONNECTION_DB;
        }
        return $this;
    }
    /**
     * Get STD_NAME_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTD_NAME_ID()
    {
        return isset($this->STD_NAME_ID) ? $this->STD_NAME_ID : null;
    }
    /**
     * Set STD_NAME_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTD_NAME_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setSTD_NAME_ID($sTD_NAME_ID = null)
    {
        if (is_null($sTD_NAME_ID) || (is_array($sTD_NAME_ID) && empty($sTD_NAME_ID))) {
            unset($this->STD_NAME_ID);
        } else {
            $this->STD_NAME_ID = $sTD_NAME_ID;
        }
        return $this;
    }
    /**
     * Get INVENTORY_VALUATION_METHOD_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVENTORY_VALUATION_METHOD_DB()
    {
        return isset($this->INVENTORY_VALUATION_METHOD_DB) ? $this->INVENTORY_VALUATION_METHOD_DB : null;
    }
    /**
     * Set INVENTORY_VALUATION_METHOD_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVENTORY_VALUATION_METHOD_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setINVENTORY_VALUATION_METHOD_DB($iNVENTORY_VALUATION_METHOD_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iNVENTORY_VALUATION_METHOD_DB) && !is_string($iNVENTORY_VALUATION_METHOD_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVENTORY_VALUATION_METHOD_DB)), __LINE__);
        }
        if (is_null($iNVENTORY_VALUATION_METHOD_DB) || (is_array($iNVENTORY_VALUATION_METHOD_DB) && empty($iNVENTORY_VALUATION_METHOD_DB))) {
            unset($this->INVENTORY_VALUATION_METHOD_DB);
        } else {
            $this->INVENTORY_VALUATION_METHOD_DB = $iNVENTORY_VALUATION_METHOD_DB;
        }
        return $this;
    }
    /**
     * Get NEGATIVE_ON_HAND_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNEGATIVE_ON_HAND_DB()
    {
        return isset($this->NEGATIVE_ON_HAND_DB) ? $this->NEGATIVE_ON_HAND_DB : null;
    }
    /**
     * Set NEGATIVE_ON_HAND_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nEGATIVE_ON_HAND_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setNEGATIVE_ON_HAND_DB($nEGATIVE_ON_HAND_DB = null)
    {
        // validation for constraint: string
        if (!is_null($nEGATIVE_ON_HAND_DB) && !is_string($nEGATIVE_ON_HAND_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nEGATIVE_ON_HAND_DB)), __LINE__);
        }
        if (is_null($nEGATIVE_ON_HAND_DB) || (is_array($nEGATIVE_ON_HAND_DB) && empty($nEGATIVE_ON_HAND_DB))) {
            unset($this->NEGATIVE_ON_HAND_DB);
        } else {
            $this->NEGATIVE_ON_HAND_DB = $nEGATIVE_ON_HAND_DB;
        }
        return $this;
    }
    /**
     * Get TECHNICAL_COORDINATOR_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTECHNICAL_COORDINATOR_ID()
    {
        return isset($this->TECHNICAL_COORDINATOR_ID) ? $this->TECHNICAL_COORDINATOR_ID : null;
    }
    /**
     * Set TECHNICAL_COORDINATOR_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tECHNICAL_COORDINATOR_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setTECHNICAL_COORDINATOR_ID($tECHNICAL_COORDINATOR_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tECHNICAL_COORDINATOR_ID) && !is_string($tECHNICAL_COORDINATOR_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tECHNICAL_COORDINATOR_ID)), __LINE__);
        }
        if (is_null($tECHNICAL_COORDINATOR_ID) || (is_array($tECHNICAL_COORDINATOR_ID) && empty($tECHNICAL_COORDINATOR_ID))) {
            unset($this->TECHNICAL_COORDINATOR_ID);
        } else {
            $this->TECHNICAL_COORDINATOR_ID = $tECHNICAL_COORDINATOR_ID;
        }
        return $this;
    }
    /**
     * Get INVOICE_CONSIDERATION_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVOICE_CONSIDERATION_DB()
    {
        return isset($this->INVOICE_CONSIDERATION_DB) ? $this->INVOICE_CONSIDERATION_DB : null;
    }
    /**
     * Set INVOICE_CONSIDERATION_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVOICE_CONSIDERATION_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setINVOICE_CONSIDERATION_DB($iNVOICE_CONSIDERATION_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_CONSIDERATION_DB) && !is_string($iNVOICE_CONSIDERATION_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_CONSIDERATION_DB)), __LINE__);
        }
        if (is_null($iNVOICE_CONSIDERATION_DB) || (is_array($iNVOICE_CONSIDERATION_DB) && empty($iNVOICE_CONSIDERATION_DB))) {
            unset($this->INVOICE_CONSIDERATION_DB);
        } else {
            $this->INVOICE_CONSIDERATION_DB = $iNVOICE_CONSIDERATION_DB;
        }
        return $this;
    }
    /**
     * Get ACTUAL_COST_ACTIVATED value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getACTUAL_COST_ACTIVATED()
    {
        return isset($this->ACTUAL_COST_ACTIVATED) ? $this->ACTUAL_COST_ACTIVATED : null;
    }
    /**
     * Set ACTUAL_COST_ACTIVATED value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aCTUAL_COST_ACTIVATED
     * @return \StructType\INVENTORY_PART
     */
    public function setACTUAL_COST_ACTIVATED($aCTUAL_COST_ACTIVATED = null)
    {
        // validation for constraint: string
        if (!is_null($aCTUAL_COST_ACTIVATED) && !is_string($aCTUAL_COST_ACTIVATED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aCTUAL_COST_ACTIVATED)), __LINE__);
        }
        if (is_null($aCTUAL_COST_ACTIVATED) || (is_array($aCTUAL_COST_ACTIVATED) && empty($aCTUAL_COST_ACTIVATED))) {
            unset($this->ACTUAL_COST_ACTIVATED);
        } else {
            $this->ACTUAL_COST_ACTIVATED = $aCTUAL_COST_ACTIVATED;
        }
        return $this;
    }
    /**
     * Get MAX_ACTUAL_COST_UPDATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMAX_ACTUAL_COST_UPDATE()
    {
        return isset($this->MAX_ACTUAL_COST_UPDATE) ? $this->MAX_ACTUAL_COST_UPDATE : null;
    }
    /**
     * Set MAX_ACTUAL_COST_UPDATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mAX_ACTUAL_COST_UPDATE
     * @return \StructType\INVENTORY_PART
     */
    public function setMAX_ACTUAL_COST_UPDATE($mAX_ACTUAL_COST_UPDATE = null)
    {
        if (is_null($mAX_ACTUAL_COST_UPDATE) || (is_array($mAX_ACTUAL_COST_UPDATE) && empty($mAX_ACTUAL_COST_UPDATE))) {
            unset($this->MAX_ACTUAL_COST_UPDATE);
        } else {
            $this->MAX_ACTUAL_COST_UPDATE = $mAX_ACTUAL_COST_UPDATE;
        }
        return $this;
    }
    /**
     * Get CUST_WARRANTY_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCUST_WARRANTY_ID()
    {
        return isset($this->CUST_WARRANTY_ID) ? $this->CUST_WARRANTY_ID : null;
    }
    /**
     * Set CUST_WARRANTY_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cUST_WARRANTY_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setCUST_WARRANTY_ID($cUST_WARRANTY_ID = null)
    {
        if (is_null($cUST_WARRANTY_ID) || (is_array($cUST_WARRANTY_ID) && empty($cUST_WARRANTY_ID))) {
            unset($this->CUST_WARRANTY_ID);
        } else {
            $this->CUST_WARRANTY_ID = $cUST_WARRANTY_ID;
        }
        return $this;
    }
    /**
     * Get SUP_WARRANTY_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSUP_WARRANTY_ID()
    {
        return isset($this->SUP_WARRANTY_ID) ? $this->SUP_WARRANTY_ID : null;
    }
    /**
     * Set SUP_WARRANTY_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sUP_WARRANTY_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setSUP_WARRANTY_ID($sUP_WARRANTY_ID = null)
    {
        if (is_null($sUP_WARRANTY_ID) || (is_array($sUP_WARRANTY_ID) && empty($sUP_WARRANTY_ID))) {
            unset($this->SUP_WARRANTY_ID);
        } else {
            $this->SUP_WARRANTY_ID = $sUP_WARRANTY_ID;
        }
        return $this;
    }
    /**
     * Get REGION_OF_ORIGIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getREGION_OF_ORIGIN()
    {
        return isset($this->REGION_OF_ORIGIN) ? $this->REGION_OF_ORIGIN : null;
    }
    /**
     * Set REGION_OF_ORIGIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rEGION_OF_ORIGIN
     * @return \StructType\INVENTORY_PART
     */
    public function setREGION_OF_ORIGIN($rEGION_OF_ORIGIN = null)
    {
        // validation for constraint: string
        if (!is_null($rEGION_OF_ORIGIN) && !is_string($rEGION_OF_ORIGIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEGION_OF_ORIGIN)), __LINE__);
        }
        if (is_null($rEGION_OF_ORIGIN) || (is_array($rEGION_OF_ORIGIN) && empty($rEGION_OF_ORIGIN))) {
            unset($this->REGION_OF_ORIGIN);
        } else {
            $this->REGION_OF_ORIGIN = $rEGION_OF_ORIGIN;
        }
        return $this;
    }
    /**
     * Get INVENTORY_PART_COST_LEVEL_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVENTORY_PART_COST_LEVEL_DB()
    {
        return isset($this->INVENTORY_PART_COST_LEVEL_DB) ? $this->INVENTORY_PART_COST_LEVEL_DB : null;
    }
    /**
     * Set INVENTORY_PART_COST_LEVEL_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVENTORY_PART_COST_LEVEL_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setINVENTORY_PART_COST_LEVEL_DB($iNVENTORY_PART_COST_LEVEL_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iNVENTORY_PART_COST_LEVEL_DB) && !is_string($iNVENTORY_PART_COST_LEVEL_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVENTORY_PART_COST_LEVEL_DB)), __LINE__);
        }
        if (is_null($iNVENTORY_PART_COST_LEVEL_DB) || (is_array($iNVENTORY_PART_COST_LEVEL_DB) && empty($iNVENTORY_PART_COST_LEVEL_DB))) {
            unset($this->INVENTORY_PART_COST_LEVEL_DB);
        } else {
            $this->INVENTORY_PART_COST_LEVEL_DB = $iNVENTORY_PART_COST_LEVEL_DB;
        }
        return $this;
    }
    /**
     * Get EXT_SERVICE_COST_METHOD_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEXT_SERVICE_COST_METHOD_DB()
    {
        return isset($this->EXT_SERVICE_COST_METHOD_DB) ? $this->EXT_SERVICE_COST_METHOD_DB : null;
    }
    /**
     * Set EXT_SERVICE_COST_METHOD_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eXT_SERVICE_COST_METHOD_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setEXT_SERVICE_COST_METHOD_DB($eXT_SERVICE_COST_METHOD_DB = null)
    {
        // validation for constraint: string
        if (!is_null($eXT_SERVICE_COST_METHOD_DB) && !is_string($eXT_SERVICE_COST_METHOD_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eXT_SERVICE_COST_METHOD_DB)), __LINE__);
        }
        if (is_null($eXT_SERVICE_COST_METHOD_DB) || (is_array($eXT_SERVICE_COST_METHOD_DB) && empty($eXT_SERVICE_COST_METHOD_DB))) {
            unset($this->EXT_SERVICE_COST_METHOD_DB);
        } else {
            $this->EXT_SERVICE_COST_METHOD_DB = $eXT_SERVICE_COST_METHOD_DB;
        }
        return $this;
    }
    /**
     * Get SUPPLY_CHAIN_PART_GROUP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLY_CHAIN_PART_GROUP()
    {
        return isset($this->SUPPLY_CHAIN_PART_GROUP) ? $this->SUPPLY_CHAIN_PART_GROUP : null;
    }
    /**
     * Set SUPPLY_CHAIN_PART_GROUP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLY_CHAIN_PART_GROUP
     * @return \StructType\INVENTORY_PART
     */
    public function setSUPPLY_CHAIN_PART_GROUP($sUPPLY_CHAIN_PART_GROUP = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLY_CHAIN_PART_GROUP) && !is_string($sUPPLY_CHAIN_PART_GROUP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLY_CHAIN_PART_GROUP)), __LINE__);
        }
        if (is_null($sUPPLY_CHAIN_PART_GROUP) || (is_array($sUPPLY_CHAIN_PART_GROUP) && empty($sUPPLY_CHAIN_PART_GROUP))) {
            unset($this->SUPPLY_CHAIN_PART_GROUP);
        } else {
            $this->SUPPLY_CHAIN_PART_GROUP = $sUPPLY_CHAIN_PART_GROUP;
        }
        return $this;
    }
    /**
     * Get AUTOMATIC_CAPABILITY_CHECK_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAUTOMATIC_CAPABILITY_CHECK_DB()
    {
        return isset($this->AUTOMATIC_CAPABILITY_CHECK_DB) ? $this->AUTOMATIC_CAPABILITY_CHECK_DB : null;
    }
    /**
     * Set AUTOMATIC_CAPABILITY_CHECK_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aUTOMATIC_CAPABILITY_CHECK_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setAUTOMATIC_CAPABILITY_CHECK_DB($aUTOMATIC_CAPABILITY_CHECK_DB = null)
    {
        // validation for constraint: string
        if (!is_null($aUTOMATIC_CAPABILITY_CHECK_DB) && !is_string($aUTOMATIC_CAPABILITY_CHECK_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUTOMATIC_CAPABILITY_CHECK_DB)), __LINE__);
        }
        if (is_null($aUTOMATIC_CAPABILITY_CHECK_DB) || (is_array($aUTOMATIC_CAPABILITY_CHECK_DB) && empty($aUTOMATIC_CAPABILITY_CHECK_DB))) {
            unset($this->AUTOMATIC_CAPABILITY_CHECK_DB);
        } else {
            $this->AUTOMATIC_CAPABILITY_CHECK_DB = $aUTOMATIC_CAPABILITY_CHECK_DB;
        }
        return $this;
    }
    /**
     * Get INPUT_UNIT_MEAS_GROUP_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINPUT_UNIT_MEAS_GROUP_ID()
    {
        return isset($this->INPUT_UNIT_MEAS_GROUP_ID) ? $this->INPUT_UNIT_MEAS_GROUP_ID : null;
    }
    /**
     * Set INPUT_UNIT_MEAS_GROUP_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNPUT_UNIT_MEAS_GROUP_ID
     * @return \StructType\INVENTORY_PART
     */
    public function setINPUT_UNIT_MEAS_GROUP_ID($iNPUT_UNIT_MEAS_GROUP_ID = null)
    {
        // validation for constraint: string
        if (!is_null($iNPUT_UNIT_MEAS_GROUP_ID) && !is_string($iNPUT_UNIT_MEAS_GROUP_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNPUT_UNIT_MEAS_GROUP_ID)), __LINE__);
        }
        if (is_null($iNPUT_UNIT_MEAS_GROUP_ID) || (is_array($iNPUT_UNIT_MEAS_GROUP_ID) && empty($iNPUT_UNIT_MEAS_GROUP_ID))) {
            unset($this->INPUT_UNIT_MEAS_GROUP_ID);
        } else {
            $this->INPUT_UNIT_MEAS_GROUP_ID = $iNPUT_UNIT_MEAS_GROUP_ID;
        }
        return $this;
    }
    /**
     * Get DOP_NETTING_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDOP_NETTING_DB()
    {
        return isset($this->DOP_NETTING_DB) ? $this->DOP_NETTING_DB : null;
    }
    /**
     * Set DOP_NETTING_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dOP_NETTING_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setDOP_NETTING_DB($dOP_NETTING_DB = null)
    {
        // validation for constraint: string
        if (!is_null($dOP_NETTING_DB) && !is_string($dOP_NETTING_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOP_NETTING_DB)), __LINE__);
        }
        if (is_null($dOP_NETTING_DB) || (is_array($dOP_NETTING_DB) && empty($dOP_NETTING_DB))) {
            unset($this->DOP_NETTING_DB);
        } else {
            $this->DOP_NETTING_DB = $dOP_NETTING_DB;
        }
        return $this;
    }
    /**
     * Get CO_RESERVE_ONH_ANALYS_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCO_RESERVE_ONH_ANALYS_FLAG_DB()
    {
        return isset($this->CO_RESERVE_ONH_ANALYS_FLAG_DB) ? $this->CO_RESERVE_ONH_ANALYS_FLAG_DB : null;
    }
    /**
     * Set CO_RESERVE_ONH_ANALYS_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cO_RESERVE_ONH_ANALYS_FLAG_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setCO_RESERVE_ONH_ANALYS_FLAG_DB($cO_RESERVE_ONH_ANALYS_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($cO_RESERVE_ONH_ANALYS_FLAG_DB) && !is_string($cO_RESERVE_ONH_ANALYS_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cO_RESERVE_ONH_ANALYS_FLAG_DB)), __LINE__);
        }
        if (is_null($cO_RESERVE_ONH_ANALYS_FLAG_DB) || (is_array($cO_RESERVE_ONH_ANALYS_FLAG_DB) && empty($cO_RESERVE_ONH_ANALYS_FLAG_DB))) {
            unset($this->CO_RESERVE_ONH_ANALYS_FLAG_DB);
        } else {
            $this->CO_RESERVE_ONH_ANALYS_FLAG_DB = $cO_RESERVE_ONH_ANALYS_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get QTY_CALC_ROUNDING value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQTY_CALC_ROUNDING()
    {
        return isset($this->QTY_CALC_ROUNDING) ? $this->QTY_CALC_ROUNDING : null;
    }
    /**
     * Set QTY_CALC_ROUNDING value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qTY_CALC_ROUNDING
     * @return \StructType\INVENTORY_PART
     */
    public function setQTY_CALC_ROUNDING($qTY_CALC_ROUNDING = null)
    {
        if (is_null($qTY_CALC_ROUNDING) || (is_array($qTY_CALC_ROUNDING) && empty($qTY_CALC_ROUNDING))) {
            unset($this->QTY_CALC_ROUNDING);
        } else {
            $this->QTY_CALC_ROUNDING = $qTY_CALC_ROUNDING;
        }
        return $this;
    }
    /**
     * Get LIFECYCLE_STAGE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLIFECYCLE_STAGE_DB()
    {
        return isset($this->LIFECYCLE_STAGE_DB) ? $this->LIFECYCLE_STAGE_DB : null;
    }
    /**
     * Set LIFECYCLE_STAGE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lIFECYCLE_STAGE_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setLIFECYCLE_STAGE_DB($lIFECYCLE_STAGE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($lIFECYCLE_STAGE_DB) && !is_string($lIFECYCLE_STAGE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lIFECYCLE_STAGE_DB)), __LINE__);
        }
        if (is_null($lIFECYCLE_STAGE_DB) || (is_array($lIFECYCLE_STAGE_DB) && empty($lIFECYCLE_STAGE_DB))) {
            unset($this->LIFECYCLE_STAGE_DB);
        } else {
            $this->LIFECYCLE_STAGE_DB = $lIFECYCLE_STAGE_DB;
        }
        return $this;
    }
    /**
     * Get FREQUENCY_CLASS_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFREQUENCY_CLASS_DB()
    {
        return isset($this->FREQUENCY_CLASS_DB) ? $this->FREQUENCY_CLASS_DB : null;
    }
    /**
     * Set FREQUENCY_CLASS_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fREQUENCY_CLASS_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setFREQUENCY_CLASS_DB($fREQUENCY_CLASS_DB = null)
    {
        // validation for constraint: string
        if (!is_null($fREQUENCY_CLASS_DB) && !is_string($fREQUENCY_CLASS_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fREQUENCY_CLASS_DB)), __LINE__);
        }
        if (is_null($fREQUENCY_CLASS_DB) || (is_array($fREQUENCY_CLASS_DB) && empty($fREQUENCY_CLASS_DB))) {
            unset($this->FREQUENCY_CLASS_DB);
        } else {
            $this->FREQUENCY_CLASS_DB = $fREQUENCY_CLASS_DB;
        }
        return $this;
    }
    /**
     * Get FIRST_STAT_ISSUE_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFIRST_STAT_ISSUE_DATE()
    {
        return isset($this->FIRST_STAT_ISSUE_DATE) ? $this->FIRST_STAT_ISSUE_DATE : null;
    }
    /**
     * Set FIRST_STAT_ISSUE_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fIRST_STAT_ISSUE_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setFIRST_STAT_ISSUE_DATE($fIRST_STAT_ISSUE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($fIRST_STAT_ISSUE_DATE) && !is_string($fIRST_STAT_ISSUE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fIRST_STAT_ISSUE_DATE)), __LINE__);
        }
        if (is_null($fIRST_STAT_ISSUE_DATE) || (is_array($fIRST_STAT_ISSUE_DATE) && empty($fIRST_STAT_ISSUE_DATE))) {
            unset($this->FIRST_STAT_ISSUE_DATE);
        } else {
            $this->FIRST_STAT_ISSUE_DATE = $fIRST_STAT_ISSUE_DATE;
        }
        return $this;
    }
    /**
     * Get LATEST_STAT_ISSUE_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLATEST_STAT_ISSUE_DATE()
    {
        return isset($this->LATEST_STAT_ISSUE_DATE) ? $this->LATEST_STAT_ISSUE_DATE : null;
    }
    /**
     * Set LATEST_STAT_ISSUE_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lATEST_STAT_ISSUE_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setLATEST_STAT_ISSUE_DATE($lATEST_STAT_ISSUE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($lATEST_STAT_ISSUE_DATE) && !is_string($lATEST_STAT_ISSUE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lATEST_STAT_ISSUE_DATE)), __LINE__);
        }
        if (is_null($lATEST_STAT_ISSUE_DATE) || (is_array($lATEST_STAT_ISSUE_DATE) && empty($lATEST_STAT_ISSUE_DATE))) {
            unset($this->LATEST_STAT_ISSUE_DATE);
        } else {
            $this->LATEST_STAT_ISSUE_DATE = $lATEST_STAT_ISSUE_DATE;
        }
        return $this;
    }
    /**
     * Get DECLINE_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDECLINE_DATE()
    {
        return isset($this->DECLINE_DATE) ? $this->DECLINE_DATE : null;
    }
    /**
     * Set DECLINE_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dECLINE_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setDECLINE_DATE($dECLINE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($dECLINE_DATE) && !is_string($dECLINE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dECLINE_DATE)), __LINE__);
        }
        if (is_null($dECLINE_DATE) || (is_array($dECLINE_DATE) && empty($dECLINE_DATE))) {
            unset($this->DECLINE_DATE);
        } else {
            $this->DECLINE_DATE = $dECLINE_DATE;
        }
        return $this;
    }
    /**
     * Get EXPIRED_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEXPIRED_DATE()
    {
        return isset($this->EXPIRED_DATE) ? $this->EXPIRED_DATE : null;
    }
    /**
     * Set EXPIRED_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eXPIRED_DATE
     * @return \StructType\INVENTORY_PART
     */
    public function setEXPIRED_DATE($eXPIRED_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($eXPIRED_DATE) && !is_string($eXPIRED_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eXPIRED_DATE)), __LINE__);
        }
        if (is_null($eXPIRED_DATE) || (is_array($eXPIRED_DATE) && empty($eXPIRED_DATE))) {
            unset($this->EXPIRED_DATE);
        } else {
            $this->EXPIRED_DATE = $eXPIRED_DATE;
        }
        return $this;
    }
    /**
     * Get DECLINE_ISSUE_COUNTER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDECLINE_ISSUE_COUNTER()
    {
        return isset($this->DECLINE_ISSUE_COUNTER) ? $this->DECLINE_ISSUE_COUNTER : null;
    }
    /**
     * Set DECLINE_ISSUE_COUNTER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dECLINE_ISSUE_COUNTER
     * @return \StructType\INVENTORY_PART
     */
    public function setDECLINE_ISSUE_COUNTER($dECLINE_ISSUE_COUNTER = null)
    {
        if (is_null($dECLINE_ISSUE_COUNTER) || (is_array($dECLINE_ISSUE_COUNTER) && empty($dECLINE_ISSUE_COUNTER))) {
            unset($this->DECLINE_ISSUE_COUNTER);
        } else {
            $this->DECLINE_ISSUE_COUNTER = $dECLINE_ISSUE_COUNTER;
        }
        return $this;
    }
    /**
     * Get EXPIRED_ISSUE_COUNTER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEXPIRED_ISSUE_COUNTER()
    {
        return isset($this->EXPIRED_ISSUE_COUNTER) ? $this->EXPIRED_ISSUE_COUNTER : null;
    }
    /**
     * Set EXPIRED_ISSUE_COUNTER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eXPIRED_ISSUE_COUNTER
     * @return \StructType\INVENTORY_PART
     */
    public function setEXPIRED_ISSUE_COUNTER($eXPIRED_ISSUE_COUNTER = null)
    {
        if (is_null($eXPIRED_ISSUE_COUNTER) || (is_array($eXPIRED_ISSUE_COUNTER) && empty($eXPIRED_ISSUE_COUNTER))) {
            unset($this->EXPIRED_ISSUE_COUNTER);
        } else {
            $this->EXPIRED_ISSUE_COUNTER = $eXPIRED_ISSUE_COUNTER;
        }
        return $this;
    }
    /**
     * Get MIN_DURAB_DAYS_CO_DELIV value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMIN_DURAB_DAYS_CO_DELIV()
    {
        return isset($this->MIN_DURAB_DAYS_CO_DELIV) ? $this->MIN_DURAB_DAYS_CO_DELIV : null;
    }
    /**
     * Set MIN_DURAB_DAYS_CO_DELIV value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mIN_DURAB_DAYS_CO_DELIV
     * @return \StructType\INVENTORY_PART
     */
    public function setMIN_DURAB_DAYS_CO_DELIV($mIN_DURAB_DAYS_CO_DELIV = null)
    {
        if (is_null($mIN_DURAB_DAYS_CO_DELIV) || (is_array($mIN_DURAB_DAYS_CO_DELIV) && empty($mIN_DURAB_DAYS_CO_DELIV))) {
            unset($this->MIN_DURAB_DAYS_CO_DELIV);
        } else {
            $this->MIN_DURAB_DAYS_CO_DELIV = $mIN_DURAB_DAYS_CO_DELIV;
        }
        return $this;
    }
    /**
     * Get MIN_DURAB_DAYS_PLANNING value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMIN_DURAB_DAYS_PLANNING()
    {
        return isset($this->MIN_DURAB_DAYS_PLANNING) ? $this->MIN_DURAB_DAYS_PLANNING : null;
    }
    /**
     * Set MIN_DURAB_DAYS_PLANNING value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mIN_DURAB_DAYS_PLANNING
     * @return \StructType\INVENTORY_PART
     */
    public function setMIN_DURAB_DAYS_PLANNING($mIN_DURAB_DAYS_PLANNING = null)
    {
        if (is_null($mIN_DURAB_DAYS_PLANNING) || (is_array($mIN_DURAB_DAYS_PLANNING) && empty($mIN_DURAB_DAYS_PLANNING))) {
            unset($this->MIN_DURAB_DAYS_PLANNING);
        } else {
            $this->MIN_DURAB_DAYS_PLANNING = $mIN_DURAB_DAYS_PLANNING;
        }
        return $this;
    }
    /**
     * Get AUTO_CREATED_GTIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAUTO_CREATED_GTIN()
    {
        return isset($this->AUTO_CREATED_GTIN) ? $this->AUTO_CREATED_GTIN : null;
    }
    /**
     * Set AUTO_CREATED_GTIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aUTO_CREATED_GTIN
     * @return \StructType\INVENTORY_PART
     */
    public function setAUTO_CREATED_GTIN($aUTO_CREATED_GTIN = null)
    {
        // validation for constraint: string
        if (!is_null($aUTO_CREATED_GTIN) && !is_string($aUTO_CREATED_GTIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUTO_CREATED_GTIN)), __LINE__);
        }
        if (is_null($aUTO_CREATED_GTIN) || (is_array($aUTO_CREATED_GTIN) && empty($aUTO_CREATED_GTIN))) {
            unset($this->AUTO_CREATED_GTIN);
        } else {
            $this->AUTO_CREATED_GTIN = $aUTO_CREATED_GTIN;
        }
        return $this;
    }
    /**
     * Get STORAGE_WIDTH_REQUIREMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTORAGE_WIDTH_REQUIREMENT()
    {
        return isset($this->STORAGE_WIDTH_REQUIREMENT) ? $this->STORAGE_WIDTH_REQUIREMENT : null;
    }
    /**
     * Set STORAGE_WIDTH_REQUIREMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTORAGE_WIDTH_REQUIREMENT
     * @return \StructType\INVENTORY_PART
     */
    public function setSTORAGE_WIDTH_REQUIREMENT($sTORAGE_WIDTH_REQUIREMENT = null)
    {
        if (is_null($sTORAGE_WIDTH_REQUIREMENT) || (is_array($sTORAGE_WIDTH_REQUIREMENT) && empty($sTORAGE_WIDTH_REQUIREMENT))) {
            unset($this->STORAGE_WIDTH_REQUIREMENT);
        } else {
            $this->STORAGE_WIDTH_REQUIREMENT = $sTORAGE_WIDTH_REQUIREMENT;
        }
        return $this;
    }
    /**
     * Get STORAGE_HEIGHT_REQUIREMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTORAGE_HEIGHT_REQUIREMENT()
    {
        return isset($this->STORAGE_HEIGHT_REQUIREMENT) ? $this->STORAGE_HEIGHT_REQUIREMENT : null;
    }
    /**
     * Set STORAGE_HEIGHT_REQUIREMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTORAGE_HEIGHT_REQUIREMENT
     * @return \StructType\INVENTORY_PART
     */
    public function setSTORAGE_HEIGHT_REQUIREMENT($sTORAGE_HEIGHT_REQUIREMENT = null)
    {
        if (is_null($sTORAGE_HEIGHT_REQUIREMENT) || (is_array($sTORAGE_HEIGHT_REQUIREMENT) && empty($sTORAGE_HEIGHT_REQUIREMENT))) {
            unset($this->STORAGE_HEIGHT_REQUIREMENT);
        } else {
            $this->STORAGE_HEIGHT_REQUIREMENT = $sTORAGE_HEIGHT_REQUIREMENT;
        }
        return $this;
    }
    /**
     * Get STORAGE_DEPTH_REQUIREMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTORAGE_DEPTH_REQUIREMENT()
    {
        return isset($this->STORAGE_DEPTH_REQUIREMENT) ? $this->STORAGE_DEPTH_REQUIREMENT : null;
    }
    /**
     * Set STORAGE_DEPTH_REQUIREMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTORAGE_DEPTH_REQUIREMENT
     * @return \StructType\INVENTORY_PART
     */
    public function setSTORAGE_DEPTH_REQUIREMENT($sTORAGE_DEPTH_REQUIREMENT = null)
    {
        if (is_null($sTORAGE_DEPTH_REQUIREMENT) || (is_array($sTORAGE_DEPTH_REQUIREMENT) && empty($sTORAGE_DEPTH_REQUIREMENT))) {
            unset($this->STORAGE_DEPTH_REQUIREMENT);
        } else {
            $this->STORAGE_DEPTH_REQUIREMENT = $sTORAGE_DEPTH_REQUIREMENT;
        }
        return $this;
    }
    /**
     * Get STORAGE_VOLUME_REQUIREMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTORAGE_VOLUME_REQUIREMENT()
    {
        return isset($this->STORAGE_VOLUME_REQUIREMENT) ? $this->STORAGE_VOLUME_REQUIREMENT : null;
    }
    /**
     * Set STORAGE_VOLUME_REQUIREMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTORAGE_VOLUME_REQUIREMENT
     * @return \StructType\INVENTORY_PART
     */
    public function setSTORAGE_VOLUME_REQUIREMENT($sTORAGE_VOLUME_REQUIREMENT = null)
    {
        if (is_null($sTORAGE_VOLUME_REQUIREMENT) || (is_array($sTORAGE_VOLUME_REQUIREMENT) && empty($sTORAGE_VOLUME_REQUIREMENT))) {
            unset($this->STORAGE_VOLUME_REQUIREMENT);
        } else {
            $this->STORAGE_VOLUME_REQUIREMENT = $sTORAGE_VOLUME_REQUIREMENT;
        }
        return $this;
    }
    /**
     * Get STORAGE_WEIGHT_REQUIREMENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTORAGE_WEIGHT_REQUIREMENT()
    {
        return isset($this->STORAGE_WEIGHT_REQUIREMENT) ? $this->STORAGE_WEIGHT_REQUIREMENT : null;
    }
    /**
     * Set STORAGE_WEIGHT_REQUIREMENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTORAGE_WEIGHT_REQUIREMENT
     * @return \StructType\INVENTORY_PART
     */
    public function setSTORAGE_WEIGHT_REQUIREMENT($sTORAGE_WEIGHT_REQUIREMENT = null)
    {
        if (is_null($sTORAGE_WEIGHT_REQUIREMENT) || (is_array($sTORAGE_WEIGHT_REQUIREMENT) && empty($sTORAGE_WEIGHT_REQUIREMENT))) {
            unset($this->STORAGE_WEIGHT_REQUIREMENT);
        } else {
            $this->STORAGE_WEIGHT_REQUIREMENT = $sTORAGE_WEIGHT_REQUIREMENT;
        }
        return $this;
    }
    /**
     * Get MIN_STORAGE_TEMPERATURE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMIN_STORAGE_TEMPERATURE()
    {
        return isset($this->MIN_STORAGE_TEMPERATURE) ? $this->MIN_STORAGE_TEMPERATURE : null;
    }
    /**
     * Set MIN_STORAGE_TEMPERATURE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mIN_STORAGE_TEMPERATURE
     * @return \StructType\INVENTORY_PART
     */
    public function setMIN_STORAGE_TEMPERATURE($mIN_STORAGE_TEMPERATURE = null)
    {
        if (is_null($mIN_STORAGE_TEMPERATURE) || (is_array($mIN_STORAGE_TEMPERATURE) && empty($mIN_STORAGE_TEMPERATURE))) {
            unset($this->MIN_STORAGE_TEMPERATURE);
        } else {
            $this->MIN_STORAGE_TEMPERATURE = $mIN_STORAGE_TEMPERATURE;
        }
        return $this;
    }
    /**
     * Get MAX_STORAGE_TEMPERATURE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMAX_STORAGE_TEMPERATURE()
    {
        return isset($this->MAX_STORAGE_TEMPERATURE) ? $this->MAX_STORAGE_TEMPERATURE : null;
    }
    /**
     * Set MAX_STORAGE_TEMPERATURE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mAX_STORAGE_TEMPERATURE
     * @return \StructType\INVENTORY_PART
     */
    public function setMAX_STORAGE_TEMPERATURE($mAX_STORAGE_TEMPERATURE = null)
    {
        if (is_null($mAX_STORAGE_TEMPERATURE) || (is_array($mAX_STORAGE_TEMPERATURE) && empty($mAX_STORAGE_TEMPERATURE))) {
            unset($this->MAX_STORAGE_TEMPERATURE);
        } else {
            $this->MAX_STORAGE_TEMPERATURE = $mAX_STORAGE_TEMPERATURE;
        }
        return $this;
    }
    /**
     * Get MIN_STORAGE_HUMIDITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMIN_STORAGE_HUMIDITY()
    {
        return isset($this->MIN_STORAGE_HUMIDITY) ? $this->MIN_STORAGE_HUMIDITY : null;
    }
    /**
     * Set MIN_STORAGE_HUMIDITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mIN_STORAGE_HUMIDITY
     * @return \StructType\INVENTORY_PART
     */
    public function setMIN_STORAGE_HUMIDITY($mIN_STORAGE_HUMIDITY = null)
    {
        if (is_null($mIN_STORAGE_HUMIDITY) || (is_array($mIN_STORAGE_HUMIDITY) && empty($mIN_STORAGE_HUMIDITY))) {
            unset($this->MIN_STORAGE_HUMIDITY);
        } else {
            $this->MIN_STORAGE_HUMIDITY = $mIN_STORAGE_HUMIDITY;
        }
        return $this;
    }
    /**
     * Get MAX_STORAGE_HUMIDITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMAX_STORAGE_HUMIDITY()
    {
        return isset($this->MAX_STORAGE_HUMIDITY) ? $this->MAX_STORAGE_HUMIDITY : null;
    }
    /**
     * Set MAX_STORAGE_HUMIDITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mAX_STORAGE_HUMIDITY
     * @return \StructType\INVENTORY_PART
     */
    public function setMAX_STORAGE_HUMIDITY($mAX_STORAGE_HUMIDITY = null)
    {
        if (is_null($mAX_STORAGE_HUMIDITY) || (is_array($mAX_STORAGE_HUMIDITY) && empty($mAX_STORAGE_HUMIDITY))) {
            unset($this->MAX_STORAGE_HUMIDITY);
        } else {
            $this->MAX_STORAGE_HUMIDITY = $mAX_STORAGE_HUMIDITY;
        }
        return $this;
    }
    /**
     * Get STANDARD_PUTAWAY_QTY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSTANDARD_PUTAWAY_QTY()
    {
        return isset($this->STANDARD_PUTAWAY_QTY) ? $this->STANDARD_PUTAWAY_QTY : null;
    }
    /**
     * Set STANDARD_PUTAWAY_QTY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sTANDARD_PUTAWAY_QTY
     * @return \StructType\INVENTORY_PART
     */
    public function setSTANDARD_PUTAWAY_QTY($sTANDARD_PUTAWAY_QTY = null)
    {
        if (is_null($sTANDARD_PUTAWAY_QTY) || (is_array($sTANDARD_PUTAWAY_QTY) && empty($sTANDARD_PUTAWAY_QTY))) {
            unset($this->STANDARD_PUTAWAY_QTY);
        } else {
            $this->STANDARD_PUTAWAY_QTY = $sTANDARD_PUTAWAY_QTY;
        }
        return $this;
    }
    /**
     * Get PALLET_HANDLED_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPALLET_HANDLED_DB()
    {
        return isset($this->PALLET_HANDLED_DB) ? $this->PALLET_HANDLED_DB : null;
    }
    /**
     * Set PALLET_HANDLED_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pALLET_HANDLED_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setPALLET_HANDLED_DB($pALLET_HANDLED_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pALLET_HANDLED_DB) && !is_string($pALLET_HANDLED_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pALLET_HANDLED_DB)), __LINE__);
        }
        if (is_null($pALLET_HANDLED_DB) || (is_array($pALLET_HANDLED_DB) && empty($pALLET_HANDLED_DB))) {
            unset($this->PALLET_HANDLED_DB);
        } else {
            $this->PALLET_HANDLED_DB = $pALLET_HANDLED_DB;
        }
        return $this;
    }
    /**
     * Get PUTAWAY_ZONE_REFILL_OPTION_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPUTAWAY_ZONE_REFILL_OPTION_DB()
    {
        return isset($this->PUTAWAY_ZONE_REFILL_OPTION_DB) ? $this->PUTAWAY_ZONE_REFILL_OPTION_DB : null;
    }
    /**
     * Set PUTAWAY_ZONE_REFILL_OPTION_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pUTAWAY_ZONE_REFILL_OPTION_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setPUTAWAY_ZONE_REFILL_OPTION_DB($pUTAWAY_ZONE_REFILL_OPTION_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pUTAWAY_ZONE_REFILL_OPTION_DB) && !is_string($pUTAWAY_ZONE_REFILL_OPTION_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pUTAWAY_ZONE_REFILL_OPTION_DB)), __LINE__);
        }
        if (is_null($pUTAWAY_ZONE_REFILL_OPTION_DB) || (is_array($pUTAWAY_ZONE_REFILL_OPTION_DB) && empty($pUTAWAY_ZONE_REFILL_OPTION_DB))) {
            unset($this->PUTAWAY_ZONE_REFILL_OPTION_DB);
        } else {
            $this->PUTAWAY_ZONE_REFILL_OPTION_DB = $pUTAWAY_ZONE_REFILL_OPTION_DB;
        }
        return $this;
    }
    /**
     * Get RESET_CONFIG_STD_COST_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRESET_CONFIG_STD_COST_DB()
    {
        return isset($this->RESET_CONFIG_STD_COST_DB) ? $this->RESET_CONFIG_STD_COST_DB : null;
    }
    /**
     * Set RESET_CONFIG_STD_COST_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rESET_CONFIG_STD_COST_DB
     * @return \StructType\INVENTORY_PART
     */
    public function setRESET_CONFIG_STD_COST_DB($rESET_CONFIG_STD_COST_DB = null)
    {
        // validation for constraint: string
        if (!is_null($rESET_CONFIG_STD_COST_DB) && !is_string($rESET_CONFIG_STD_COST_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rESET_CONFIG_STD_COST_DB)), __LINE__);
        }
        if (is_null($rESET_CONFIG_STD_COST_DB) || (is_array($rESET_CONFIG_STD_COST_DB) && empty($rESET_CONFIG_STD_COST_DB))) {
            unset($this->RESET_CONFIG_STD_COST_DB);
        } else {
            $this->RESET_CONFIG_STD_COST_DB = $rESET_CONFIG_STD_COST_DB;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\INVENTORY_PART
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get C_SEGMENTATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getC_SEGMENTATION()
    {
        return isset($this->C_SEGMENTATION) ? $this->C_SEGMENTATION : null;
    }
    /**
     * Set C_SEGMENTATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $c_SEGMENTATION
     * @return \StructType\INVENTORY_PART
     */
    public function setC_SEGMENTATION($c_SEGMENTATION = null)
    {
        // validation for constraint: string
        if (!is_null($c_SEGMENTATION) && !is_string($c_SEGMENTATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c_SEGMENTATION)), __LINE__);
        }
        if (is_null($c_SEGMENTATION) || (is_array($c_SEGMENTATION) && empty($c_SEGMENTATION))) {
            unset($this->C_SEGMENTATION);
        } else {
            $this->C_SEGMENTATION = $c_SEGMENTATION;
        }
        return $this;
    }
    /**
     * Get COSTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\COSTS|null
     */
    public function getCOSTS()
    {
        return isset($this->COSTS) ? $this->COSTS : null;
    }
    /**
     * Set COSTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\COSTS $cOSTS
     * @return \StructType\INVENTORY_PART
     */
    public function setCOSTS(\StructType\COSTS $cOSTS = null)
    {
        if (is_null($cOSTS) || (is_array($cOSTS) && empty($cOSTS))) {
            unset($this->COSTS);
        } else {
            $this->COSTS = $cOSTS;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\INVENTORY_PART
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
