<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_DELIVERY_TAX_INFO StructType
 * @subpackage Structs
 */
class CUSTOMER_DELIVERY_TAX_INFO extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The ADDRESS_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_ID;
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The SUPPLY_COUNTRY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLY_COUNTRY_DB;
    /**
     * The LIABILITY_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LIABILITY_TYPE;
    /**
     * The TAX_BOOK_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_BOOK_ID;
    /**
     * The TAX_BOOK_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TAX_BOOK_TYPE;
    /**
     * The TAX_STRUCTURE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_STRUCTURE_ID;
    /**
     * The CUS_COUNTRY_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CUS_COUNTRY_CODE;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The TAX_FREE_CODES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TAX_FREE_CODES
     */
    public $TAX_FREE_CODES;
    /**
     * Constructor method for CUSTOMER_DELIVERY_TAX_INFO
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setCUSTOMER_ID()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setADDRESS_ID()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setCOMPANY()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setSUPPLY_COUNTRY_DB()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setLIABILITY_TYPE()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setTAX_BOOK_ID()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setTAX_BOOK_TYPE()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setTAX_STRUCTURE_ID()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setCUS_COUNTRY_CODE()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setOPERATION()
     * @uses CUSTOMER_DELIVERY_TAX_INFO::setTAX_FREE_CODES()
     * @param string $cUSTOMER_ID
     * @param string $aDDRESS_ID
     * @param string $cOMPANY
     * @param string $sUPPLY_COUNTRY_DB
     * @param string $lIABILITY_TYPE
     * @param string $tAX_BOOK_ID
     * @param float $tAX_BOOK_TYPE
     * @param string $tAX_STRUCTURE_ID
     * @param string $cUS_COUNTRY_CODE
     * @param string $oPERATION
     * @param \StructType\TAX_FREE_CODES $tAX_FREE_CODES
     */
    public function __construct($cUSTOMER_ID = null, $aDDRESS_ID = null, $cOMPANY = null, $sUPPLY_COUNTRY_DB = null, $lIABILITY_TYPE = null, $tAX_BOOK_ID = null, $tAX_BOOK_TYPE = null, $tAX_STRUCTURE_ID = null, $cUS_COUNTRY_CODE = null, $oPERATION = null, \StructType\TAX_FREE_CODES $tAX_FREE_CODES = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setADDRESS_ID($aDDRESS_ID)
            ->setCOMPANY($cOMPANY)
            ->setSUPPLY_COUNTRY_DB($sUPPLY_COUNTRY_DB)
            ->setLIABILITY_TYPE($lIABILITY_TYPE)
            ->setTAX_BOOK_ID($tAX_BOOK_ID)
            ->setTAX_BOOK_TYPE($tAX_BOOK_TYPE)
            ->setTAX_STRUCTURE_ID($tAX_STRUCTURE_ID)
            ->setCUS_COUNTRY_CODE($cUS_COUNTRY_CODE)
            ->setOPERATION($oPERATION)
            ->setTAX_FREE_CODES($tAX_FREE_CODES);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_ID()
    {
        return isset($this->ADDRESS_ID) ? $this->ADDRESS_ID : null;
    }
    /**
     * Set ADDRESS_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_ID
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setADDRESS_ID($aDDRESS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_ID) && !is_string($aDDRESS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_ID)), __LINE__);
        }
        if (is_null($aDDRESS_ID) || (is_array($aDDRESS_ID) && empty($aDDRESS_ID))) {
            unset($this->ADDRESS_ID);
        } else {
            $this->ADDRESS_ID = $aDDRESS_ID;
        }
        return $this;
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get SUPPLY_COUNTRY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLY_COUNTRY_DB()
    {
        return isset($this->SUPPLY_COUNTRY_DB) ? $this->SUPPLY_COUNTRY_DB : null;
    }
    /**
     * Set SUPPLY_COUNTRY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLY_COUNTRY_DB
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setSUPPLY_COUNTRY_DB($sUPPLY_COUNTRY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLY_COUNTRY_DB) && !is_string($sUPPLY_COUNTRY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLY_COUNTRY_DB)), __LINE__);
        }
        if (is_null($sUPPLY_COUNTRY_DB) || (is_array($sUPPLY_COUNTRY_DB) && empty($sUPPLY_COUNTRY_DB))) {
            unset($this->SUPPLY_COUNTRY_DB);
        } else {
            $this->SUPPLY_COUNTRY_DB = $sUPPLY_COUNTRY_DB;
        }
        return $this;
    }
    /**
     * Get LIABILITY_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLIABILITY_TYPE()
    {
        return isset($this->LIABILITY_TYPE) ? $this->LIABILITY_TYPE : null;
    }
    /**
     * Set LIABILITY_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lIABILITY_TYPE
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setLIABILITY_TYPE($lIABILITY_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($lIABILITY_TYPE) && !is_string($lIABILITY_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lIABILITY_TYPE)), __LINE__);
        }
        if (is_null($lIABILITY_TYPE) || (is_array($lIABILITY_TYPE) && empty($lIABILITY_TYPE))) {
            unset($this->LIABILITY_TYPE);
        } else {
            $this->LIABILITY_TYPE = $lIABILITY_TYPE;
        }
        return $this;
    }
    /**
     * Get TAX_BOOK_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_BOOK_ID()
    {
        return isset($this->TAX_BOOK_ID) ? $this->TAX_BOOK_ID : null;
    }
    /**
     * Set TAX_BOOK_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_BOOK_ID
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setTAX_BOOK_ID($tAX_BOOK_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_BOOK_ID) && !is_string($tAX_BOOK_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_BOOK_ID)), __LINE__);
        }
        if (is_null($tAX_BOOK_ID) || (is_array($tAX_BOOK_ID) && empty($tAX_BOOK_ID))) {
            unset($this->TAX_BOOK_ID);
        } else {
            $this->TAX_BOOK_ID = $tAX_BOOK_ID;
        }
        return $this;
    }
    /**
     * Get TAX_BOOK_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTAX_BOOK_TYPE()
    {
        return isset($this->TAX_BOOK_TYPE) ? $this->TAX_BOOK_TYPE : null;
    }
    /**
     * Set TAX_BOOK_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tAX_BOOK_TYPE
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setTAX_BOOK_TYPE($tAX_BOOK_TYPE = null)
    {
        if (is_null($tAX_BOOK_TYPE) || (is_array($tAX_BOOK_TYPE) && empty($tAX_BOOK_TYPE))) {
            unset($this->TAX_BOOK_TYPE);
        } else {
            $this->TAX_BOOK_TYPE = $tAX_BOOK_TYPE;
        }
        return $this;
    }
    /**
     * Get TAX_STRUCTURE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_STRUCTURE_ID()
    {
        return isset($this->TAX_STRUCTURE_ID) ? $this->TAX_STRUCTURE_ID : null;
    }
    /**
     * Set TAX_STRUCTURE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_STRUCTURE_ID
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setTAX_STRUCTURE_ID($tAX_STRUCTURE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_STRUCTURE_ID) && !is_string($tAX_STRUCTURE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_STRUCTURE_ID)), __LINE__);
        }
        if (is_null($tAX_STRUCTURE_ID) || (is_array($tAX_STRUCTURE_ID) && empty($tAX_STRUCTURE_ID))) {
            unset($this->TAX_STRUCTURE_ID);
        } else {
            $this->TAX_STRUCTURE_ID = $tAX_STRUCTURE_ID;
        }
        return $this;
    }
    /**
     * Get CUS_COUNTRY_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUS_COUNTRY_CODE()
    {
        return isset($this->CUS_COUNTRY_CODE) ? $this->CUS_COUNTRY_CODE : null;
    }
    /**
     * Set CUS_COUNTRY_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUS_COUNTRY_CODE
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setCUS_COUNTRY_CODE($cUS_COUNTRY_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cUS_COUNTRY_CODE) && !is_string($cUS_COUNTRY_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUS_COUNTRY_CODE)), __LINE__);
        }
        if (is_null($cUS_COUNTRY_CODE) || (is_array($cUS_COUNTRY_CODE) && empty($cUS_COUNTRY_CODE))) {
            unset($this->CUS_COUNTRY_CODE);
        } else {
            $this->CUS_COUNTRY_CODE = $cUS_COUNTRY_CODE;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get TAX_FREE_CODES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TAX_FREE_CODES|null
     */
    public function getTAX_FREE_CODES()
    {
        return isset($this->TAX_FREE_CODES) ? $this->TAX_FREE_CODES : null;
    }
    /**
     * Set TAX_FREE_CODES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TAX_FREE_CODES $tAX_FREE_CODES
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public function setTAX_FREE_CODES(\StructType\TAX_FREE_CODES $tAX_FREE_CODES = null)
    {
        if (is_null($tAX_FREE_CODES) || (is_array($tAX_FREE_CODES) && empty($tAX_FREE_CODES))) {
            unset($this->TAX_FREE_CODES);
        } else {
            $this->TAX_FREE_CODES = $tAX_FREE_CODES;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_DELIVERY_TAX_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
