<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receiveinvoicepdfinfo ServiceType
 * @subpackage Services
 */
class Receiveinvoicepdfinfo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named receive_invoice_pdf_info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\INVOICE_PDF_INFO $request_body
     * @return \StructType\CRM_RESPONSE|bool
     */
    public function receive_invoice_pdf_info(\StructType\INVOICE_PDF_INFO $request_body)
    {
        try {
            $this->setResult(self::getSoapClient()->receive_invoice_pdf_info($request_body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CRM_RESPONSE
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
