<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Receivecustomer ServiceType
 */
$receivecustomer = new \ServiceType\Receivecustomer($options);
/**
 * Sample call for receive_customer operation/method
 */
if ($receivecustomer->receive_customer(new \StructType\CUSTOMER_INFO_RESPONSE()) !== false) {
    print_r($receivecustomer->getResult());
} else {
    print_r($receivecustomer->getLastError());
}
/**
 * Samples for Receivesalespart ServiceType
 */
$receivesalespart = new \ServiceType\Receivesalespart($options);
/**
 * Sample call for receive_sales_part operation/method
 */
if ($receivesalespart->receive_sales_part(new \StructType\SALES_PART()) !== false) {
    print_r($receivesalespart->getResult());
} else {
    print_r($receivesalespart->getLastError());
}
/**
 * Samples for Receivecustomeragreement ServiceType
 */
$receivecustomeragreement = new \ServiceType\Receivecustomeragreement($options);
/**
 * Sample call for receive_customer_agreement operation/method
 */
if ($receivecustomeragreement->receive_customer_agreement(new \StructType\CUSTOMER_AGREEMENT_RESPONSE()) !== false) {
    print_r($receivecustomeragreement->getResult());
} else {
    print_r($receivecustomeragreement->getLastError());
}
/**
 * Samples for Receivesuppblanket ServiceType
 */
$receivesuppblanket = new \ServiceType\Receivesuppblanket($options);
/**
 * Sample call for receive_supp_blanket operation/method
 */
if ($receivesuppblanket->receive_supp_blanket(new \StructType\SUPP_BLANKET_RESPONSE()) !== false) {
    print_r($receivesuppblanket->getResult());
} else {
    print_r($receivesuppblanket->getLastError());
}
/**
 * Samples for Receivecustomerorder ServiceType
 */
$receivecustomerorder = new \ServiceType\Receivecustomerorder($options);
/**
 * Sample call for receive_customer_order operation/method
 */
if ($receivecustomerorder->receive_customer_order(new \StructType\CUSTOMER_ORDER_RESPONSE()) !== false) {
    print_r($receivecustomerorder->getResult());
} else {
    print_r($receivecustomerorder->getLastError());
}
/**
 * Samples for Receiveinvoicepdfinfo ServiceType
 */
$receiveinvoicepdfinfo = new \ServiceType\Receiveinvoicepdfinfo($options);
/**
 * Sample call for receive_invoice_pdf_info operation/method
 */
if ($receiveinvoicepdfinfo->receive_invoice_pdf_info(new \StructType\INVOICE_PDF_INFO()) !== false) {
    print_r($receiveinvoicepdfinfo->getResult());
} else {
    print_r($receiveinvoicepdfinfo->getLastError());
}
