<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IDENTITY_INVOICE_INFO StructType
 * @subpackage Structs
 */
class IDENTITY_INVOICE_INFO extends AbstractStructBase
{
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTITY;
    /**
     * The PARTY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY_TYPE_DB;
    /**
     * The INVOICE_FEE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVOICE_FEE;
    /**
     * The EXPIRE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EXPIRE_DATE;
    /**
     * The NATIONAL_BANK_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NATIONAL_BANK_CODE;
    /**
     * The GROUP_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GROUP_ID;
    /**
     * The DEF_AUTHORIZER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_AUTHORIZER;
    /**
     * The PAY_TERM_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PAY_TERM_ID;
    /**
     * The DEF_VAT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_VAT_CODE;
    /**
     * The DEF_CURRENCY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_CURRENCY;
    /**
     * The PAYM_DEV_DAYS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PAYM_DEV_DAYS;
    /**
     * The IDENTITY_TYPE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDENTITY_TYPE_DB;
    /**
     * The DEF_PRELIMINARY_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_PRELIMINARY_CODE;
    /**
     * The AUTOMATIC_INVOICE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AUTOMATIC_INVOICE;
    /**
     * The PERCENT_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PERCENT_TOLERANCE;
    /**
     * The AMOUNT_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AMOUNT_TOLERANCE;
    /**
     * The NCF_REFERENCE_CHECK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NCF_REFERENCE_CHECK;
    /**
     * The TAX_EXEMPT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT;
    /**
     * The TAX_EXEMPT_VALID_FROM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT_VALID_FROM;
    /**
     * The TAX_EXEMPT_VALID_TO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_EXEMPT_VALID_TO;
    /**
     * The SECOND_TIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SECOND_TIN;
    /**
     * The REPORT_AND_WITHHOLD_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $REPORT_AND_WITHHOLD_DB;
    /**
     * The SUPPLIER_TAX_OFFICE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLIER_TAX_OFFICE_ID;
    /**
     * The AUTO_CREATION_TAX_LINES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AUTO_CREATION_TAX_LINES;
    /**
     * The NUMERATION_GROUP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NUMERATION_GROUP;
    /**
     * The TAX_BOOK_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_BOOK_ID;
    /**
     * The TAX_BOOK_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TAX_BOOK_TYPE;
    /**
     * The TAX_STRUCTURE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_STRUCTURE_ID;
    /**
     * The PRINT_TAX_CODE_TEXT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PRINT_TAX_CODE_TEXT;
    /**
     * The NO_INVOICE_COPIES
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NO_INVOICE_COPIES;
    /**
     * The TAX_REGIME_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_REGIME_DB;
    /**
     * The DEF_MAN_SUPP_INV_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_MAN_SUPP_INV_TYPE;
    /**
     * The DEF_AUTO_INVOICE_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_AUTO_INVOICE_TYPE;
    /**
     * The DEF_REC_MAN_SUPP_INV_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_REC_MAN_SUPP_INV_TYPE;
    /**
     * The LIABILITY_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LIABILITY_TYPE;
    /**
     * The CURRENCY_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CURRENCY_CODE;
    /**
     * The COUNTRY_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $COUNTRY_CODE;
    /**
     * The WITHHOLDING_BASE_AMOUNT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WITHHOLDING_BASE_AMOUNT;
    /**
     * The WITHHOLDING_BASE_AMOUNT_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WITHHOLDING_BASE_AMOUNT_DB;
    /**
     * The INVOICE_RECIPIENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVOICE_RECIPIENT;
    /**
     * The INVOICING_SUPPLIER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INVOICING_SUPPLIER;
    /**
     * The MATCHING_LEVEL_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MATCHING_LEVEL_DB;
    /**
     * The ALLOW_TOLERANCE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ALLOW_TOLERANCE;
    /**
     * The CREATE_TOLERANCE_POSTING
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CREATE_TOLERANCE_POSTING;
    /**
     * The ALLOW_QUANTITY_DIFF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ALLOW_QUANTITY_DIFF;
    /**
     * The DEFAULT_CURRENCY_RATE_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_CURRENCY_RATE_TYPE;
    /**
     * The TAX_CERTIFICATE_FORM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_CERTIFICATE_FORM;
    /**
     * The TAX_CERTIFICATE_FORM_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_CERTIFICATE_FORM_DB;
    /**
     * The IS_NOTE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IS_NOTE;
    /**
     * The DELIV_TYPE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DELIV_TYPE_ID;
    /**
     * The SUP_VAT_FREE_VAT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUP_VAT_FREE_VAT_CODE;
    /**
     * The SUP_COUNTRY_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUP_COUNTRY_CODE;
    /**
     * The AUTOMATIC_PAY_AUTH_FLAG_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AUTOMATIC_PAY_AUTH_FLAG_DB;
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The SUPPLIER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLIER_ID;
    /**
     * The INACTIVE_REASON_DESC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $INACTIVE_REASON_DESC;
    /**
     * The LEGAL_IDENTITY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LEGAL_IDENTITY;
    /**
     * The LEGAL_IDENTITY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LEGAL_IDENTITY_DB;
    /**
     * The PO_REF_REC_REF_VAL_METHOD_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PO_REF_REC_REF_VAL_METHOD_DB;
    /**
     * The POSTING_TEMPLATE_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $POSTING_TEMPLATE_ID;
    /**
     * The LEGAL_ID_NAME
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LEGAL_ID_NAME;
    /**
     * The LEGAL_ID_ADDR_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LEGAL_ID_ADDR_ID;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The PAY_INFO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PAY_INFO
     */
    public $PAY_INFO;
    /**
     * The CREDIT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CREDIT
     */
    public $CREDIT;
    /**
     * Constructor method for IDENTITY_INVOICE_INFO
     * @uses IDENTITY_INVOICE_INFO::setCOMPANY()
     * @uses IDENTITY_INVOICE_INFO::setIDENTITY()
     * @uses IDENTITY_INVOICE_INFO::setPARTY_TYPE_DB()
     * @uses IDENTITY_INVOICE_INFO::setINVOICE_FEE()
     * @uses IDENTITY_INVOICE_INFO::setEXPIRE_DATE()
     * @uses IDENTITY_INVOICE_INFO::setNATIONAL_BANK_CODE()
     * @uses IDENTITY_INVOICE_INFO::setGROUP_ID()
     * @uses IDENTITY_INVOICE_INFO::setDEF_AUTHORIZER()
     * @uses IDENTITY_INVOICE_INFO::setPAY_TERM_ID()
     * @uses IDENTITY_INVOICE_INFO::setDEF_VAT_CODE()
     * @uses IDENTITY_INVOICE_INFO::setDEF_CURRENCY()
     * @uses IDENTITY_INVOICE_INFO::setPAYM_DEV_DAYS()
     * @uses IDENTITY_INVOICE_INFO::setIDENTITY_TYPE_DB()
     * @uses IDENTITY_INVOICE_INFO::setDEF_PRELIMINARY_CODE()
     * @uses IDENTITY_INVOICE_INFO::setAUTOMATIC_INVOICE()
     * @uses IDENTITY_INVOICE_INFO::setPERCENT_TOLERANCE()
     * @uses IDENTITY_INVOICE_INFO::setAMOUNT_TOLERANCE()
     * @uses IDENTITY_INVOICE_INFO::setNCF_REFERENCE_CHECK()
     * @uses IDENTITY_INVOICE_INFO::setTAX_EXEMPT()
     * @uses IDENTITY_INVOICE_INFO::setTAX_EXEMPT_VALID_FROM()
     * @uses IDENTITY_INVOICE_INFO::setTAX_EXEMPT_VALID_TO()
     * @uses IDENTITY_INVOICE_INFO::setSECOND_TIN()
     * @uses IDENTITY_INVOICE_INFO::setREPORT_AND_WITHHOLD_DB()
     * @uses IDENTITY_INVOICE_INFO::setSUPPLIER_TAX_OFFICE_ID()
     * @uses IDENTITY_INVOICE_INFO::setAUTO_CREATION_TAX_LINES()
     * @uses IDENTITY_INVOICE_INFO::setNUMERATION_GROUP()
     * @uses IDENTITY_INVOICE_INFO::setTAX_BOOK_ID()
     * @uses IDENTITY_INVOICE_INFO::setTAX_BOOK_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setTAX_STRUCTURE_ID()
     * @uses IDENTITY_INVOICE_INFO::setPRINT_TAX_CODE_TEXT()
     * @uses IDENTITY_INVOICE_INFO::setNO_INVOICE_COPIES()
     * @uses IDENTITY_INVOICE_INFO::setTAX_REGIME_DB()
     * @uses IDENTITY_INVOICE_INFO::setDEF_MAN_SUPP_INV_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setDEF_AUTO_INVOICE_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setDEF_REC_MAN_SUPP_INV_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setLIABILITY_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setCURRENCY_CODE()
     * @uses IDENTITY_INVOICE_INFO::setCOUNTRY_CODE()
     * @uses IDENTITY_INVOICE_INFO::setWITHHOLDING_BASE_AMOUNT()
     * @uses IDENTITY_INVOICE_INFO::setWITHHOLDING_BASE_AMOUNT_DB()
     * @uses IDENTITY_INVOICE_INFO::setINVOICE_RECIPIENT()
     * @uses IDENTITY_INVOICE_INFO::setINVOICING_SUPPLIER()
     * @uses IDENTITY_INVOICE_INFO::setMATCHING_LEVEL_DB()
     * @uses IDENTITY_INVOICE_INFO::setALLOW_TOLERANCE()
     * @uses IDENTITY_INVOICE_INFO::setCREATE_TOLERANCE_POSTING()
     * @uses IDENTITY_INVOICE_INFO::setALLOW_QUANTITY_DIFF()
     * @uses IDENTITY_INVOICE_INFO::setDEFAULT_CURRENCY_RATE_TYPE()
     * @uses IDENTITY_INVOICE_INFO::setTAX_CERTIFICATE_FORM()
     * @uses IDENTITY_INVOICE_INFO::setTAX_CERTIFICATE_FORM_DB()
     * @uses IDENTITY_INVOICE_INFO::setIS_NOTE()
     * @uses IDENTITY_INVOICE_INFO::setDELIV_TYPE_ID()
     * @uses IDENTITY_INVOICE_INFO::setSUP_VAT_FREE_VAT_CODE()
     * @uses IDENTITY_INVOICE_INFO::setSUP_COUNTRY_CODE()
     * @uses IDENTITY_INVOICE_INFO::setAUTOMATIC_PAY_AUTH_FLAG_DB()
     * @uses IDENTITY_INVOICE_INFO::setCUSTOMER_ID()
     * @uses IDENTITY_INVOICE_INFO::setSUPPLIER_ID()
     * @uses IDENTITY_INVOICE_INFO::setINACTIVE_REASON_DESC()
     * @uses IDENTITY_INVOICE_INFO::setLEGAL_IDENTITY()
     * @uses IDENTITY_INVOICE_INFO::setLEGAL_IDENTITY_DB()
     * @uses IDENTITY_INVOICE_INFO::setPO_REF_REC_REF_VAL_METHOD_DB()
     * @uses IDENTITY_INVOICE_INFO::setPOSTING_TEMPLATE_ID()
     * @uses IDENTITY_INVOICE_INFO::setLEGAL_ID_NAME()
     * @uses IDENTITY_INVOICE_INFO::setLEGAL_ID_ADDR_ID()
     * @uses IDENTITY_INVOICE_INFO::setOPERATION()
     * @uses IDENTITY_INVOICE_INFO::setPAY_INFO()
     * @uses IDENTITY_INVOICE_INFO::setCREDIT()
     * @param string $cOMPANY
     * @param string $iDENTITY
     * @param string $pARTY_TYPE_DB
     * @param string $iNVOICE_FEE
     * @param string $eXPIRE_DATE
     * @param string $nATIONAL_BANK_CODE
     * @param string $gROUP_ID
     * @param string $dEF_AUTHORIZER
     * @param string $pAY_TERM_ID
     * @param string $dEF_VAT_CODE
     * @param string $dEF_CURRENCY
     * @param float $pAYM_DEV_DAYS
     * @param string $iDENTITY_TYPE_DB
     * @param string $dEF_PRELIMINARY_CODE
     * @param string $aUTOMATIC_INVOICE
     * @param float $pERCENT_TOLERANCE
     * @param float $aMOUNT_TOLERANCE
     * @param string $nCF_REFERENCE_CHECK
     * @param string $tAX_EXEMPT
     * @param string $tAX_EXEMPT_VALID_FROM
     * @param string $tAX_EXEMPT_VALID_TO
     * @param string $sECOND_TIN
     * @param string $rEPORT_AND_WITHHOLD_DB
     * @param string $sUPPLIER_TAX_OFFICE_ID
     * @param string $aUTO_CREATION_TAX_LINES
     * @param string $nUMERATION_GROUP
     * @param string $tAX_BOOK_ID
     * @param float $tAX_BOOK_TYPE
     * @param string $tAX_STRUCTURE_ID
     * @param string $pRINT_TAX_CODE_TEXT
     * @param float $nO_INVOICE_COPIES
     * @param string $tAX_REGIME_DB
     * @param string $dEF_MAN_SUPP_INV_TYPE
     * @param string $dEF_AUTO_INVOICE_TYPE
     * @param string $dEF_REC_MAN_SUPP_INV_TYPE
     * @param string $lIABILITY_TYPE
     * @param string $cURRENCY_CODE
     * @param string $cOUNTRY_CODE
     * @param string $wITHHOLDING_BASE_AMOUNT
     * @param string $wITHHOLDING_BASE_AMOUNT_DB
     * @param string $iNVOICE_RECIPIENT
     * @param string $iNVOICING_SUPPLIER
     * @param string $mATCHING_LEVEL_DB
     * @param string $aLLOW_TOLERANCE
     * @param string $cREATE_TOLERANCE_POSTING
     * @param string $aLLOW_QUANTITY_DIFF
     * @param string $dEFAULT_CURRENCY_RATE_TYPE
     * @param string $tAX_CERTIFICATE_FORM
     * @param string $tAX_CERTIFICATE_FORM_DB
     * @param string $iS_NOTE
     * @param string $dELIV_TYPE_ID
     * @param string $sUP_VAT_FREE_VAT_CODE
     * @param string $sUP_COUNTRY_CODE
     * @param string $aUTOMATIC_PAY_AUTH_FLAG_DB
     * @param string $cUSTOMER_ID
     * @param string $sUPPLIER_ID
     * @param string $iNACTIVE_REASON_DESC
     * @param string $lEGAL_IDENTITY
     * @param string $lEGAL_IDENTITY_DB
     * @param string $pO_REF_REC_REF_VAL_METHOD_DB
     * @param string $pOSTING_TEMPLATE_ID
     * @param string $lEGAL_ID_NAME
     * @param string $lEGAL_ID_ADDR_ID
     * @param string $oPERATION
     * @param \StructType\PAY_INFO $pAY_INFO
     * @param \StructType\CREDIT $cREDIT
     */
    public function __construct($cOMPANY = null, $iDENTITY = null, $pARTY_TYPE_DB = null, $iNVOICE_FEE = null, $eXPIRE_DATE = null, $nATIONAL_BANK_CODE = null, $gROUP_ID = null, $dEF_AUTHORIZER = null, $pAY_TERM_ID = null, $dEF_VAT_CODE = null, $dEF_CURRENCY = null, $pAYM_DEV_DAYS = null, $iDENTITY_TYPE_DB = null, $dEF_PRELIMINARY_CODE = null, $aUTOMATIC_INVOICE = null, $pERCENT_TOLERANCE = null, $aMOUNT_TOLERANCE = null, $nCF_REFERENCE_CHECK = null, $tAX_EXEMPT = null, $tAX_EXEMPT_VALID_FROM = null, $tAX_EXEMPT_VALID_TO = null, $sECOND_TIN = null, $rEPORT_AND_WITHHOLD_DB = null, $sUPPLIER_TAX_OFFICE_ID = null, $aUTO_CREATION_TAX_LINES = null, $nUMERATION_GROUP = null, $tAX_BOOK_ID = null, $tAX_BOOK_TYPE = null, $tAX_STRUCTURE_ID = null, $pRINT_TAX_CODE_TEXT = null, $nO_INVOICE_COPIES = null, $tAX_REGIME_DB = null, $dEF_MAN_SUPP_INV_TYPE = null, $dEF_AUTO_INVOICE_TYPE = null, $dEF_REC_MAN_SUPP_INV_TYPE = null, $lIABILITY_TYPE = null, $cURRENCY_CODE = null, $cOUNTRY_CODE = null, $wITHHOLDING_BASE_AMOUNT = null, $wITHHOLDING_BASE_AMOUNT_DB = null, $iNVOICE_RECIPIENT = null, $iNVOICING_SUPPLIER = null, $mATCHING_LEVEL_DB = null, $aLLOW_TOLERANCE = null, $cREATE_TOLERANCE_POSTING = null, $aLLOW_QUANTITY_DIFF = null, $dEFAULT_CURRENCY_RATE_TYPE = null, $tAX_CERTIFICATE_FORM = null, $tAX_CERTIFICATE_FORM_DB = null, $iS_NOTE = null, $dELIV_TYPE_ID = null, $sUP_VAT_FREE_VAT_CODE = null, $sUP_COUNTRY_CODE = null, $aUTOMATIC_PAY_AUTH_FLAG_DB = null, $cUSTOMER_ID = null, $sUPPLIER_ID = null, $iNACTIVE_REASON_DESC = null, $lEGAL_IDENTITY = null, $lEGAL_IDENTITY_DB = null, $pO_REF_REC_REF_VAL_METHOD_DB = null, $pOSTING_TEMPLATE_ID = null, $lEGAL_ID_NAME = null, $lEGAL_ID_ADDR_ID = null, $oPERATION = null, \StructType\PAY_INFO $pAY_INFO = null, \StructType\CREDIT $cREDIT = null)
    {
        $this
            ->setCOMPANY($cOMPANY)
            ->setIDENTITY($iDENTITY)
            ->setPARTY_TYPE_DB($pARTY_TYPE_DB)
            ->setINVOICE_FEE($iNVOICE_FEE)
            ->setEXPIRE_DATE($eXPIRE_DATE)
            ->setNATIONAL_BANK_CODE($nATIONAL_BANK_CODE)
            ->setGROUP_ID($gROUP_ID)
            ->setDEF_AUTHORIZER($dEF_AUTHORIZER)
            ->setPAY_TERM_ID($pAY_TERM_ID)
            ->setDEF_VAT_CODE($dEF_VAT_CODE)
            ->setDEF_CURRENCY($dEF_CURRENCY)
            ->setPAYM_DEV_DAYS($pAYM_DEV_DAYS)
            ->setIDENTITY_TYPE_DB($iDENTITY_TYPE_DB)
            ->setDEF_PRELIMINARY_CODE($dEF_PRELIMINARY_CODE)
            ->setAUTOMATIC_INVOICE($aUTOMATIC_INVOICE)
            ->setPERCENT_TOLERANCE($pERCENT_TOLERANCE)
            ->setAMOUNT_TOLERANCE($aMOUNT_TOLERANCE)
            ->setNCF_REFERENCE_CHECK($nCF_REFERENCE_CHECK)
            ->setTAX_EXEMPT($tAX_EXEMPT)
            ->setTAX_EXEMPT_VALID_FROM($tAX_EXEMPT_VALID_FROM)
            ->setTAX_EXEMPT_VALID_TO($tAX_EXEMPT_VALID_TO)
            ->setSECOND_TIN($sECOND_TIN)
            ->setREPORT_AND_WITHHOLD_DB($rEPORT_AND_WITHHOLD_DB)
            ->setSUPPLIER_TAX_OFFICE_ID($sUPPLIER_TAX_OFFICE_ID)
            ->setAUTO_CREATION_TAX_LINES($aUTO_CREATION_TAX_LINES)
            ->setNUMERATION_GROUP($nUMERATION_GROUP)
            ->setTAX_BOOK_ID($tAX_BOOK_ID)
            ->setTAX_BOOK_TYPE($tAX_BOOK_TYPE)
            ->setTAX_STRUCTURE_ID($tAX_STRUCTURE_ID)
            ->setPRINT_TAX_CODE_TEXT($pRINT_TAX_CODE_TEXT)
            ->setNO_INVOICE_COPIES($nO_INVOICE_COPIES)
            ->setTAX_REGIME_DB($tAX_REGIME_DB)
            ->setDEF_MAN_SUPP_INV_TYPE($dEF_MAN_SUPP_INV_TYPE)
            ->setDEF_AUTO_INVOICE_TYPE($dEF_AUTO_INVOICE_TYPE)
            ->setDEF_REC_MAN_SUPP_INV_TYPE($dEF_REC_MAN_SUPP_INV_TYPE)
            ->setLIABILITY_TYPE($lIABILITY_TYPE)
            ->setCURRENCY_CODE($cURRENCY_CODE)
            ->setCOUNTRY_CODE($cOUNTRY_CODE)
            ->setWITHHOLDING_BASE_AMOUNT($wITHHOLDING_BASE_AMOUNT)
            ->setWITHHOLDING_BASE_AMOUNT_DB($wITHHOLDING_BASE_AMOUNT_DB)
            ->setINVOICE_RECIPIENT($iNVOICE_RECIPIENT)
            ->setINVOICING_SUPPLIER($iNVOICING_SUPPLIER)
            ->setMATCHING_LEVEL_DB($mATCHING_LEVEL_DB)
            ->setALLOW_TOLERANCE($aLLOW_TOLERANCE)
            ->setCREATE_TOLERANCE_POSTING($cREATE_TOLERANCE_POSTING)
            ->setALLOW_QUANTITY_DIFF($aLLOW_QUANTITY_DIFF)
            ->setDEFAULT_CURRENCY_RATE_TYPE($dEFAULT_CURRENCY_RATE_TYPE)
            ->setTAX_CERTIFICATE_FORM($tAX_CERTIFICATE_FORM)
            ->setTAX_CERTIFICATE_FORM_DB($tAX_CERTIFICATE_FORM_DB)
            ->setIS_NOTE($iS_NOTE)
            ->setDELIV_TYPE_ID($dELIV_TYPE_ID)
            ->setSUP_VAT_FREE_VAT_CODE($sUP_VAT_FREE_VAT_CODE)
            ->setSUP_COUNTRY_CODE($sUP_COUNTRY_CODE)
            ->setAUTOMATIC_PAY_AUTH_FLAG_DB($aUTOMATIC_PAY_AUTH_FLAG_DB)
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setSUPPLIER_ID($sUPPLIER_ID)
            ->setINACTIVE_REASON_DESC($iNACTIVE_REASON_DESC)
            ->setLEGAL_IDENTITY($lEGAL_IDENTITY)
            ->setLEGAL_IDENTITY_DB($lEGAL_IDENTITY_DB)
            ->setPO_REF_REC_REF_VAL_METHOD_DB($pO_REF_REC_REF_VAL_METHOD_DB)
            ->setPOSTING_TEMPLATE_ID($pOSTING_TEMPLATE_ID)
            ->setLEGAL_ID_NAME($lEGAL_ID_NAME)
            ->setLEGAL_ID_ADDR_ID($lEGAL_ID_ADDR_ID)
            ->setOPERATION($oPERATION)
            ->setPAY_INFO($pAY_INFO)
            ->setCREDIT($cREDIT);
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTITY()
    {
        return isset($this->IDENTITY) ? $this->IDENTITY : null;
    }
    /**
     * Set IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTITY
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setIDENTITY($iDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTITY) && !is_string($iDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTITY)), __LINE__);
        }
        if (is_null($iDENTITY) || (is_array($iDENTITY) && empty($iDENTITY))) {
            unset($this->IDENTITY);
        } else {
            $this->IDENTITY = $iDENTITY;
        }
        return $this;
    }
    /**
     * Get PARTY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY_TYPE_DB()
    {
        return isset($this->PARTY_TYPE_DB) ? $this->PARTY_TYPE_DB : null;
    }
    /**
     * Set PARTY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY_TYPE_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPARTY_TYPE_DB($pARTY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY_TYPE_DB) && !is_string($pARTY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY_TYPE_DB)), __LINE__);
        }
        if (is_null($pARTY_TYPE_DB) || (is_array($pARTY_TYPE_DB) && empty($pARTY_TYPE_DB))) {
            unset($this->PARTY_TYPE_DB);
        } else {
            $this->PARTY_TYPE_DB = $pARTY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get INVOICE_FEE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVOICE_FEE()
    {
        return isset($this->INVOICE_FEE) ? $this->INVOICE_FEE : null;
    }
    /**
     * Set INVOICE_FEE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVOICE_FEE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setINVOICE_FEE($iNVOICE_FEE = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_FEE) && !is_string($iNVOICE_FEE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_FEE)), __LINE__);
        }
        if (is_null($iNVOICE_FEE) || (is_array($iNVOICE_FEE) && empty($iNVOICE_FEE))) {
            unset($this->INVOICE_FEE);
        } else {
            $this->INVOICE_FEE = $iNVOICE_FEE;
        }
        return $this;
    }
    /**
     * Get EXPIRE_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEXPIRE_DATE()
    {
        return isset($this->EXPIRE_DATE) ? $this->EXPIRE_DATE : null;
    }
    /**
     * Set EXPIRE_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eXPIRE_DATE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setEXPIRE_DATE($eXPIRE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($eXPIRE_DATE) && !is_string($eXPIRE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eXPIRE_DATE)), __LINE__);
        }
        if (is_null($eXPIRE_DATE) || (is_array($eXPIRE_DATE) && empty($eXPIRE_DATE))) {
            unset($this->EXPIRE_DATE);
        } else {
            $this->EXPIRE_DATE = $eXPIRE_DATE;
        }
        return $this;
    }
    /**
     * Get NATIONAL_BANK_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNATIONAL_BANK_CODE()
    {
        return isset($this->NATIONAL_BANK_CODE) ? $this->NATIONAL_BANK_CODE : null;
    }
    /**
     * Set NATIONAL_BANK_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nATIONAL_BANK_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setNATIONAL_BANK_CODE($nATIONAL_BANK_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($nATIONAL_BANK_CODE) && !is_string($nATIONAL_BANK_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nATIONAL_BANK_CODE)), __LINE__);
        }
        if (is_null($nATIONAL_BANK_CODE) || (is_array($nATIONAL_BANK_CODE) && empty($nATIONAL_BANK_CODE))) {
            unset($this->NATIONAL_BANK_CODE);
        } else {
            $this->NATIONAL_BANK_CODE = $nATIONAL_BANK_CODE;
        }
        return $this;
    }
    /**
     * Get GROUP_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGROUP_ID()
    {
        return isset($this->GROUP_ID) ? $this->GROUP_ID : null;
    }
    /**
     * Set GROUP_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gROUP_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setGROUP_ID($gROUP_ID = null)
    {
        // validation for constraint: string
        if (!is_null($gROUP_ID) && !is_string($gROUP_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gROUP_ID)), __LINE__);
        }
        if (is_null($gROUP_ID) || (is_array($gROUP_ID) && empty($gROUP_ID))) {
            unset($this->GROUP_ID);
        } else {
            $this->GROUP_ID = $gROUP_ID;
        }
        return $this;
    }
    /**
     * Get DEF_AUTHORIZER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_AUTHORIZER()
    {
        return isset($this->DEF_AUTHORIZER) ? $this->DEF_AUTHORIZER : null;
    }
    /**
     * Set DEF_AUTHORIZER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_AUTHORIZER
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_AUTHORIZER($dEF_AUTHORIZER = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_AUTHORIZER) && !is_string($dEF_AUTHORIZER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_AUTHORIZER)), __LINE__);
        }
        if (is_null($dEF_AUTHORIZER) || (is_array($dEF_AUTHORIZER) && empty($dEF_AUTHORIZER))) {
            unset($this->DEF_AUTHORIZER);
        } else {
            $this->DEF_AUTHORIZER = $dEF_AUTHORIZER;
        }
        return $this;
    }
    /**
     * Get PAY_TERM_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPAY_TERM_ID()
    {
        return isset($this->PAY_TERM_ID) ? $this->PAY_TERM_ID : null;
    }
    /**
     * Set PAY_TERM_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pAY_TERM_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPAY_TERM_ID($pAY_TERM_ID = null)
    {
        // validation for constraint: string
        if (!is_null($pAY_TERM_ID) && !is_string($pAY_TERM_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pAY_TERM_ID)), __LINE__);
        }
        if (is_null($pAY_TERM_ID) || (is_array($pAY_TERM_ID) && empty($pAY_TERM_ID))) {
            unset($this->PAY_TERM_ID);
        } else {
            $this->PAY_TERM_ID = $pAY_TERM_ID;
        }
        return $this;
    }
    /**
     * Get DEF_VAT_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_VAT_CODE()
    {
        return isset($this->DEF_VAT_CODE) ? $this->DEF_VAT_CODE : null;
    }
    /**
     * Set DEF_VAT_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_VAT_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_VAT_CODE($dEF_VAT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_VAT_CODE) && !is_string($dEF_VAT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_VAT_CODE)), __LINE__);
        }
        if (is_null($dEF_VAT_CODE) || (is_array($dEF_VAT_CODE) && empty($dEF_VAT_CODE))) {
            unset($this->DEF_VAT_CODE);
        } else {
            $this->DEF_VAT_CODE = $dEF_VAT_CODE;
        }
        return $this;
    }
    /**
     * Get DEF_CURRENCY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_CURRENCY()
    {
        return isset($this->DEF_CURRENCY) ? $this->DEF_CURRENCY : null;
    }
    /**
     * Set DEF_CURRENCY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_CURRENCY
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_CURRENCY($dEF_CURRENCY = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_CURRENCY) && !is_string($dEF_CURRENCY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_CURRENCY)), __LINE__);
        }
        if (is_null($dEF_CURRENCY) || (is_array($dEF_CURRENCY) && empty($dEF_CURRENCY))) {
            unset($this->DEF_CURRENCY);
        } else {
            $this->DEF_CURRENCY = $dEF_CURRENCY;
        }
        return $this;
    }
    /**
     * Get PAYM_DEV_DAYS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPAYM_DEV_DAYS()
    {
        return isset($this->PAYM_DEV_DAYS) ? $this->PAYM_DEV_DAYS : null;
    }
    /**
     * Set PAYM_DEV_DAYS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pAYM_DEV_DAYS
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPAYM_DEV_DAYS($pAYM_DEV_DAYS = null)
    {
        if (is_null($pAYM_DEV_DAYS) || (is_array($pAYM_DEV_DAYS) && empty($pAYM_DEV_DAYS))) {
            unset($this->PAYM_DEV_DAYS);
        } else {
            $this->PAYM_DEV_DAYS = $pAYM_DEV_DAYS;
        }
        return $this;
    }
    /**
     * Get IDENTITY_TYPE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDENTITY_TYPE_DB()
    {
        return isset($this->IDENTITY_TYPE_DB) ? $this->IDENTITY_TYPE_DB : null;
    }
    /**
     * Set IDENTITY_TYPE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDENTITY_TYPE_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setIDENTITY_TYPE_DB($iDENTITY_TYPE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTITY_TYPE_DB) && !is_string($iDENTITY_TYPE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTITY_TYPE_DB)), __LINE__);
        }
        if (is_null($iDENTITY_TYPE_DB) || (is_array($iDENTITY_TYPE_DB) && empty($iDENTITY_TYPE_DB))) {
            unset($this->IDENTITY_TYPE_DB);
        } else {
            $this->IDENTITY_TYPE_DB = $iDENTITY_TYPE_DB;
        }
        return $this;
    }
    /**
     * Get DEF_PRELIMINARY_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_PRELIMINARY_CODE()
    {
        return isset($this->DEF_PRELIMINARY_CODE) ? $this->DEF_PRELIMINARY_CODE : null;
    }
    /**
     * Set DEF_PRELIMINARY_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_PRELIMINARY_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_PRELIMINARY_CODE($dEF_PRELIMINARY_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_PRELIMINARY_CODE) && !is_string($dEF_PRELIMINARY_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_PRELIMINARY_CODE)), __LINE__);
        }
        if (is_null($dEF_PRELIMINARY_CODE) || (is_array($dEF_PRELIMINARY_CODE) && empty($dEF_PRELIMINARY_CODE))) {
            unset($this->DEF_PRELIMINARY_CODE);
        } else {
            $this->DEF_PRELIMINARY_CODE = $dEF_PRELIMINARY_CODE;
        }
        return $this;
    }
    /**
     * Get AUTOMATIC_INVOICE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAUTOMATIC_INVOICE()
    {
        return isset($this->AUTOMATIC_INVOICE) ? $this->AUTOMATIC_INVOICE : null;
    }
    /**
     * Set AUTOMATIC_INVOICE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aUTOMATIC_INVOICE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setAUTOMATIC_INVOICE($aUTOMATIC_INVOICE = null)
    {
        // validation for constraint: string
        if (!is_null($aUTOMATIC_INVOICE) && !is_string($aUTOMATIC_INVOICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUTOMATIC_INVOICE)), __LINE__);
        }
        if (is_null($aUTOMATIC_INVOICE) || (is_array($aUTOMATIC_INVOICE) && empty($aUTOMATIC_INVOICE))) {
            unset($this->AUTOMATIC_INVOICE);
        } else {
            $this->AUTOMATIC_INVOICE = $aUTOMATIC_INVOICE;
        }
        return $this;
    }
    /**
     * Get PERCENT_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPERCENT_TOLERANCE()
    {
        return isset($this->PERCENT_TOLERANCE) ? $this->PERCENT_TOLERANCE : null;
    }
    /**
     * Set PERCENT_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pERCENT_TOLERANCE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPERCENT_TOLERANCE($pERCENT_TOLERANCE = null)
    {
        if (is_null($pERCENT_TOLERANCE) || (is_array($pERCENT_TOLERANCE) && empty($pERCENT_TOLERANCE))) {
            unset($this->PERCENT_TOLERANCE);
        } else {
            $this->PERCENT_TOLERANCE = $pERCENT_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get AMOUNT_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAMOUNT_TOLERANCE()
    {
        return isset($this->AMOUNT_TOLERANCE) ? $this->AMOUNT_TOLERANCE : null;
    }
    /**
     * Set AMOUNT_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aMOUNT_TOLERANCE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setAMOUNT_TOLERANCE($aMOUNT_TOLERANCE = null)
    {
        if (is_null($aMOUNT_TOLERANCE) || (is_array($aMOUNT_TOLERANCE) && empty($aMOUNT_TOLERANCE))) {
            unset($this->AMOUNT_TOLERANCE);
        } else {
            $this->AMOUNT_TOLERANCE = $aMOUNT_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get NCF_REFERENCE_CHECK value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNCF_REFERENCE_CHECK()
    {
        return isset($this->NCF_REFERENCE_CHECK) ? $this->NCF_REFERENCE_CHECK : null;
    }
    /**
     * Set NCF_REFERENCE_CHECK value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nCF_REFERENCE_CHECK
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setNCF_REFERENCE_CHECK($nCF_REFERENCE_CHECK = null)
    {
        // validation for constraint: string
        if (!is_null($nCF_REFERENCE_CHECK) && !is_string($nCF_REFERENCE_CHECK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nCF_REFERENCE_CHECK)), __LINE__);
        }
        if (is_null($nCF_REFERENCE_CHECK) || (is_array($nCF_REFERENCE_CHECK) && empty($nCF_REFERENCE_CHECK))) {
            unset($this->NCF_REFERENCE_CHECK);
        } else {
            $this->NCF_REFERENCE_CHECK = $nCF_REFERENCE_CHECK;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT()
    {
        return isset($this->TAX_EXEMPT) ? $this->TAX_EXEMPT : null;
    }
    /**
     * Set TAX_EXEMPT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_EXEMPT($tAX_EXEMPT = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT) && !is_string($tAX_EXEMPT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT)), __LINE__);
        }
        if (is_null($tAX_EXEMPT) || (is_array($tAX_EXEMPT) && empty($tAX_EXEMPT))) {
            unset($this->TAX_EXEMPT);
        } else {
            $this->TAX_EXEMPT = $tAX_EXEMPT;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT_VALID_FROM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT_VALID_FROM()
    {
        return isset($this->TAX_EXEMPT_VALID_FROM) ? $this->TAX_EXEMPT_VALID_FROM : null;
    }
    /**
     * Set TAX_EXEMPT_VALID_FROM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT_VALID_FROM
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_EXEMPT_VALID_FROM($tAX_EXEMPT_VALID_FROM = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT_VALID_FROM) && !is_string($tAX_EXEMPT_VALID_FROM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT_VALID_FROM)), __LINE__);
        }
        if (is_null($tAX_EXEMPT_VALID_FROM) || (is_array($tAX_EXEMPT_VALID_FROM) && empty($tAX_EXEMPT_VALID_FROM))) {
            unset($this->TAX_EXEMPT_VALID_FROM);
        } else {
            $this->TAX_EXEMPT_VALID_FROM = $tAX_EXEMPT_VALID_FROM;
        }
        return $this;
    }
    /**
     * Get TAX_EXEMPT_VALID_TO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_EXEMPT_VALID_TO()
    {
        return isset($this->TAX_EXEMPT_VALID_TO) ? $this->TAX_EXEMPT_VALID_TO : null;
    }
    /**
     * Set TAX_EXEMPT_VALID_TO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_EXEMPT_VALID_TO
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_EXEMPT_VALID_TO($tAX_EXEMPT_VALID_TO = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_EXEMPT_VALID_TO) && !is_string($tAX_EXEMPT_VALID_TO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_EXEMPT_VALID_TO)), __LINE__);
        }
        if (is_null($tAX_EXEMPT_VALID_TO) || (is_array($tAX_EXEMPT_VALID_TO) && empty($tAX_EXEMPT_VALID_TO))) {
            unset($this->TAX_EXEMPT_VALID_TO);
        } else {
            $this->TAX_EXEMPT_VALID_TO = $tAX_EXEMPT_VALID_TO;
        }
        return $this;
    }
    /**
     * Get SECOND_TIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSECOND_TIN()
    {
        return isset($this->SECOND_TIN) ? $this->SECOND_TIN : null;
    }
    /**
     * Set SECOND_TIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sECOND_TIN
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setSECOND_TIN($sECOND_TIN = null)
    {
        // validation for constraint: string
        if (!is_null($sECOND_TIN) && !is_string($sECOND_TIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sECOND_TIN)), __LINE__);
        }
        if (is_null($sECOND_TIN) || (is_array($sECOND_TIN) && empty($sECOND_TIN))) {
            unset($this->SECOND_TIN);
        } else {
            $this->SECOND_TIN = $sECOND_TIN;
        }
        return $this;
    }
    /**
     * Get REPORT_AND_WITHHOLD_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getREPORT_AND_WITHHOLD_DB()
    {
        return isset($this->REPORT_AND_WITHHOLD_DB) ? $this->REPORT_AND_WITHHOLD_DB : null;
    }
    /**
     * Set REPORT_AND_WITHHOLD_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rEPORT_AND_WITHHOLD_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setREPORT_AND_WITHHOLD_DB($rEPORT_AND_WITHHOLD_DB = null)
    {
        // validation for constraint: string
        if (!is_null($rEPORT_AND_WITHHOLD_DB) && !is_string($rEPORT_AND_WITHHOLD_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEPORT_AND_WITHHOLD_DB)), __LINE__);
        }
        if (is_null($rEPORT_AND_WITHHOLD_DB) || (is_array($rEPORT_AND_WITHHOLD_DB) && empty($rEPORT_AND_WITHHOLD_DB))) {
            unset($this->REPORT_AND_WITHHOLD_DB);
        } else {
            $this->REPORT_AND_WITHHOLD_DB = $rEPORT_AND_WITHHOLD_DB;
        }
        return $this;
    }
    /**
     * Get SUPPLIER_TAX_OFFICE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLIER_TAX_OFFICE_ID()
    {
        return isset($this->SUPPLIER_TAX_OFFICE_ID) ? $this->SUPPLIER_TAX_OFFICE_ID : null;
    }
    /**
     * Set SUPPLIER_TAX_OFFICE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLIER_TAX_OFFICE_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setSUPPLIER_TAX_OFFICE_ID($sUPPLIER_TAX_OFFICE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLIER_TAX_OFFICE_ID) && !is_string($sUPPLIER_TAX_OFFICE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLIER_TAX_OFFICE_ID)), __LINE__);
        }
        if (is_null($sUPPLIER_TAX_OFFICE_ID) || (is_array($sUPPLIER_TAX_OFFICE_ID) && empty($sUPPLIER_TAX_OFFICE_ID))) {
            unset($this->SUPPLIER_TAX_OFFICE_ID);
        } else {
            $this->SUPPLIER_TAX_OFFICE_ID = $sUPPLIER_TAX_OFFICE_ID;
        }
        return $this;
    }
    /**
     * Get AUTO_CREATION_TAX_LINES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAUTO_CREATION_TAX_LINES()
    {
        return isset($this->AUTO_CREATION_TAX_LINES) ? $this->AUTO_CREATION_TAX_LINES : null;
    }
    /**
     * Set AUTO_CREATION_TAX_LINES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aUTO_CREATION_TAX_LINES
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setAUTO_CREATION_TAX_LINES($aUTO_CREATION_TAX_LINES = null)
    {
        // validation for constraint: string
        if (!is_null($aUTO_CREATION_TAX_LINES) && !is_string($aUTO_CREATION_TAX_LINES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUTO_CREATION_TAX_LINES)), __LINE__);
        }
        if (is_null($aUTO_CREATION_TAX_LINES) || (is_array($aUTO_CREATION_TAX_LINES) && empty($aUTO_CREATION_TAX_LINES))) {
            unset($this->AUTO_CREATION_TAX_LINES);
        } else {
            $this->AUTO_CREATION_TAX_LINES = $aUTO_CREATION_TAX_LINES;
        }
        return $this;
    }
    /**
     * Get NUMERATION_GROUP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNUMERATION_GROUP()
    {
        return isset($this->NUMERATION_GROUP) ? $this->NUMERATION_GROUP : null;
    }
    /**
     * Set NUMERATION_GROUP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nUMERATION_GROUP
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setNUMERATION_GROUP($nUMERATION_GROUP = null)
    {
        // validation for constraint: string
        if (!is_null($nUMERATION_GROUP) && !is_string($nUMERATION_GROUP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nUMERATION_GROUP)), __LINE__);
        }
        if (is_null($nUMERATION_GROUP) || (is_array($nUMERATION_GROUP) && empty($nUMERATION_GROUP))) {
            unset($this->NUMERATION_GROUP);
        } else {
            $this->NUMERATION_GROUP = $nUMERATION_GROUP;
        }
        return $this;
    }
    /**
     * Get TAX_BOOK_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_BOOK_ID()
    {
        return isset($this->TAX_BOOK_ID) ? $this->TAX_BOOK_ID : null;
    }
    /**
     * Set TAX_BOOK_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_BOOK_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_BOOK_ID($tAX_BOOK_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_BOOK_ID) && !is_string($tAX_BOOK_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_BOOK_ID)), __LINE__);
        }
        if (is_null($tAX_BOOK_ID) || (is_array($tAX_BOOK_ID) && empty($tAX_BOOK_ID))) {
            unset($this->TAX_BOOK_ID);
        } else {
            $this->TAX_BOOK_ID = $tAX_BOOK_ID;
        }
        return $this;
    }
    /**
     * Get TAX_BOOK_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTAX_BOOK_TYPE()
    {
        return isset($this->TAX_BOOK_TYPE) ? $this->TAX_BOOK_TYPE : null;
    }
    /**
     * Set TAX_BOOK_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tAX_BOOK_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_BOOK_TYPE($tAX_BOOK_TYPE = null)
    {
        if (is_null($tAX_BOOK_TYPE) || (is_array($tAX_BOOK_TYPE) && empty($tAX_BOOK_TYPE))) {
            unset($this->TAX_BOOK_TYPE);
        } else {
            $this->TAX_BOOK_TYPE = $tAX_BOOK_TYPE;
        }
        return $this;
    }
    /**
     * Get TAX_STRUCTURE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_STRUCTURE_ID()
    {
        return isset($this->TAX_STRUCTURE_ID) ? $this->TAX_STRUCTURE_ID : null;
    }
    /**
     * Set TAX_STRUCTURE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_STRUCTURE_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_STRUCTURE_ID($tAX_STRUCTURE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_STRUCTURE_ID) && !is_string($tAX_STRUCTURE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_STRUCTURE_ID)), __LINE__);
        }
        if (is_null($tAX_STRUCTURE_ID) || (is_array($tAX_STRUCTURE_ID) && empty($tAX_STRUCTURE_ID))) {
            unset($this->TAX_STRUCTURE_ID);
        } else {
            $this->TAX_STRUCTURE_ID = $tAX_STRUCTURE_ID;
        }
        return $this;
    }
    /**
     * Get PRINT_TAX_CODE_TEXT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPRINT_TAX_CODE_TEXT()
    {
        return isset($this->PRINT_TAX_CODE_TEXT) ? $this->PRINT_TAX_CODE_TEXT : null;
    }
    /**
     * Set PRINT_TAX_CODE_TEXT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pRINT_TAX_CODE_TEXT
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPRINT_TAX_CODE_TEXT($pRINT_TAX_CODE_TEXT = null)
    {
        // validation for constraint: string
        if (!is_null($pRINT_TAX_CODE_TEXT) && !is_string($pRINT_TAX_CODE_TEXT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRINT_TAX_CODE_TEXT)), __LINE__);
        }
        if (is_null($pRINT_TAX_CODE_TEXT) || (is_array($pRINT_TAX_CODE_TEXT) && empty($pRINT_TAX_CODE_TEXT))) {
            unset($this->PRINT_TAX_CODE_TEXT);
        } else {
            $this->PRINT_TAX_CODE_TEXT = $pRINT_TAX_CODE_TEXT;
        }
        return $this;
    }
    /**
     * Get NO_INVOICE_COPIES value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNO_INVOICE_COPIES()
    {
        return isset($this->NO_INVOICE_COPIES) ? $this->NO_INVOICE_COPIES : null;
    }
    /**
     * Set NO_INVOICE_COPIES value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nO_INVOICE_COPIES
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setNO_INVOICE_COPIES($nO_INVOICE_COPIES = null)
    {
        if (is_null($nO_INVOICE_COPIES) || (is_array($nO_INVOICE_COPIES) && empty($nO_INVOICE_COPIES))) {
            unset($this->NO_INVOICE_COPIES);
        } else {
            $this->NO_INVOICE_COPIES = $nO_INVOICE_COPIES;
        }
        return $this;
    }
    /**
     * Get TAX_REGIME_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_REGIME_DB()
    {
        return isset($this->TAX_REGIME_DB) ? $this->TAX_REGIME_DB : null;
    }
    /**
     * Set TAX_REGIME_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_REGIME_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_REGIME_DB($tAX_REGIME_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_REGIME_DB) && !is_string($tAX_REGIME_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_REGIME_DB)), __LINE__);
        }
        if (is_null($tAX_REGIME_DB) || (is_array($tAX_REGIME_DB) && empty($tAX_REGIME_DB))) {
            unset($this->TAX_REGIME_DB);
        } else {
            $this->TAX_REGIME_DB = $tAX_REGIME_DB;
        }
        return $this;
    }
    /**
     * Get DEF_MAN_SUPP_INV_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_MAN_SUPP_INV_TYPE()
    {
        return isset($this->DEF_MAN_SUPP_INV_TYPE) ? $this->DEF_MAN_SUPP_INV_TYPE : null;
    }
    /**
     * Set DEF_MAN_SUPP_INV_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_MAN_SUPP_INV_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_MAN_SUPP_INV_TYPE($dEF_MAN_SUPP_INV_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_MAN_SUPP_INV_TYPE) && !is_string($dEF_MAN_SUPP_INV_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_MAN_SUPP_INV_TYPE)), __LINE__);
        }
        if (is_null($dEF_MAN_SUPP_INV_TYPE) || (is_array($dEF_MAN_SUPP_INV_TYPE) && empty($dEF_MAN_SUPP_INV_TYPE))) {
            unset($this->DEF_MAN_SUPP_INV_TYPE);
        } else {
            $this->DEF_MAN_SUPP_INV_TYPE = $dEF_MAN_SUPP_INV_TYPE;
        }
        return $this;
    }
    /**
     * Get DEF_AUTO_INVOICE_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_AUTO_INVOICE_TYPE()
    {
        return isset($this->DEF_AUTO_INVOICE_TYPE) ? $this->DEF_AUTO_INVOICE_TYPE : null;
    }
    /**
     * Set DEF_AUTO_INVOICE_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_AUTO_INVOICE_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_AUTO_INVOICE_TYPE($dEF_AUTO_INVOICE_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_AUTO_INVOICE_TYPE) && !is_string($dEF_AUTO_INVOICE_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_AUTO_INVOICE_TYPE)), __LINE__);
        }
        if (is_null($dEF_AUTO_INVOICE_TYPE) || (is_array($dEF_AUTO_INVOICE_TYPE) && empty($dEF_AUTO_INVOICE_TYPE))) {
            unset($this->DEF_AUTO_INVOICE_TYPE);
        } else {
            $this->DEF_AUTO_INVOICE_TYPE = $dEF_AUTO_INVOICE_TYPE;
        }
        return $this;
    }
    /**
     * Get DEF_REC_MAN_SUPP_INV_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_REC_MAN_SUPP_INV_TYPE()
    {
        return isset($this->DEF_REC_MAN_SUPP_INV_TYPE) ? $this->DEF_REC_MAN_SUPP_INV_TYPE : null;
    }
    /**
     * Set DEF_REC_MAN_SUPP_INV_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_REC_MAN_SUPP_INV_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEF_REC_MAN_SUPP_INV_TYPE($dEF_REC_MAN_SUPP_INV_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_REC_MAN_SUPP_INV_TYPE) && !is_string($dEF_REC_MAN_SUPP_INV_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_REC_MAN_SUPP_INV_TYPE)), __LINE__);
        }
        if (is_null($dEF_REC_MAN_SUPP_INV_TYPE) || (is_array($dEF_REC_MAN_SUPP_INV_TYPE) && empty($dEF_REC_MAN_SUPP_INV_TYPE))) {
            unset($this->DEF_REC_MAN_SUPP_INV_TYPE);
        } else {
            $this->DEF_REC_MAN_SUPP_INV_TYPE = $dEF_REC_MAN_SUPP_INV_TYPE;
        }
        return $this;
    }
    /**
     * Get LIABILITY_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLIABILITY_TYPE()
    {
        return isset($this->LIABILITY_TYPE) ? $this->LIABILITY_TYPE : null;
    }
    /**
     * Set LIABILITY_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lIABILITY_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setLIABILITY_TYPE($lIABILITY_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($lIABILITY_TYPE) && !is_string($lIABILITY_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lIABILITY_TYPE)), __LINE__);
        }
        if (is_null($lIABILITY_TYPE) || (is_array($lIABILITY_TYPE) && empty($lIABILITY_TYPE))) {
            unset($this->LIABILITY_TYPE);
        } else {
            $this->LIABILITY_TYPE = $lIABILITY_TYPE;
        }
        return $this;
    }
    /**
     * Get CURRENCY_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCURRENCY_CODE()
    {
        return isset($this->CURRENCY_CODE) ? $this->CURRENCY_CODE : null;
    }
    /**
     * Set CURRENCY_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cURRENCY_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCURRENCY_CODE($cURRENCY_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cURRENCY_CODE) && !is_string($cURRENCY_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cURRENCY_CODE)), __LINE__);
        }
        if (is_null($cURRENCY_CODE) || (is_array($cURRENCY_CODE) && empty($cURRENCY_CODE))) {
            unset($this->CURRENCY_CODE);
        } else {
            $this->CURRENCY_CODE = $cURRENCY_CODE;
        }
        return $this;
    }
    /**
     * Get COUNTRY_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOUNTRY_CODE()
    {
        return isset($this->COUNTRY_CODE) ? $this->COUNTRY_CODE : null;
    }
    /**
     * Set COUNTRY_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOUNTRY_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCOUNTRY_CODE($cOUNTRY_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($cOUNTRY_CODE) && !is_string($cOUNTRY_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOUNTRY_CODE)), __LINE__);
        }
        if (is_null($cOUNTRY_CODE) || (is_array($cOUNTRY_CODE) && empty($cOUNTRY_CODE))) {
            unset($this->COUNTRY_CODE);
        } else {
            $this->COUNTRY_CODE = $cOUNTRY_CODE;
        }
        return $this;
    }
    /**
     * Get WITHHOLDING_BASE_AMOUNT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWITHHOLDING_BASE_AMOUNT()
    {
        return isset($this->WITHHOLDING_BASE_AMOUNT) ? $this->WITHHOLDING_BASE_AMOUNT : null;
    }
    /**
     * Set WITHHOLDING_BASE_AMOUNT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wITHHOLDING_BASE_AMOUNT
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setWITHHOLDING_BASE_AMOUNT($wITHHOLDING_BASE_AMOUNT = null)
    {
        // validation for constraint: string
        if (!is_null($wITHHOLDING_BASE_AMOUNT) && !is_string($wITHHOLDING_BASE_AMOUNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wITHHOLDING_BASE_AMOUNT)), __LINE__);
        }
        if (is_null($wITHHOLDING_BASE_AMOUNT) || (is_array($wITHHOLDING_BASE_AMOUNT) && empty($wITHHOLDING_BASE_AMOUNT))) {
            unset($this->WITHHOLDING_BASE_AMOUNT);
        } else {
            $this->WITHHOLDING_BASE_AMOUNT = $wITHHOLDING_BASE_AMOUNT;
        }
        return $this;
    }
    /**
     * Get WITHHOLDING_BASE_AMOUNT_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWITHHOLDING_BASE_AMOUNT_DB()
    {
        return isset($this->WITHHOLDING_BASE_AMOUNT_DB) ? $this->WITHHOLDING_BASE_AMOUNT_DB : null;
    }
    /**
     * Set WITHHOLDING_BASE_AMOUNT_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wITHHOLDING_BASE_AMOUNT_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setWITHHOLDING_BASE_AMOUNT_DB($wITHHOLDING_BASE_AMOUNT_DB = null)
    {
        // validation for constraint: string
        if (!is_null($wITHHOLDING_BASE_AMOUNT_DB) && !is_string($wITHHOLDING_BASE_AMOUNT_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wITHHOLDING_BASE_AMOUNT_DB)), __LINE__);
        }
        if (is_null($wITHHOLDING_BASE_AMOUNT_DB) || (is_array($wITHHOLDING_BASE_AMOUNT_DB) && empty($wITHHOLDING_BASE_AMOUNT_DB))) {
            unset($this->WITHHOLDING_BASE_AMOUNT_DB);
        } else {
            $this->WITHHOLDING_BASE_AMOUNT_DB = $wITHHOLDING_BASE_AMOUNT_DB;
        }
        return $this;
    }
    /**
     * Get INVOICE_RECIPIENT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVOICE_RECIPIENT()
    {
        return isset($this->INVOICE_RECIPIENT) ? $this->INVOICE_RECIPIENT : null;
    }
    /**
     * Set INVOICE_RECIPIENT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVOICE_RECIPIENT
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setINVOICE_RECIPIENT($iNVOICE_RECIPIENT = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_RECIPIENT) && !is_string($iNVOICE_RECIPIENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICE_RECIPIENT)), __LINE__);
        }
        if (is_null($iNVOICE_RECIPIENT) || (is_array($iNVOICE_RECIPIENT) && empty($iNVOICE_RECIPIENT))) {
            unset($this->INVOICE_RECIPIENT);
        } else {
            $this->INVOICE_RECIPIENT = $iNVOICE_RECIPIENT;
        }
        return $this;
    }
    /**
     * Get INVOICING_SUPPLIER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINVOICING_SUPPLIER()
    {
        return isset($this->INVOICING_SUPPLIER) ? $this->INVOICING_SUPPLIER : null;
    }
    /**
     * Set INVOICING_SUPPLIER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNVOICING_SUPPLIER
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setINVOICING_SUPPLIER($iNVOICING_SUPPLIER = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICING_SUPPLIER) && !is_string($iNVOICING_SUPPLIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNVOICING_SUPPLIER)), __LINE__);
        }
        if (is_null($iNVOICING_SUPPLIER) || (is_array($iNVOICING_SUPPLIER) && empty($iNVOICING_SUPPLIER))) {
            unset($this->INVOICING_SUPPLIER);
        } else {
            $this->INVOICING_SUPPLIER = $iNVOICING_SUPPLIER;
        }
        return $this;
    }
    /**
     * Get MATCHING_LEVEL_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMATCHING_LEVEL_DB()
    {
        return isset($this->MATCHING_LEVEL_DB) ? $this->MATCHING_LEVEL_DB : null;
    }
    /**
     * Set MATCHING_LEVEL_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mATCHING_LEVEL_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setMATCHING_LEVEL_DB($mATCHING_LEVEL_DB = null)
    {
        // validation for constraint: string
        if (!is_null($mATCHING_LEVEL_DB) && !is_string($mATCHING_LEVEL_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mATCHING_LEVEL_DB)), __LINE__);
        }
        if (is_null($mATCHING_LEVEL_DB) || (is_array($mATCHING_LEVEL_DB) && empty($mATCHING_LEVEL_DB))) {
            unset($this->MATCHING_LEVEL_DB);
        } else {
            $this->MATCHING_LEVEL_DB = $mATCHING_LEVEL_DB;
        }
        return $this;
    }
    /**
     * Get ALLOW_TOLERANCE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getALLOW_TOLERANCE()
    {
        return isset($this->ALLOW_TOLERANCE) ? $this->ALLOW_TOLERANCE : null;
    }
    /**
     * Set ALLOW_TOLERANCE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aLLOW_TOLERANCE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setALLOW_TOLERANCE($aLLOW_TOLERANCE = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOW_TOLERANCE) && !is_string($aLLOW_TOLERANCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLLOW_TOLERANCE)), __LINE__);
        }
        if (is_null($aLLOW_TOLERANCE) || (is_array($aLLOW_TOLERANCE) && empty($aLLOW_TOLERANCE))) {
            unset($this->ALLOW_TOLERANCE);
        } else {
            $this->ALLOW_TOLERANCE = $aLLOW_TOLERANCE;
        }
        return $this;
    }
    /**
     * Get CREATE_TOLERANCE_POSTING value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCREATE_TOLERANCE_POSTING()
    {
        return isset($this->CREATE_TOLERANCE_POSTING) ? $this->CREATE_TOLERANCE_POSTING : null;
    }
    /**
     * Set CREATE_TOLERANCE_POSTING value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cREATE_TOLERANCE_POSTING
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCREATE_TOLERANCE_POSTING($cREATE_TOLERANCE_POSTING = null)
    {
        // validation for constraint: string
        if (!is_null($cREATE_TOLERANCE_POSTING) && !is_string($cREATE_TOLERANCE_POSTING)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cREATE_TOLERANCE_POSTING)), __LINE__);
        }
        if (is_null($cREATE_TOLERANCE_POSTING) || (is_array($cREATE_TOLERANCE_POSTING) && empty($cREATE_TOLERANCE_POSTING))) {
            unset($this->CREATE_TOLERANCE_POSTING);
        } else {
            $this->CREATE_TOLERANCE_POSTING = $cREATE_TOLERANCE_POSTING;
        }
        return $this;
    }
    /**
     * Get ALLOW_QUANTITY_DIFF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getALLOW_QUANTITY_DIFF()
    {
        return isset($this->ALLOW_QUANTITY_DIFF) ? $this->ALLOW_QUANTITY_DIFF : null;
    }
    /**
     * Set ALLOW_QUANTITY_DIFF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aLLOW_QUANTITY_DIFF
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setALLOW_QUANTITY_DIFF($aLLOW_QUANTITY_DIFF = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOW_QUANTITY_DIFF) && !is_string($aLLOW_QUANTITY_DIFF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLLOW_QUANTITY_DIFF)), __LINE__);
        }
        if (is_null($aLLOW_QUANTITY_DIFF) || (is_array($aLLOW_QUANTITY_DIFF) && empty($aLLOW_QUANTITY_DIFF))) {
            unset($this->ALLOW_QUANTITY_DIFF);
        } else {
            $this->ALLOW_QUANTITY_DIFF = $aLLOW_QUANTITY_DIFF;
        }
        return $this;
    }
    /**
     * Get DEFAULT_CURRENCY_RATE_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_CURRENCY_RATE_TYPE()
    {
        return isset($this->DEFAULT_CURRENCY_RATE_TYPE) ? $this->DEFAULT_CURRENCY_RATE_TYPE : null;
    }
    /**
     * Set DEFAULT_CURRENCY_RATE_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_CURRENCY_RATE_TYPE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDEFAULT_CURRENCY_RATE_TYPE($dEFAULT_CURRENCY_RATE_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_CURRENCY_RATE_TYPE) && !is_string($dEFAULT_CURRENCY_RATE_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_CURRENCY_RATE_TYPE)), __LINE__);
        }
        if (is_null($dEFAULT_CURRENCY_RATE_TYPE) || (is_array($dEFAULT_CURRENCY_RATE_TYPE) && empty($dEFAULT_CURRENCY_RATE_TYPE))) {
            unset($this->DEFAULT_CURRENCY_RATE_TYPE);
        } else {
            $this->DEFAULT_CURRENCY_RATE_TYPE = $dEFAULT_CURRENCY_RATE_TYPE;
        }
        return $this;
    }
    /**
     * Get TAX_CERTIFICATE_FORM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_CERTIFICATE_FORM()
    {
        return isset($this->TAX_CERTIFICATE_FORM) ? $this->TAX_CERTIFICATE_FORM : null;
    }
    /**
     * Set TAX_CERTIFICATE_FORM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_CERTIFICATE_FORM
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_CERTIFICATE_FORM($tAX_CERTIFICATE_FORM = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_CERTIFICATE_FORM) && !is_string($tAX_CERTIFICATE_FORM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_CERTIFICATE_FORM)), __LINE__);
        }
        if (is_null($tAX_CERTIFICATE_FORM) || (is_array($tAX_CERTIFICATE_FORM) && empty($tAX_CERTIFICATE_FORM))) {
            unset($this->TAX_CERTIFICATE_FORM);
        } else {
            $this->TAX_CERTIFICATE_FORM = $tAX_CERTIFICATE_FORM;
        }
        return $this;
    }
    /**
     * Get TAX_CERTIFICATE_FORM_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_CERTIFICATE_FORM_DB()
    {
        return isset($this->TAX_CERTIFICATE_FORM_DB) ? $this->TAX_CERTIFICATE_FORM_DB : null;
    }
    /**
     * Set TAX_CERTIFICATE_FORM_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_CERTIFICATE_FORM_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setTAX_CERTIFICATE_FORM_DB($tAX_CERTIFICATE_FORM_DB = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_CERTIFICATE_FORM_DB) && !is_string($tAX_CERTIFICATE_FORM_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_CERTIFICATE_FORM_DB)), __LINE__);
        }
        if (is_null($tAX_CERTIFICATE_FORM_DB) || (is_array($tAX_CERTIFICATE_FORM_DB) && empty($tAX_CERTIFICATE_FORM_DB))) {
            unset($this->TAX_CERTIFICATE_FORM_DB);
        } else {
            $this->TAX_CERTIFICATE_FORM_DB = $tAX_CERTIFICATE_FORM_DB;
        }
        return $this;
    }
    /**
     * Get IS_NOTE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIS_NOTE()
    {
        return isset($this->IS_NOTE) ? $this->IS_NOTE : null;
    }
    /**
     * Set IS_NOTE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iS_NOTE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setIS_NOTE($iS_NOTE = null)
    {
        // validation for constraint: string
        if (!is_null($iS_NOTE) && !is_string($iS_NOTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iS_NOTE)), __LINE__);
        }
        if (is_null($iS_NOTE) || (is_array($iS_NOTE) && empty($iS_NOTE))) {
            unset($this->IS_NOTE);
        } else {
            $this->IS_NOTE = $iS_NOTE;
        }
        return $this;
    }
    /**
     * Get DELIV_TYPE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDELIV_TYPE_ID()
    {
        return isset($this->DELIV_TYPE_ID) ? $this->DELIV_TYPE_ID : null;
    }
    /**
     * Set DELIV_TYPE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dELIV_TYPE_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setDELIV_TYPE_ID($dELIV_TYPE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIV_TYPE_ID) && !is_string($dELIV_TYPE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dELIV_TYPE_ID)), __LINE__);
        }
        if (is_null($dELIV_TYPE_ID) || (is_array($dELIV_TYPE_ID) && empty($dELIV_TYPE_ID))) {
            unset($this->DELIV_TYPE_ID);
        } else {
            $this->DELIV_TYPE_ID = $dELIV_TYPE_ID;
        }
        return $this;
    }
    /**
     * Get SUP_VAT_FREE_VAT_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUP_VAT_FREE_VAT_CODE()
    {
        return isset($this->SUP_VAT_FREE_VAT_CODE) ? $this->SUP_VAT_FREE_VAT_CODE : null;
    }
    /**
     * Set SUP_VAT_FREE_VAT_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUP_VAT_FREE_VAT_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setSUP_VAT_FREE_VAT_CODE($sUP_VAT_FREE_VAT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sUP_VAT_FREE_VAT_CODE) && !is_string($sUP_VAT_FREE_VAT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUP_VAT_FREE_VAT_CODE)), __LINE__);
        }
        if (is_null($sUP_VAT_FREE_VAT_CODE) || (is_array($sUP_VAT_FREE_VAT_CODE) && empty($sUP_VAT_FREE_VAT_CODE))) {
            unset($this->SUP_VAT_FREE_VAT_CODE);
        } else {
            $this->SUP_VAT_FREE_VAT_CODE = $sUP_VAT_FREE_VAT_CODE;
        }
        return $this;
    }
    /**
     * Get SUP_COUNTRY_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUP_COUNTRY_CODE()
    {
        return isset($this->SUP_COUNTRY_CODE) ? $this->SUP_COUNTRY_CODE : null;
    }
    /**
     * Set SUP_COUNTRY_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUP_COUNTRY_CODE
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setSUP_COUNTRY_CODE($sUP_COUNTRY_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sUP_COUNTRY_CODE) && !is_string($sUP_COUNTRY_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUP_COUNTRY_CODE)), __LINE__);
        }
        if (is_null($sUP_COUNTRY_CODE) || (is_array($sUP_COUNTRY_CODE) && empty($sUP_COUNTRY_CODE))) {
            unset($this->SUP_COUNTRY_CODE);
        } else {
            $this->SUP_COUNTRY_CODE = $sUP_COUNTRY_CODE;
        }
        return $this;
    }
    /**
     * Get AUTOMATIC_PAY_AUTH_FLAG_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAUTOMATIC_PAY_AUTH_FLAG_DB()
    {
        return isset($this->AUTOMATIC_PAY_AUTH_FLAG_DB) ? $this->AUTOMATIC_PAY_AUTH_FLAG_DB : null;
    }
    /**
     * Set AUTOMATIC_PAY_AUTH_FLAG_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aUTOMATIC_PAY_AUTH_FLAG_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setAUTOMATIC_PAY_AUTH_FLAG_DB($aUTOMATIC_PAY_AUTH_FLAG_DB = null)
    {
        // validation for constraint: string
        if (!is_null($aUTOMATIC_PAY_AUTH_FLAG_DB) && !is_string($aUTOMATIC_PAY_AUTH_FLAG_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUTOMATIC_PAY_AUTH_FLAG_DB)), __LINE__);
        }
        if (is_null($aUTOMATIC_PAY_AUTH_FLAG_DB) || (is_array($aUTOMATIC_PAY_AUTH_FLAG_DB) && empty($aUTOMATIC_PAY_AUTH_FLAG_DB))) {
            unset($this->AUTOMATIC_PAY_AUTH_FLAG_DB);
        } else {
            $this->AUTOMATIC_PAY_AUTH_FLAG_DB = $aUTOMATIC_PAY_AUTH_FLAG_DB;
        }
        return $this;
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get SUPPLIER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLIER_ID()
    {
        return isset($this->SUPPLIER_ID) ? $this->SUPPLIER_ID : null;
    }
    /**
     * Set SUPPLIER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLIER_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setSUPPLIER_ID($sUPPLIER_ID = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLIER_ID) && !is_string($sUPPLIER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLIER_ID)), __LINE__);
        }
        if (is_null($sUPPLIER_ID) || (is_array($sUPPLIER_ID) && empty($sUPPLIER_ID))) {
            unset($this->SUPPLIER_ID);
        } else {
            $this->SUPPLIER_ID = $sUPPLIER_ID;
        }
        return $this;
    }
    /**
     * Get INACTIVE_REASON_DESC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getINACTIVE_REASON_DESC()
    {
        return isset($this->INACTIVE_REASON_DESC) ? $this->INACTIVE_REASON_DESC : null;
    }
    /**
     * Set INACTIVE_REASON_DESC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iNACTIVE_REASON_DESC
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setINACTIVE_REASON_DESC($iNACTIVE_REASON_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($iNACTIVE_REASON_DESC) && !is_string($iNACTIVE_REASON_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNACTIVE_REASON_DESC)), __LINE__);
        }
        if (is_null($iNACTIVE_REASON_DESC) || (is_array($iNACTIVE_REASON_DESC) && empty($iNACTIVE_REASON_DESC))) {
            unset($this->INACTIVE_REASON_DESC);
        } else {
            $this->INACTIVE_REASON_DESC = $iNACTIVE_REASON_DESC;
        }
        return $this;
    }
    /**
     * Get LEGAL_IDENTITY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLEGAL_IDENTITY()
    {
        return isset($this->LEGAL_IDENTITY) ? $this->LEGAL_IDENTITY : null;
    }
    /**
     * Set LEGAL_IDENTITY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lEGAL_IDENTITY
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setLEGAL_IDENTITY($lEGAL_IDENTITY = null)
    {
        // validation for constraint: string
        if (!is_null($lEGAL_IDENTITY) && !is_string($lEGAL_IDENTITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEGAL_IDENTITY)), __LINE__);
        }
        if (is_null($lEGAL_IDENTITY) || (is_array($lEGAL_IDENTITY) && empty($lEGAL_IDENTITY))) {
            unset($this->LEGAL_IDENTITY);
        } else {
            $this->LEGAL_IDENTITY = $lEGAL_IDENTITY;
        }
        return $this;
    }
    /**
     * Get LEGAL_IDENTITY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLEGAL_IDENTITY_DB()
    {
        return isset($this->LEGAL_IDENTITY_DB) ? $this->LEGAL_IDENTITY_DB : null;
    }
    /**
     * Set LEGAL_IDENTITY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lEGAL_IDENTITY_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setLEGAL_IDENTITY_DB($lEGAL_IDENTITY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($lEGAL_IDENTITY_DB) && !is_string($lEGAL_IDENTITY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEGAL_IDENTITY_DB)), __LINE__);
        }
        if (is_null($lEGAL_IDENTITY_DB) || (is_array($lEGAL_IDENTITY_DB) && empty($lEGAL_IDENTITY_DB))) {
            unset($this->LEGAL_IDENTITY_DB);
        } else {
            $this->LEGAL_IDENTITY_DB = $lEGAL_IDENTITY_DB;
        }
        return $this;
    }
    /**
     * Get PO_REF_REC_REF_VAL_METHOD_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPO_REF_REC_REF_VAL_METHOD_DB()
    {
        return isset($this->PO_REF_REC_REF_VAL_METHOD_DB) ? $this->PO_REF_REC_REF_VAL_METHOD_DB : null;
    }
    /**
     * Set PO_REF_REC_REF_VAL_METHOD_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pO_REF_REC_REF_VAL_METHOD_DB
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPO_REF_REC_REF_VAL_METHOD_DB($pO_REF_REC_REF_VAL_METHOD_DB = null)
    {
        // validation for constraint: string
        if (!is_null($pO_REF_REC_REF_VAL_METHOD_DB) && !is_string($pO_REF_REC_REF_VAL_METHOD_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pO_REF_REC_REF_VAL_METHOD_DB)), __LINE__);
        }
        if (is_null($pO_REF_REC_REF_VAL_METHOD_DB) || (is_array($pO_REF_REC_REF_VAL_METHOD_DB) && empty($pO_REF_REC_REF_VAL_METHOD_DB))) {
            unset($this->PO_REF_REC_REF_VAL_METHOD_DB);
        } else {
            $this->PO_REF_REC_REF_VAL_METHOD_DB = $pO_REF_REC_REF_VAL_METHOD_DB;
        }
        return $this;
    }
    /**
     * Get POSTING_TEMPLATE_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPOSTING_TEMPLATE_ID()
    {
        return isset($this->POSTING_TEMPLATE_ID) ? $this->POSTING_TEMPLATE_ID : null;
    }
    /**
     * Set POSTING_TEMPLATE_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pOSTING_TEMPLATE_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPOSTING_TEMPLATE_ID($pOSTING_TEMPLATE_ID = null)
    {
        // validation for constraint: string
        if (!is_null($pOSTING_TEMPLATE_ID) && !is_string($pOSTING_TEMPLATE_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pOSTING_TEMPLATE_ID)), __LINE__);
        }
        if (is_null($pOSTING_TEMPLATE_ID) || (is_array($pOSTING_TEMPLATE_ID) && empty($pOSTING_TEMPLATE_ID))) {
            unset($this->POSTING_TEMPLATE_ID);
        } else {
            $this->POSTING_TEMPLATE_ID = $pOSTING_TEMPLATE_ID;
        }
        return $this;
    }
    /**
     * Get LEGAL_ID_NAME value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLEGAL_ID_NAME()
    {
        return isset($this->LEGAL_ID_NAME) ? $this->LEGAL_ID_NAME : null;
    }
    /**
     * Set LEGAL_ID_NAME value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lEGAL_ID_NAME
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setLEGAL_ID_NAME($lEGAL_ID_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($lEGAL_ID_NAME) && !is_string($lEGAL_ID_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEGAL_ID_NAME)), __LINE__);
        }
        if (is_null($lEGAL_ID_NAME) || (is_array($lEGAL_ID_NAME) && empty($lEGAL_ID_NAME))) {
            unset($this->LEGAL_ID_NAME);
        } else {
            $this->LEGAL_ID_NAME = $lEGAL_ID_NAME;
        }
        return $this;
    }
    /**
     * Get LEGAL_ID_ADDR_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLEGAL_ID_ADDR_ID()
    {
        return isset($this->LEGAL_ID_ADDR_ID) ? $this->LEGAL_ID_ADDR_ID : null;
    }
    /**
     * Set LEGAL_ID_ADDR_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lEGAL_ID_ADDR_ID
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setLEGAL_ID_ADDR_ID($lEGAL_ID_ADDR_ID = null)
    {
        // validation for constraint: string
        if (!is_null($lEGAL_ID_ADDR_ID) && !is_string($lEGAL_ID_ADDR_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEGAL_ID_ADDR_ID)), __LINE__);
        }
        if (is_null($lEGAL_ID_ADDR_ID) || (is_array($lEGAL_ID_ADDR_ID) && empty($lEGAL_ID_ADDR_ID))) {
            unset($this->LEGAL_ID_ADDR_ID);
        } else {
            $this->LEGAL_ID_ADDR_ID = $lEGAL_ID_ADDR_ID;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get PAY_INFO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PAY_INFO|null
     */
    public function getPAY_INFO()
    {
        return isset($this->PAY_INFO) ? $this->PAY_INFO : null;
    }
    /**
     * Set PAY_INFO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PAY_INFO $pAY_INFO
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setPAY_INFO(\StructType\PAY_INFO $pAY_INFO = null)
    {
        if (is_null($pAY_INFO) || (is_array($pAY_INFO) && empty($pAY_INFO))) {
            unset($this->PAY_INFO);
        } else {
            $this->PAY_INFO = $pAY_INFO;
        }
        return $this;
    }
    /**
     * Get CREDIT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CREDIT|null
     */
    public function getCREDIT()
    {
        return isset($this->CREDIT) ? $this->CREDIT : null;
    }
    /**
     * Set CREDIT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CREDIT $cREDIT
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public function setCREDIT(\StructType\CREDIT $cREDIT = null)
    {
        if (is_null($cREDIT) || (is_array($cREDIT) && empty($cREDIT))) {
            unset($this->CREDIT);
        } else {
            $this->CREDIT = $cREDIT;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IDENTITY_INVOICE_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
