<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The errordetail
     * @var string
     */
    public $errordetail;
    /**
     * The stacktrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $stacktrace;
    /**
     * Constructor method for error
     * @uses Error::setErrordetail()
     * @uses Error::setStacktrace()
     * @param string $errordetail
     * @param string $stacktrace
     */
    public function __construct($errordetail = null, $stacktrace = null)
    {
        $this
            ->setErrordetail($errordetail)
            ->setStacktrace($stacktrace);
    }
    /**
     * Get errordetail value
     * @return string|null
     */
    public function getErrordetail()
    {
        return $this->errordetail;
    }
    /**
     * Set errordetail value
     * @param string $errordetail
     * @return \StructType\Error
     */
    public function setErrordetail($errordetail = null)
    {
        // validation for constraint: string
        if (!is_null($errordetail) && !is_string($errordetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errordetail)), __LINE__);
        }
        $this->errordetail = $errordetail;
        return $this;
    }
    /**
     * Get stacktrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStacktrace()
    {
        return isset($this->stacktrace) ? $this->stacktrace : null;
    }
    /**
     * Set stacktrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stacktrace
     * @return \StructType\Error
     */
    public function setStacktrace($stacktrace = null)
    {
        // validation for constraint: string
        if (!is_null($stacktrace) && !is_string($stacktrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stacktrace)), __LINE__);
        }
        if (is_null($stacktrace) || (is_array($stacktrace) && empty($stacktrace))) {
            unset($this->stacktrace);
        } else {
            $this->stacktrace = $stacktrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
