<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_TAX_FREE_TAX_CODE StructType
 * @subpackage Structs
 */
class CUSTOMER_TAX_FREE_TAX_CODE extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The ADDRESS_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_ID;
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The SUPPLY_COUNTRY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLY_COUNTRY;
    /**
     * The DELIVERY_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DELIVERY_TYPE;
    /**
     * The VAT_FREE_VAT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VAT_FREE_VAT_CODE;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * Constructor method for CUSTOMER_TAX_FREE_TAX_CODE
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setCUSTOMER_ID()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setADDRESS_ID()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setCOMPANY()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setSUPPLY_COUNTRY()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setDELIVERY_TYPE()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setVAT_FREE_VAT_CODE()
     * @uses CUSTOMER_TAX_FREE_TAX_CODE::setOPERATION()
     * @param string $cUSTOMER_ID
     * @param string $aDDRESS_ID
     * @param string $cOMPANY
     * @param string $sUPPLY_COUNTRY
     * @param string $dELIVERY_TYPE
     * @param string $vAT_FREE_VAT_CODE
     * @param string $oPERATION
     */
    public function __construct($cUSTOMER_ID = null, $aDDRESS_ID = null, $cOMPANY = null, $sUPPLY_COUNTRY = null, $dELIVERY_TYPE = null, $vAT_FREE_VAT_CODE = null, $oPERATION = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setADDRESS_ID($aDDRESS_ID)
            ->setCOMPANY($cOMPANY)
            ->setSUPPLY_COUNTRY($sUPPLY_COUNTRY)
            ->setDELIVERY_TYPE($dELIVERY_TYPE)
            ->setVAT_FREE_VAT_CODE($vAT_FREE_VAT_CODE)
            ->setOPERATION($oPERATION);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_ID()
    {
        return isset($this->ADDRESS_ID) ? $this->ADDRESS_ID : null;
    }
    /**
     * Set ADDRESS_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_ID
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setADDRESS_ID($aDDRESS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_ID) && !is_string($aDDRESS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_ID)), __LINE__);
        }
        if (is_null($aDDRESS_ID) || (is_array($aDDRESS_ID) && empty($aDDRESS_ID))) {
            unset($this->ADDRESS_ID);
        } else {
            $this->ADDRESS_ID = $aDDRESS_ID;
        }
        return $this;
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get SUPPLY_COUNTRY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLY_COUNTRY()
    {
        return isset($this->SUPPLY_COUNTRY) ? $this->SUPPLY_COUNTRY : null;
    }
    /**
     * Set SUPPLY_COUNTRY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLY_COUNTRY
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setSUPPLY_COUNTRY($sUPPLY_COUNTRY = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLY_COUNTRY) && !is_string($sUPPLY_COUNTRY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLY_COUNTRY)), __LINE__);
        }
        if (is_null($sUPPLY_COUNTRY) || (is_array($sUPPLY_COUNTRY) && empty($sUPPLY_COUNTRY))) {
            unset($this->SUPPLY_COUNTRY);
        } else {
            $this->SUPPLY_COUNTRY = $sUPPLY_COUNTRY;
        }
        return $this;
    }
    /**
     * Get DELIVERY_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDELIVERY_TYPE()
    {
        return isset($this->DELIVERY_TYPE) ? $this->DELIVERY_TYPE : null;
    }
    /**
     * Set DELIVERY_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dELIVERY_TYPE
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setDELIVERY_TYPE($dELIVERY_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_TYPE) && !is_string($dELIVERY_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dELIVERY_TYPE)), __LINE__);
        }
        if (is_null($dELIVERY_TYPE) || (is_array($dELIVERY_TYPE) && empty($dELIVERY_TYPE))) {
            unset($this->DELIVERY_TYPE);
        } else {
            $this->DELIVERY_TYPE = $dELIVERY_TYPE;
        }
        return $this;
    }
    /**
     * Get VAT_FREE_VAT_CODE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVAT_FREE_VAT_CODE()
    {
        return isset($this->VAT_FREE_VAT_CODE) ? $this->VAT_FREE_VAT_CODE : null;
    }
    /**
     * Set VAT_FREE_VAT_CODE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vAT_FREE_VAT_CODE
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setVAT_FREE_VAT_CODE($vAT_FREE_VAT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($vAT_FREE_VAT_CODE) && !is_string($vAT_FREE_VAT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vAT_FREE_VAT_CODE)), __LINE__);
        }
        if (is_null($vAT_FREE_VAT_CODE) || (is_array($vAT_FREE_VAT_CODE) && empty($vAT_FREE_VAT_CODE))) {
            unset($this->VAT_FREE_VAT_CODE);
        } else {
            $this->VAT_FREE_VAT_CODE = $vAT_FREE_VAT_CODE;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_TAX_FREE_TAX_CODE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
