<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_INFO_ADDRESS_TYPE StructType
 * @subpackage Structs
 */
class CUSTOMER_INFO_ADDRESS_TYPE extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The ADDRESS_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_ID;
    /**
     * The ADDRESS_TYPE_CODE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_TYPE_CODE_DB;
    /**
     * The PARTY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PARTY;
    /**
     * The DEF_ADDRESS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEF_ADDRESS;
    /**
     * The DEFAULT_DOMAIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DEFAULT_DOMAIN;
    /**
     * Constructor method for CUSTOMER_INFO_ADDRESS_TYPE
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setCUSTOMER_ID()
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setADDRESS_ID()
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setADDRESS_TYPE_CODE_DB()
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setPARTY()
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setDEF_ADDRESS()
     * @uses CUSTOMER_INFO_ADDRESS_TYPE::setDEFAULT_DOMAIN()
     * @param string $cUSTOMER_ID
     * @param string $aDDRESS_ID
     * @param string $aDDRESS_TYPE_CODE_DB
     * @param string $pARTY
     * @param string $dEF_ADDRESS
     * @param string $dEFAULT_DOMAIN
     */
    public function __construct($cUSTOMER_ID = null, $aDDRESS_ID = null, $aDDRESS_TYPE_CODE_DB = null, $pARTY = null, $dEF_ADDRESS = null, $dEFAULT_DOMAIN = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setADDRESS_ID($aDDRESS_ID)
            ->setADDRESS_TYPE_CODE_DB($aDDRESS_TYPE_CODE_DB)
            ->setPARTY($pARTY)
            ->setDEF_ADDRESS($dEF_ADDRESS)
            ->setDEFAULT_DOMAIN($dEFAULT_DOMAIN);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_ID()
    {
        return isset($this->ADDRESS_ID) ? $this->ADDRESS_ID : null;
    }
    /**
     * Set ADDRESS_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_ID
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setADDRESS_ID($aDDRESS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_ID) && !is_string($aDDRESS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_ID)), __LINE__);
        }
        if (is_null($aDDRESS_ID) || (is_array($aDDRESS_ID) && empty($aDDRESS_ID))) {
            unset($this->ADDRESS_ID);
        } else {
            $this->ADDRESS_ID = $aDDRESS_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_TYPE_CODE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_TYPE_CODE_DB()
    {
        return isset($this->ADDRESS_TYPE_CODE_DB) ? $this->ADDRESS_TYPE_CODE_DB : null;
    }
    /**
     * Set ADDRESS_TYPE_CODE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_TYPE_CODE_DB
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setADDRESS_TYPE_CODE_DB($aDDRESS_TYPE_CODE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_TYPE_CODE_DB) && !is_string($aDDRESS_TYPE_CODE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_TYPE_CODE_DB)), __LINE__);
        }
        if (is_null($aDDRESS_TYPE_CODE_DB) || (is_array($aDDRESS_TYPE_CODE_DB) && empty($aDDRESS_TYPE_CODE_DB))) {
            unset($this->ADDRESS_TYPE_CODE_DB);
        } else {
            $this->ADDRESS_TYPE_CODE_DB = $aDDRESS_TYPE_CODE_DB;
        }
        return $this;
    }
    /**
     * Get PARTY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPARTY()
    {
        return isset($this->PARTY) ? $this->PARTY : null;
    }
    /**
     * Set PARTY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pARTY
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setPARTY($pARTY = null)
    {
        // validation for constraint: string
        if (!is_null($pARTY) && !is_string($pARTY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pARTY)), __LINE__);
        }
        if (is_null($pARTY) || (is_array($pARTY) && empty($pARTY))) {
            unset($this->PARTY);
        } else {
            $this->PARTY = $pARTY;
        }
        return $this;
    }
    /**
     * Get DEF_ADDRESS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEF_ADDRESS()
    {
        return isset($this->DEF_ADDRESS) ? $this->DEF_ADDRESS : null;
    }
    /**
     * Set DEF_ADDRESS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEF_ADDRESS
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setDEF_ADDRESS($dEF_ADDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($dEF_ADDRESS) && !is_string($dEF_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEF_ADDRESS)), __LINE__);
        }
        if (is_null($dEF_ADDRESS) || (is_array($dEF_ADDRESS) && empty($dEF_ADDRESS))) {
            unset($this->DEF_ADDRESS);
        } else {
            $this->DEF_ADDRESS = $dEF_ADDRESS;
        }
        return $this;
    }
    /**
     * Get DEFAULT_DOMAIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDEFAULT_DOMAIN()
    {
        return isset($this->DEFAULT_DOMAIN) ? $this->DEFAULT_DOMAIN : null;
    }
    /**
     * Set DEFAULT_DOMAIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dEFAULT_DOMAIN
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public function setDEFAULT_DOMAIN($dEFAULT_DOMAIN = null)
    {
        // validation for constraint: string
        if (!is_null($dEFAULT_DOMAIN) && !is_string($dEFAULT_DOMAIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dEFAULT_DOMAIN)), __LINE__);
        }
        if (is_null($dEFAULT_DOMAIN) || (is_array($dEFAULT_DOMAIN) && empty($dEFAULT_DOMAIN))) {
            unset($this->DEFAULT_DOMAIN);
        } else {
            $this->DEFAULT_DOMAIN = $dEFAULT_DOMAIN;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_INFO_ADDRESS_TYPE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
