<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CUSTOMER_DOCUMENT_TAX_INFO StructType
 * @subpackage Structs
 */
class CUSTOMER_DOCUMENT_TAX_INFO extends AbstractStructBase
{
    /**
     * The CUSTOMER_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $CUSTOMER_ID;
    /**
     * The ADDRESS_ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ADDRESS_ID;
    /**
     * The COMPANY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 20
     * @var string
     */
    public $COMPANY;
    /**
     * The SUPPLY_COUNTRY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUPPLY_COUNTRY_DB;
    /**
     * The DELIVERY_COUNTRY_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DELIVERY_COUNTRY_DB;
    /**
     * The TAX_ID_TYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TAX_ID_TYPE;
    /**
     * The VAT_NO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VAT_NO;
    /**
     * The VALIDATED_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VALIDATED_DATE;
    /**
     * The OPERATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 10
     * @var string
     */
    public $OPERATION;
    /**
     * The C_VALIDATED_DATE_TAXPAYER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $C_VALIDATED_DATE_TAXPAYER;
    /**
     * The C_TAXPAYER_STATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $C_TAXPAYER_STATE;
    /**
     * The C_TAXPAYER_STATE_DB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $C_TAXPAYER_STATE_DB;
    /**
     * Constructor method for CUSTOMER_DOCUMENT_TAX_INFO
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setCUSTOMER_ID()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setADDRESS_ID()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setCOMPANY()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setSUPPLY_COUNTRY_DB()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setDELIVERY_COUNTRY_DB()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setTAX_ID_TYPE()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setVAT_NO()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setVALIDATED_DATE()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setOPERATION()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setC_VALIDATED_DATE_TAXPAYER()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setC_TAXPAYER_STATE()
     * @uses CUSTOMER_DOCUMENT_TAX_INFO::setC_TAXPAYER_STATE_DB()
     * @param string $cUSTOMER_ID
     * @param string $aDDRESS_ID
     * @param string $cOMPANY
     * @param string $sUPPLY_COUNTRY_DB
     * @param string $dELIVERY_COUNTRY_DB
     * @param string $tAX_ID_TYPE
     * @param string $vAT_NO
     * @param string $vALIDATED_DATE
     * @param string $oPERATION
     * @param string $c_VALIDATED_DATE_TAXPAYER
     * @param string $c_TAXPAYER_STATE
     * @param string $c_TAXPAYER_STATE_DB
     */
    public function __construct($cUSTOMER_ID = null, $aDDRESS_ID = null, $cOMPANY = null, $sUPPLY_COUNTRY_DB = null, $dELIVERY_COUNTRY_DB = null, $tAX_ID_TYPE = null, $vAT_NO = null, $vALIDATED_DATE = null, $oPERATION = null, $c_VALIDATED_DATE_TAXPAYER = null, $c_TAXPAYER_STATE = null, $c_TAXPAYER_STATE_DB = null)
    {
        $this
            ->setCUSTOMER_ID($cUSTOMER_ID)
            ->setADDRESS_ID($aDDRESS_ID)
            ->setCOMPANY($cOMPANY)
            ->setSUPPLY_COUNTRY_DB($sUPPLY_COUNTRY_DB)
            ->setDELIVERY_COUNTRY_DB($dELIVERY_COUNTRY_DB)
            ->setTAX_ID_TYPE($tAX_ID_TYPE)
            ->setVAT_NO($vAT_NO)
            ->setVALIDATED_DATE($vALIDATED_DATE)
            ->setOPERATION($oPERATION)
            ->setC_VALIDATED_DATE_TAXPAYER($c_VALIDATED_DATE_TAXPAYER)
            ->setC_TAXPAYER_STATE($c_TAXPAYER_STATE)
            ->setC_TAXPAYER_STATE_DB($c_TAXPAYER_STATE_DB);
    }
    /**
     * Get CUSTOMER_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCUSTOMER_ID()
    {
        return isset($this->CUSTOMER_ID) ? $this->CUSTOMER_ID : null;
    }
    /**
     * Set CUSTOMER_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cUSTOMER_ID
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setCUSTOMER_ID($cUSTOMER_ID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cUSTOMER_ID) && strlen($cUSTOMER_ID) > 20) || (is_array($cUSTOMER_ID) && count($cUSTOMER_ID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cUSTOMER_ID) ? strlen($cUSTOMER_ID) : count($cUSTOMER_ID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cUSTOMER_ID) && !is_string($cUSTOMER_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cUSTOMER_ID)), __LINE__);
        }
        if (is_null($cUSTOMER_ID) || (is_array($cUSTOMER_ID) && empty($cUSTOMER_ID))) {
            unset($this->CUSTOMER_ID);
        } else {
            $this->CUSTOMER_ID = $cUSTOMER_ID;
        }
        return $this;
    }
    /**
     * Get ADDRESS_ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getADDRESS_ID()
    {
        return isset($this->ADDRESS_ID) ? $this->ADDRESS_ID : null;
    }
    /**
     * Set ADDRESS_ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aDDRESS_ID
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setADDRESS_ID($aDDRESS_ID = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS_ID) && !is_string($aDDRESS_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aDDRESS_ID)), __LINE__);
        }
        if (is_null($aDDRESS_ID) || (is_array($aDDRESS_ID) && empty($aDDRESS_ID))) {
            unset($this->ADDRESS_ID);
        } else {
            $this->ADDRESS_ID = $aDDRESS_ID;
        }
        return $this;
    }
    /**
     * Get COMPANY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCOMPANY()
    {
        return isset($this->COMPANY) ? $this->COMPANY : null;
    }
    /**
     * Set COMPANY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cOMPANY
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setCOMPANY($cOMPANY = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cOMPANY) && strlen($cOMPANY) > 20) || (is_array($cOMPANY) && count($cOMPANY) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($cOMPANY) ? strlen($cOMPANY) : count($cOMPANY)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cOMPANY) && !is_string($cOMPANY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cOMPANY)), __LINE__);
        }
        if (is_null($cOMPANY) || (is_array($cOMPANY) && empty($cOMPANY))) {
            unset($this->COMPANY);
        } else {
            $this->COMPANY = $cOMPANY;
        }
        return $this;
    }
    /**
     * Get SUPPLY_COUNTRY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUPPLY_COUNTRY_DB()
    {
        return isset($this->SUPPLY_COUNTRY_DB) ? $this->SUPPLY_COUNTRY_DB : null;
    }
    /**
     * Set SUPPLY_COUNTRY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUPPLY_COUNTRY_DB
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setSUPPLY_COUNTRY_DB($sUPPLY_COUNTRY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($sUPPLY_COUNTRY_DB) && !is_string($sUPPLY_COUNTRY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sUPPLY_COUNTRY_DB)), __LINE__);
        }
        if (is_null($sUPPLY_COUNTRY_DB) || (is_array($sUPPLY_COUNTRY_DB) && empty($sUPPLY_COUNTRY_DB))) {
            unset($this->SUPPLY_COUNTRY_DB);
        } else {
            $this->SUPPLY_COUNTRY_DB = $sUPPLY_COUNTRY_DB;
        }
        return $this;
    }
    /**
     * Get DELIVERY_COUNTRY_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDELIVERY_COUNTRY_DB()
    {
        return isset($this->DELIVERY_COUNTRY_DB) ? $this->DELIVERY_COUNTRY_DB : null;
    }
    /**
     * Set DELIVERY_COUNTRY_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dELIVERY_COUNTRY_DB
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setDELIVERY_COUNTRY_DB($dELIVERY_COUNTRY_DB = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_COUNTRY_DB) && !is_string($dELIVERY_COUNTRY_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dELIVERY_COUNTRY_DB)), __LINE__);
        }
        if (is_null($dELIVERY_COUNTRY_DB) || (is_array($dELIVERY_COUNTRY_DB) && empty($dELIVERY_COUNTRY_DB))) {
            unset($this->DELIVERY_COUNTRY_DB);
        } else {
            $this->DELIVERY_COUNTRY_DB = $dELIVERY_COUNTRY_DB;
        }
        return $this;
    }
    /**
     * Get TAX_ID_TYPE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTAX_ID_TYPE()
    {
        return isset($this->TAX_ID_TYPE) ? $this->TAX_ID_TYPE : null;
    }
    /**
     * Set TAX_ID_TYPE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tAX_ID_TYPE
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setTAX_ID_TYPE($tAX_ID_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($tAX_ID_TYPE) && !is_string($tAX_ID_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tAX_ID_TYPE)), __LINE__);
        }
        if (is_null($tAX_ID_TYPE) || (is_array($tAX_ID_TYPE) && empty($tAX_ID_TYPE))) {
            unset($this->TAX_ID_TYPE);
        } else {
            $this->TAX_ID_TYPE = $tAX_ID_TYPE;
        }
        return $this;
    }
    /**
     * Get VAT_NO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVAT_NO()
    {
        return isset($this->VAT_NO) ? $this->VAT_NO : null;
    }
    /**
     * Set VAT_NO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vAT_NO
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setVAT_NO($vAT_NO = null)
    {
        // validation for constraint: string
        if (!is_null($vAT_NO) && !is_string($vAT_NO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vAT_NO)), __LINE__);
        }
        if (is_null($vAT_NO) || (is_array($vAT_NO) && empty($vAT_NO))) {
            unset($this->VAT_NO);
        } else {
            $this->VAT_NO = $vAT_NO;
        }
        return $this;
    }
    /**
     * Get VALIDATED_DATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVALIDATED_DATE()
    {
        return isset($this->VALIDATED_DATE) ? $this->VALIDATED_DATE : null;
    }
    /**
     * Set VALIDATED_DATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vALIDATED_DATE
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setVALIDATED_DATE($vALIDATED_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($vALIDATED_DATE) && !is_string($vALIDATED_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vALIDATED_DATE)), __LINE__);
        }
        if (is_null($vALIDATED_DATE) || (is_array($vALIDATED_DATE) && empty($vALIDATED_DATE))) {
            unset($this->VALIDATED_DATE);
        } else {
            $this->VALIDATED_DATE = $vALIDATED_DATE;
        }
        return $this;
    }
    /**
     * Get OPERATION value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPERATION()
    {
        return isset($this->OPERATION) ? $this->OPERATION : null;
    }
    /**
     * Set OPERATION value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPERATION
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setOPERATION($oPERATION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oPERATION) && strlen($oPERATION) > 10) || (is_array($oPERATION) && count($oPERATION) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($oPERATION) ? strlen($oPERATION) : count($oPERATION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oPERATION) && !is_string($oPERATION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oPERATION)), __LINE__);
        }
        if (is_null($oPERATION) || (is_array($oPERATION) && empty($oPERATION))) {
            unset($this->OPERATION);
        } else {
            $this->OPERATION = $oPERATION;
        }
        return $this;
    }
    /**
     * Get C_VALIDATED_DATE_TAXPAYER value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getC_VALIDATED_DATE_TAXPAYER()
    {
        return isset($this->C_VALIDATED_DATE_TAXPAYER) ? $this->C_VALIDATED_DATE_TAXPAYER : null;
    }
    /**
     * Set C_VALIDATED_DATE_TAXPAYER value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $c_VALIDATED_DATE_TAXPAYER
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setC_VALIDATED_DATE_TAXPAYER($c_VALIDATED_DATE_TAXPAYER = null)
    {
        // validation for constraint: string
        if (!is_null($c_VALIDATED_DATE_TAXPAYER) && !is_string($c_VALIDATED_DATE_TAXPAYER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c_VALIDATED_DATE_TAXPAYER)), __LINE__);
        }
        if (is_null($c_VALIDATED_DATE_TAXPAYER) || (is_array($c_VALIDATED_DATE_TAXPAYER) && empty($c_VALIDATED_DATE_TAXPAYER))) {
            unset($this->C_VALIDATED_DATE_TAXPAYER);
        } else {
            $this->C_VALIDATED_DATE_TAXPAYER = $c_VALIDATED_DATE_TAXPAYER;
        }
        return $this;
    }
    /**
     * Get C_TAXPAYER_STATE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getC_TAXPAYER_STATE()
    {
        return isset($this->C_TAXPAYER_STATE) ? $this->C_TAXPAYER_STATE : null;
    }
    /**
     * Set C_TAXPAYER_STATE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $c_TAXPAYER_STATE
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setC_TAXPAYER_STATE($c_TAXPAYER_STATE = null)
    {
        // validation for constraint: string
        if (!is_null($c_TAXPAYER_STATE) && !is_string($c_TAXPAYER_STATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c_TAXPAYER_STATE)), __LINE__);
        }
        if (is_null($c_TAXPAYER_STATE) || (is_array($c_TAXPAYER_STATE) && empty($c_TAXPAYER_STATE))) {
            unset($this->C_TAXPAYER_STATE);
        } else {
            $this->C_TAXPAYER_STATE = $c_TAXPAYER_STATE;
        }
        return $this;
    }
    /**
     * Get C_TAXPAYER_STATE_DB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getC_TAXPAYER_STATE_DB()
    {
        return isset($this->C_TAXPAYER_STATE_DB) ? $this->C_TAXPAYER_STATE_DB : null;
    }
    /**
     * Set C_TAXPAYER_STATE_DB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $c_TAXPAYER_STATE_DB
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public function setC_TAXPAYER_STATE_DB($c_TAXPAYER_STATE_DB = null)
    {
        // validation for constraint: string
        if (!is_null($c_TAXPAYER_STATE_DB) && !is_string($c_TAXPAYER_STATE_DB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c_TAXPAYER_STATE_DB)), __LINE__);
        }
        if (is_null($c_TAXPAYER_STATE_DB) || (is_array($c_TAXPAYER_STATE_DB) && empty($c_TAXPAYER_STATE_DB))) {
            unset($this->C_TAXPAYER_STATE_DB);
        } else {
            $this->C_TAXPAYER_STATE_DB = $c_TAXPAYER_STATE_DB;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CUSTOMER_DOCUMENT_TAX_INFO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
