<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zleceniePodjeciaV2 StructType
 * @subpackage Structs
 */
class ZleceniePodjeciaV2 extends AbstractStructBase
{
    /**
     * The paymentForm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentForm;
    /**
     * The shipmentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentType;
    /**
     * The payerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerType;
    /**
     * The pickupDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupHour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupHour;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NadawcaZlecenieV2
     */
    public $sender;
    /**
     * The payer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PlatnikV2
     */
    public $payer;
    /**
     * The additionalServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UslugiDodatkowe
     */
    public $additionalServices;
    /**
     * The shipmentWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentWeight;
    /**
     * The shipmentAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentAmount;
    /**
     * The remarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $remarks;
    /**
     * The palletWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $palletWeight;
    /**
     * The palletAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $palletAmount;
    /**
     * Constructor method for zleceniePodjeciaV2
     * @uses ZleceniePodjeciaV2::setPaymentForm()
     * @uses ZleceniePodjeciaV2::setShipmentType()
     * @uses ZleceniePodjeciaV2::setPayerType()
     * @uses ZleceniePodjeciaV2::setPickupDate()
     * @uses ZleceniePodjeciaV2::setPickupHour()
     * @uses ZleceniePodjeciaV2::setSender()
     * @uses ZleceniePodjeciaV2::setPayer()
     * @uses ZleceniePodjeciaV2::setAdditionalServices()
     * @uses ZleceniePodjeciaV2::setShipmentWeight()
     * @uses ZleceniePodjeciaV2::setShipmentAmount()
     * @uses ZleceniePodjeciaV2::setRemarks()
     * @uses ZleceniePodjeciaV2::setPalletWeight()
     * @uses ZleceniePodjeciaV2::setPalletAmount()
     * @param string $paymentForm
     * @param string $shipmentType
     * @param string $payerType
     * @param string $pickupDate
     * @param string $pickupHour
     * @param \StructType\NadawcaZlecenieV2 $sender
     * @param \StructType\PlatnikV2 $payer
     * @param \StructType\UslugiDodatkowe $additionalServices
     * @param string $shipmentWeight
     * @param string $shipmentAmount
     * @param string $remarks
     * @param string $palletWeight
     * @param string $palletAmount
     */
    public function __construct($paymentForm = null, $shipmentType = null, $payerType = null, $pickupDate = null, $pickupHour = null, \StructType\NadawcaZlecenieV2 $sender = null, \StructType\PlatnikV2 $payer = null, \StructType\UslugiDodatkowe $additionalServices = null, $shipmentWeight = null, $shipmentAmount = null, $remarks = null, $palletWeight = null, $palletAmount = null)
    {
        $this
            ->setPaymentForm($paymentForm)
            ->setShipmentType($shipmentType)
            ->setPayerType($payerType)
            ->setPickupDate($pickupDate)
            ->setPickupHour($pickupHour)
            ->setSender($sender)
            ->setPayer($payer)
            ->setAdditionalServices($additionalServices)
            ->setShipmentWeight($shipmentWeight)
            ->setShipmentAmount($shipmentAmount)
            ->setRemarks($remarks)
            ->setPalletWeight($palletWeight)
            ->setPalletAmount($palletAmount);
    }
    /**
     * Get paymentForm value
     * @return string|null
     */
    public function getPaymentForm()
    {
        return $this->paymentForm;
    }
    /**
     * Set paymentForm value
     * @param string $paymentForm
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPaymentForm($paymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($paymentForm) && !is_string($paymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentForm)), __LINE__);
        }
        $this->paymentForm = $paymentForm;
        return $this;
    }
    /**
     * Get shipmentType value
     * @return string|null
     */
    public function getShipmentType()
    {
        return $this->shipmentType;
    }
    /**
     * Set shipmentType value
     * @param string $shipmentType
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setShipmentType($shipmentType = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentType) && !is_string($shipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentType)), __LINE__);
        }
        $this->shipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get payerType value
     * @return string|null
     */
    public function getPayerType()
    {
        return $this->payerType;
    }
    /**
     * Set payerType value
     * @param string $payerType
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPayerType($payerType = null)
    {
        // validation for constraint: string
        if (!is_null($payerType) && !is_string($payerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payerType)), __LINE__);
        }
        $this->payerType = $payerType;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupHour value
     * @return string|null
     */
    public function getPickupHour()
    {
        return $this->pickupHour;
    }
    /**
     * Set pickupHour value
     * @param string $pickupHour
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPickupHour($pickupHour = null)
    {
        // validation for constraint: string
        if (!is_null($pickupHour) && !is_string($pickupHour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickupHour)), __LINE__);
        }
        $this->pickupHour = $pickupHour;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\NadawcaZlecenieV2|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\NadawcaZlecenieV2 $sender
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setSender(\StructType\NadawcaZlecenieV2 $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get payer value
     * @return \StructType\PlatnikV2|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @param \StructType\PlatnikV2 $payer
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPayer(\StructType\PlatnikV2 $payer = null)
    {
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get additionalServices value
     * @return \StructType\UslugiDodatkowe|null
     */
    public function getAdditionalServices()
    {
        return $this->additionalServices;
    }
    /**
     * Set additionalServices value
     * @param \StructType\UslugiDodatkowe $additionalServices
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setAdditionalServices(\StructType\UslugiDodatkowe $additionalServices = null)
    {
        $this->additionalServices = $additionalServices;
        return $this;
    }
    /**
     * Get shipmentWeight value
     * @return string|null
     */
    public function getShipmentWeight()
    {
        return $this->shipmentWeight;
    }
    /**
     * Set shipmentWeight value
     * @param string $shipmentWeight
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setShipmentWeight($shipmentWeight = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentWeight) && !is_string($shipmentWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentWeight)), __LINE__);
        }
        $this->shipmentWeight = $shipmentWeight;
        return $this;
    }
    /**
     * Get shipmentAmount value
     * @return string|null
     */
    public function getShipmentAmount()
    {
        return $this->shipmentAmount;
    }
    /**
     * Set shipmentAmount value
     * @param string $shipmentAmount
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setShipmentAmount($shipmentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentAmount) && !is_string($shipmentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentAmount)), __LINE__);
        }
        $this->shipmentAmount = $shipmentAmount;
        return $this;
    }
    /**
     * Get remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->remarks;
    }
    /**
     * Set remarks value
     * @param string $remarks
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->remarks = $remarks;
        return $this;
    }
    /**
     * Get palletWeight value
     * @return string|null
     */
    public function getPalletWeight()
    {
        return $this->palletWeight;
    }
    /**
     * Set palletWeight value
     * @param string $palletWeight
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPalletWeight($palletWeight = null)
    {
        // validation for constraint: string
        if (!is_null($palletWeight) && !is_string($palletWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($palletWeight)), __LINE__);
        }
        $this->palletWeight = $palletWeight;
        return $this;
    }
    /**
     * Get palletAmount value
     * @return string|null
     */
    public function getPalletAmount()
    {
        return $this->palletAmount;
    }
    /**
     * Set palletAmount value
     * @param string $palletAmount
     * @return \StructType\ZleceniePodjeciaV2
     */
    public function setPalletAmount($palletAmount = null)
    {
        // validation for constraint: string
        if (!is_null($palletAmount) && !is_string($palletAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($palletAmount)), __LINE__);
        }
        $this->palletAmount = $palletAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZleceniePodjeciaV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
