<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uslugaDodatkowa StructType
 * @subpackage Structs
 */
class UslugaDodatkowa extends AbstractStructBase
{
    /**
     * The serviceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceId;
    /**
     * The serviceArguments
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArgumentyUslugi[]
     */
    public $serviceArguments;
    /**
     * Constructor method for uslugaDodatkowa
     * @uses UslugaDodatkowa::setServiceId()
     * @uses UslugaDodatkowa::setServiceArguments()
     * @param string $serviceId
     * @param \StructType\ArgumentyUslugi[] $serviceArguments
     */
    public function __construct($serviceId = null, array $serviceArguments = array())
    {
        $this
            ->setServiceId($serviceId)
            ->setServiceArguments($serviceArguments);
    }
    /**
     * Get serviceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param string $serviceId
     * @return \StructType\UslugaDodatkowa
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get serviceArguments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArgumentyUslugi[]|null
     */
    public function getServiceArguments()
    {
        return isset($this->serviceArguments) ? $this->serviceArguments : null;
    }
    /**
     * Set serviceArguments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArgumentyUslugi[] $serviceArguments
     * @return \StructType\UslugaDodatkowa
     */
    public function setServiceArguments(array $serviceArguments = array())
    {
        foreach ($serviceArguments as $uslugaDodatkowaServiceArgumentsItem) {
            // validation for constraint: itemType
            if (!$uslugaDodatkowaServiceArgumentsItem instanceof \StructType\ArgumentyUslugi) {
                throw new \InvalidArgumentException(sprintf('The serviceArguments property can only contain items of \StructType\ArgumentyUslugi, "%s" given', is_object($uslugaDodatkowaServiceArgumentsItem) ? get_class($uslugaDodatkowaServiceArgumentsItem) : gettype($uslugaDodatkowaServiceArgumentsItem)), __LINE__);
            }
        }
        if (is_null($serviceArguments) || (is_array($serviceArguments) && empty($serviceArguments))) {
            unset($this->serviceArguments);
        } else {
            $this->serviceArguments = $serviceArguments;
        }
        return $this;
    }
    /**
     * Add item to serviceArguments value
     * @throws \InvalidArgumentException
     * @param \StructType\ArgumentyUslugi $item
     * @return \StructType\UslugaDodatkowa
     */
    public function addToServiceArguments(\StructType\ArgumentyUslugi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArgumentyUslugi) {
            throw new \InvalidArgumentException(sprintf('The serviceArguments property can only contain items of \StructType\ArgumentyUslugi, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceArguments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UslugaDodatkowa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
