<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ubezpieczenie StructType
 * @subpackage Structs
 */
class Ubezpieczenie extends AbstractStructBase
{
    /**
     * The kwotaUbezpieczenia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kwotaUbezpieczenia;
    /**
     * The opisZawartosci
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opisZawartosci;
    /**
     * Constructor method for ubezpieczenie
     * @uses Ubezpieczenie::setKwotaUbezpieczenia()
     * @uses Ubezpieczenie::setOpisZawartosci()
     * @param string $kwotaUbezpieczenia
     * @param string $opisZawartosci
     */
    public function __construct($kwotaUbezpieczenia = null, $opisZawartosci = null)
    {
        $this
            ->setKwotaUbezpieczenia($kwotaUbezpieczenia)
            ->setOpisZawartosci($opisZawartosci);
    }
    /**
     * Get kwotaUbezpieczenia value
     * @return string|null
     */
    public function getKwotaUbezpieczenia()
    {
        return $this->kwotaUbezpieczenia;
    }
    /**
     * Set kwotaUbezpieczenia value
     * @param string $kwotaUbezpieczenia
     * @return \StructType\Ubezpieczenie
     */
    public function setKwotaUbezpieczenia($kwotaUbezpieczenia = null)
    {
        // validation for constraint: string
        if (!is_null($kwotaUbezpieczenia) && !is_string($kwotaUbezpieczenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kwotaUbezpieczenia)), __LINE__);
        }
        $this->kwotaUbezpieczenia = $kwotaUbezpieczenia;
        return $this;
    }
    /**
     * Get opisZawartosci value
     * @return string|null
     */
    public function getOpisZawartosci()
    {
        return $this->opisZawartosci;
    }
    /**
     * Set opisZawartosci value
     * @param string $opisZawartosci
     * @return \StructType\Ubezpieczenie
     */
    public function setOpisZawartosci($opisZawartosci = null)
    {
        // validation for constraint: string
        if (!is_null($opisZawartosci) && !is_string($opisZawartosci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opisZawartosci)), __LINE__);
        }
        $this->opisZawartosci = $opisZawartosci;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ubezpieczenie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
