<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pobranie StructType
 * @subpackage Structs
 */
class Pobranie extends AbstractStructBase
{
    /**
     * The formaPobrania
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $formaPobrania;
    /**
     * The kwotaPobrania
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kwotaPobrania;
    /**
     * The nrKonta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nrKonta;
    /**
     * Constructor method for pobranie
     * @uses Pobranie::setFormaPobrania()
     * @uses Pobranie::setKwotaPobrania()
     * @uses Pobranie::setNrKonta()
     * @param string $formaPobrania
     * @param string $kwotaPobrania
     * @param string $nrKonta
     */
    public function __construct($formaPobrania = null, $kwotaPobrania = null, $nrKonta = null)
    {
        $this
            ->setFormaPobrania($formaPobrania)
            ->setKwotaPobrania($kwotaPobrania)
            ->setNrKonta($nrKonta);
    }
    /**
     * Get formaPobrania value
     * @return string|null
     */
    public function getFormaPobrania()
    {
        return $this->formaPobrania;
    }
    /**
     * Set formaPobrania value
     * @param string $formaPobrania
     * @return \StructType\Pobranie
     */
    public function setFormaPobrania($formaPobrania = null)
    {
        // validation for constraint: string
        if (!is_null($formaPobrania) && !is_string($formaPobrania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formaPobrania)), __LINE__);
        }
        $this->formaPobrania = $formaPobrania;
        return $this;
    }
    /**
     * Get kwotaPobrania value
     * @return string|null
     */
    public function getKwotaPobrania()
    {
        return $this->kwotaPobrania;
    }
    /**
     * Set kwotaPobrania value
     * @param string $kwotaPobrania
     * @return \StructType\Pobranie
     */
    public function setKwotaPobrania($kwotaPobrania = null)
    {
        // validation for constraint: string
        if (!is_null($kwotaPobrania) && !is_string($kwotaPobrania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kwotaPobrania)), __LINE__);
        }
        $this->kwotaPobrania = $kwotaPobrania;
        return $this;
    }
    /**
     * Get nrKonta value
     * @return string|null
     */
    public function getNrKonta()
    {
        return $this->nrKonta;
    }
    /**
     * Set nrKonta value
     * @param string $nrKonta
     * @return \StructType\Pobranie
     */
    public function setNrKonta($nrKonta = null)
    {
        // validation for constraint: string
        if (!is_null($nrKonta) && !is_string($nrKonta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nrKonta)), __LINE__);
        }
        $this->nrKonta = $nrKonta;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pobranie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
