<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkiV2 StructType
 * @subpackage Structs
 */
class PaczkiV2 extends AbstractStructBase
{
    /**
     * The parcel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaczkaV2[]
     */
    public $parcel;
    /**
     * Constructor method for paczkiV2
     * @uses PaczkiV2::setParcel()
     * @param \StructType\PaczkaV2[] $parcel
     */
    public function __construct(array $parcel = array())
    {
        $this
            ->setParcel($parcel);
    }
    /**
     * Get parcel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaczkaV2[]|null
     */
    public function getParcel()
    {
        return isset($this->parcel) ? $this->parcel : null;
    }
    /**
     * Set parcel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaczkaV2[] $parcel
     * @return \StructType\PaczkiV2
     */
    public function setParcel(array $parcel = array())
    {
        foreach ($parcel as $paczkiV2ParcelItem) {
            // validation for constraint: itemType
            if (!$paczkiV2ParcelItem instanceof \StructType\PaczkaV2) {
                throw new \InvalidArgumentException(sprintf('The parcel property can only contain items of \StructType\PaczkaV2, "%s" given', is_object($paczkiV2ParcelItem) ? get_class($paczkiV2ParcelItem) : gettype($paczkiV2ParcelItem)), __LINE__);
            }
        }
        if (is_null($parcel) || (is_array($parcel) && empty($parcel))) {
            unset($this->parcel);
        } else {
            $this->parcel = $parcel;
        }
        return $this;
    }
    /**
     * Add item to parcel value
     * @throws \InvalidArgumentException
     * @param \StructType\PaczkaV2 $item
     * @return \StructType\PaczkiV2
     */
    public function addToParcel(\StructType\PaczkaV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaczkaV2) {
            throw new \InvalidArgumentException(sprintf('The parcel property can only contain items of \StructType\PaczkaV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parcel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaczkiV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
