<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkiStatusyV2 StructType
 * @subpackage Structs
 */
class PaczkiStatusyV2 extends AbstractStructBase
{
    /**
     * The parcelStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaczkaStatusV2[]
     */
    public $parcelStatus;
    /**
     * Constructor method for paczkiStatusyV2
     * @uses PaczkiStatusyV2::setParcelStatus()
     * @param \StructType\PaczkaStatusV2[] $parcelStatus
     */
    public function __construct(array $parcelStatus = array())
    {
        $this
            ->setParcelStatus($parcelStatus);
    }
    /**
     * Get parcelStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaczkaStatusV2[]|null
     */
    public function getParcelStatus()
    {
        return isset($this->parcelStatus) ? $this->parcelStatus : null;
    }
    /**
     * Set parcelStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaczkaStatusV2[] $parcelStatus
     * @return \StructType\PaczkiStatusyV2
     */
    public function setParcelStatus(array $parcelStatus = array())
    {
        foreach ($parcelStatus as $paczkiStatusyV2ParcelStatusItem) {
            // validation for constraint: itemType
            if (!$paczkiStatusyV2ParcelStatusItem instanceof \StructType\PaczkaStatusV2) {
                throw new \InvalidArgumentException(sprintf('The parcelStatus property can only contain items of \StructType\PaczkaStatusV2, "%s" given', is_object($paczkiStatusyV2ParcelStatusItem) ? get_class($paczkiStatusyV2ParcelStatusItem) : gettype($paczkiStatusyV2ParcelStatusItem)), __LINE__);
            }
        }
        if (is_null($parcelStatus) || (is_array($parcelStatus) && empty($parcelStatus))) {
            unset($this->parcelStatus);
        } else {
            $this->parcelStatus = $parcelStatus;
        }
        return $this;
    }
    /**
     * Add item to parcelStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\PaczkaStatusV2 $item
     * @return \StructType\PaczkiStatusyV2
     */
    public function addToParcelStatus(\StructType\PaczkaStatusV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaczkaStatusV2) {
            throw new \InvalidArgumentException(sprintf('The parcelStatus property can only contain items of \StructType\PaczkaStatusV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parcelStatus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaczkiStatusyV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
