<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkaV2 StructType
 * @subpackage Structs
 */
class PaczkaV2 extends AbstractStructBase
{
    /**
     * The waybill
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The dim1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dim1;
    /**
     * The dim2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dim2;
    /**
     * The dim3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dim3;
    /**
     * The shape
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shape;
    /**
     * The dimWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dimWeight;
    /**
     * The nrExtPp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nrExtPp;
    /**
     * Constructor method for paczkaV2
     * @uses PaczkaV2::setWaybill()
     * @uses PaczkaV2::setType()
     * @uses PaczkaV2::setWeight()
     * @uses PaczkaV2::setDim1()
     * @uses PaczkaV2::setDim2()
     * @uses PaczkaV2::setDim3()
     * @uses PaczkaV2::setShape()
     * @uses PaczkaV2::setDimWeight()
     * @uses PaczkaV2::setNrExtPp()
     * @param string $waybill
     * @param string $type
     * @param string $weight
     * @param string $dim1
     * @param string $dim2
     * @param string $dim3
     * @param string $shape
     * @param string $dimWeight
     * @param string $nrExtPp
     */
    public function __construct($waybill = null, $type = null, $weight = null, $dim1 = null, $dim2 = null, $dim3 = null, $shape = null, $dimWeight = null, $nrExtPp = null)
    {
        $this
            ->setWaybill($waybill)
            ->setType($type)
            ->setWeight($weight)
            ->setDim1($dim1)
            ->setDim2($dim2)
            ->setDim3($dim3)
            ->setShape($shape)
            ->setDimWeight($dimWeight)
            ->setNrExtPp($nrExtPp);
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \StructType\PaczkaV2
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waybill)), __LINE__);
        }
        $this->waybill = $waybill;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\PaczkaV2
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \StructType\PaczkaV2
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get dim1 value
     * @return string|null
     */
    public function getDim1()
    {
        return $this->dim1;
    }
    /**
     * Set dim1 value
     * @param string $dim1
     * @return \StructType\PaczkaV2
     */
    public function setDim1($dim1 = null)
    {
        // validation for constraint: string
        if (!is_null($dim1) && !is_string($dim1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dim1)), __LINE__);
        }
        $this->dim1 = $dim1;
        return $this;
    }
    /**
     * Get dim2 value
     * @return string|null
     */
    public function getDim2()
    {
        return $this->dim2;
    }
    /**
     * Set dim2 value
     * @param string $dim2
     * @return \StructType\PaczkaV2
     */
    public function setDim2($dim2 = null)
    {
        // validation for constraint: string
        if (!is_null($dim2) && !is_string($dim2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dim2)), __LINE__);
        }
        $this->dim2 = $dim2;
        return $this;
    }
    /**
     * Get dim3 value
     * @return string|null
     */
    public function getDim3()
    {
        return $this->dim3;
    }
    /**
     * Set dim3 value
     * @param string $dim3
     * @return \StructType\PaczkaV2
     */
    public function setDim3($dim3 = null)
    {
        // validation for constraint: string
        if (!is_null($dim3) && !is_string($dim3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dim3)), __LINE__);
        }
        $this->dim3 = $dim3;
        return $this;
    }
    /**
     * Get shape value
     * @return string|null
     */
    public function getShape()
    {
        return $this->shape;
    }
    /**
     * Set shape value
     * @param string $shape
     * @return \StructType\PaczkaV2
     */
    public function setShape($shape = null)
    {
        // validation for constraint: string
        if (!is_null($shape) && !is_string($shape)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shape)), __LINE__);
        }
        $this->shape = $shape;
        return $this;
    }
    /**
     * Get dimWeight value
     * @return string|null
     */
    public function getDimWeight()
    {
        return $this->dimWeight;
    }
    /**
     * Set dimWeight value
     * @param string $dimWeight
     * @return \StructType\PaczkaV2
     */
    public function setDimWeight($dimWeight = null)
    {
        // validation for constraint: string
        if (!is_null($dimWeight) && !is_string($dimWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dimWeight)), __LINE__);
        }
        $this->dimWeight = $dimWeight;
        return $this;
    }
    /**
     * Get nrExtPp value
     * @return string|null
     */
    public function getNrExtPp()
    {
        return $this->nrExtPp;
    }
    /**
     * Set nrExtPp value
     * @param string $nrExtPp
     * @return \StructType\PaczkaV2
     */
    public function setNrExtPp($nrExtPp = null)
    {
        // validation for constraint: string
        if (!is_null($nrExtPp) && !is_string($nrExtPp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nrExtPp)), __LINE__);
        }
        $this->nrExtPp = $nrExtPp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaczkaV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
