<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for odbiorcaV2 StructType
 * @subpackage Structs
 */
class OdbiorcaV2 extends AbstractStructBase
{
    /**
     * The receiverId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $receiverId;
    /**
     * The addressDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaneAdresowe
     */
    public $addressDetails;
    /**
     * The contactDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaneKontaktowe
     */
    public $contactDetails;
    /**
     * Constructor method for odbiorcaV2
     * @uses OdbiorcaV2::setReceiverId()
     * @uses OdbiorcaV2::setAddressDetails()
     * @uses OdbiorcaV2::setContactDetails()
     * @param string $receiverId
     * @param \StructType\DaneAdresowe $addressDetails
     * @param \StructType\DaneKontaktowe $contactDetails
     */
    public function __construct($receiverId = null, \StructType\DaneAdresowe $addressDetails = null, \StructType\DaneKontaktowe $contactDetails = null)
    {
        $this
            ->setReceiverId($receiverId)
            ->setAddressDetails($addressDetails)
            ->setContactDetails($contactDetails);
    }
    /**
     * Get receiverId value
     * @return string|null
     */
    public function getReceiverId()
    {
        return $this->receiverId;
    }
    /**
     * Set receiverId value
     * @param string $receiverId
     * @return \StructType\OdbiorcaV2
     */
    public function setReceiverId($receiverId = null)
    {
        // validation for constraint: string
        if (!is_null($receiverId) && !is_string($receiverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverId)), __LINE__);
        }
        $this->receiverId = $receiverId;
        return $this;
    }
    /**
     * Get addressDetails value
     * @return \StructType\DaneAdresowe|null
     */
    public function getAddressDetails()
    {
        return $this->addressDetails;
    }
    /**
     * Set addressDetails value
     * @param \StructType\DaneAdresowe $addressDetails
     * @return \StructType\OdbiorcaV2
     */
    public function setAddressDetails(\StructType\DaneAdresowe $addressDetails = null)
    {
        $this->addressDetails = $addressDetails;
        return $this;
    }
    /**
     * Get contactDetails value
     * @return \StructType\DaneKontaktowe|null
     */
    public function getContactDetails()
    {
        return $this->contactDetails;
    }
    /**
     * Set contactDetails value
     * @param \StructType\DaneKontaktowe $contactDetails
     * @return \StructType\OdbiorcaV2
     */
    public function setContactDetails(\StructType\DaneKontaktowe $contactDetails = null)
    {
        $this->contactDetails = $contactDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OdbiorcaV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
