<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listV2 StructType
 * @subpackage Structs
 */
class ListV2 extends AbstractStructBase
{
    /**
     * The nrExt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nrExt;
    /**
     * The paymentForm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentForm;
    /**
     * The shipmentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipmentType;
    /**
     * The payerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerType;
    /**
     * The sender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NadawcaV2
     */
    public $sender;
    /**
     * The receiver
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OdbiorcaV2
     */
    public $receiver;
    /**
     * The payer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PlatnikV2
     */
    public $payer;
    /**
     * The proofOfDispatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PotwierdzenieNadaniaV2
     */
    public $proofOfDispatch;
    /**
     * The cod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PobranieV2
     */
    public $cod;
    /**
     * The insurance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UbezpieczenieV2
     */
    public $insurance;
    /**
     * The additionalServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UslugiDodatkowe
     */
    public $additionalServices;
    /**
     * The parcels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaczkiV2
     */
    public $parcels;
    /**
     * The remarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $remarks;
    /**
     * The mpk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mpk;
    /**
     * Constructor method for listV2
     * @uses ListV2::setNrExt()
     * @uses ListV2::setPaymentForm()
     * @uses ListV2::setShipmentType()
     * @uses ListV2::setPayerType()
     * @uses ListV2::setSender()
     * @uses ListV2::setReceiver()
     * @uses ListV2::setPayer()
     * @uses ListV2::setProofOfDispatch()
     * @uses ListV2::setCod()
     * @uses ListV2::setInsurance()
     * @uses ListV2::setAdditionalServices()
     * @uses ListV2::setParcels()
     * @uses ListV2::setRemarks()
     * @uses ListV2::setMpk()
     * @param string $nrExt
     * @param string $paymentForm
     * @param string $shipmentType
     * @param string $payerType
     * @param \StructType\NadawcaV2 $sender
     * @param \StructType\OdbiorcaV2 $receiver
     * @param \StructType\PlatnikV2 $payer
     * @param \StructType\PotwierdzenieNadaniaV2 $proofOfDispatch
     * @param \StructType\PobranieV2 $cod
     * @param \StructType\UbezpieczenieV2 $insurance
     * @param \StructType\UslugiDodatkowe $additionalServices
     * @param \StructType\PaczkiV2 $parcels
     * @param string $remarks
     * @param string $mpk
     */
    public function __construct($nrExt = null, $paymentForm = null, $shipmentType = null, $payerType = null, \StructType\NadawcaV2 $sender = null, \StructType\OdbiorcaV2 $receiver = null, \StructType\PlatnikV2 $payer = null, \StructType\PotwierdzenieNadaniaV2 $proofOfDispatch = null, \StructType\PobranieV2 $cod = null, \StructType\UbezpieczenieV2 $insurance = null, \StructType\UslugiDodatkowe $additionalServices = null, \StructType\PaczkiV2 $parcels = null, $remarks = null, $mpk = null)
    {
        $this
            ->setNrExt($nrExt)
            ->setPaymentForm($paymentForm)
            ->setShipmentType($shipmentType)
            ->setPayerType($payerType)
            ->setSender($sender)
            ->setReceiver($receiver)
            ->setPayer($payer)
            ->setProofOfDispatch($proofOfDispatch)
            ->setCod($cod)
            ->setInsurance($insurance)
            ->setAdditionalServices($additionalServices)
            ->setParcels($parcels)
            ->setRemarks($remarks)
            ->setMpk($mpk);
    }
    /**
     * Get nrExt value
     * @return string|null
     */
    public function getNrExt()
    {
        return $this->nrExt;
    }
    /**
     * Set nrExt value
     * @param string $nrExt
     * @return \StructType\ListV2
     */
    public function setNrExt($nrExt = null)
    {
        // validation for constraint: string
        if (!is_null($nrExt) && !is_string($nrExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nrExt)), __LINE__);
        }
        $this->nrExt = $nrExt;
        return $this;
    }
    /**
     * Get paymentForm value
     * @return string|null
     */
    public function getPaymentForm()
    {
        return $this->paymentForm;
    }
    /**
     * Set paymentForm value
     * @param string $paymentForm
     * @return \StructType\ListV2
     */
    public function setPaymentForm($paymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($paymentForm) && !is_string($paymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentForm)), __LINE__);
        }
        $this->paymentForm = $paymentForm;
        return $this;
    }
    /**
     * Get shipmentType value
     * @return string|null
     */
    public function getShipmentType()
    {
        return $this->shipmentType;
    }
    /**
     * Set shipmentType value
     * @param string $shipmentType
     * @return \StructType\ListV2
     */
    public function setShipmentType($shipmentType = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentType) && !is_string($shipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipmentType)), __LINE__);
        }
        $this->shipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get payerType value
     * @return string|null
     */
    public function getPayerType()
    {
        return $this->payerType;
    }
    /**
     * Set payerType value
     * @param string $payerType
     * @return \StructType\ListV2
     */
    public function setPayerType($payerType = null)
    {
        // validation for constraint: string
        if (!is_null($payerType) && !is_string($payerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payerType)), __LINE__);
        }
        $this->payerType = $payerType;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\NadawcaV2|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\NadawcaV2 $sender
     * @return \StructType\ListV2
     */
    public function setSender(\StructType\NadawcaV2 $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\OdbiorcaV2|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\OdbiorcaV2 $receiver
     * @return \StructType\ListV2
     */
    public function setReceiver(\StructType\OdbiorcaV2 $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get payer value
     * @return \StructType\PlatnikV2|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @param \StructType\PlatnikV2 $payer
     * @return \StructType\ListV2
     */
    public function setPayer(\StructType\PlatnikV2 $payer = null)
    {
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get proofOfDispatch value
     * @return \StructType\PotwierdzenieNadaniaV2|null
     */
    public function getProofOfDispatch()
    {
        return $this->proofOfDispatch;
    }
    /**
     * Set proofOfDispatch value
     * @param \StructType\PotwierdzenieNadaniaV2 $proofOfDispatch
     * @return \StructType\ListV2
     */
    public function setProofOfDispatch(\StructType\PotwierdzenieNadaniaV2 $proofOfDispatch = null)
    {
        $this->proofOfDispatch = $proofOfDispatch;
        return $this;
    }
    /**
     * Get cod value
     * @return \StructType\PobranieV2|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param \StructType\PobranieV2 $cod
     * @return \StructType\ListV2
     */
    public function setCod(\StructType\PobranieV2 $cod = null)
    {
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get insurance value
     * @return \StructType\UbezpieczenieV2|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param \StructType\UbezpieczenieV2 $insurance
     * @return \StructType\ListV2
     */
    public function setInsurance(\StructType\UbezpieczenieV2 $insurance = null)
    {
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Get additionalServices value
     * @return \StructType\UslugiDodatkowe|null
     */
    public function getAdditionalServices()
    {
        return $this->additionalServices;
    }
    /**
     * Set additionalServices value
     * @param \StructType\UslugiDodatkowe $additionalServices
     * @return \StructType\ListV2
     */
    public function setAdditionalServices(\StructType\UslugiDodatkowe $additionalServices = null)
    {
        $this->additionalServices = $additionalServices;
        return $this;
    }
    /**
     * Get parcels value
     * @return \StructType\PaczkiV2|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @param \StructType\PaczkiV2 $parcels
     * @return \StructType\ListV2
     */
    public function setParcels(\StructType\PaczkiV2 $parcels = null)
    {
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Get remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->remarks;
    }
    /**
     * Set remarks value
     * @param string $remarks
     * @return \StructType\ListV2
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->remarks = $remarks;
        return $this;
    }
    /**
     * Get mpk value
     * @return string|null
     */
    public function getMpk()
    {
        return $this->mpk;
    }
    /**
     * Set mpk value
     * @param string $mpk
     * @return \StructType\ListV2
     */
    public function setMpk($mpk = null)
    {
        // validation for constraint: string
        if (!is_null($mpk) && !is_string($mpk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpk)), __LINE__);
        }
        $this->mpk = $mpk;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
