<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dostepneUslugi StructType
 * @subpackage Structs
 */
class DostepneUslugi extends AbstractStructBase
{
    /**
     * The availableService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $availableService;
    /**
     * Constructor method for dostepneUslugi
     * @uses DostepneUslugi::setAvailableService()
     * @param string[] $availableService
     */
    public function __construct(array $availableService = array())
    {
        $this
            ->setAvailableService($availableService);
    }
    /**
     * Get availableService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAvailableService()
    {
        return isset($this->availableService) ? $this->availableService : null;
    }
    /**
     * Set availableService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $availableService
     * @return \StructType\DostepneUslugi
     */
    public function setAvailableService(array $availableService = array())
    {
        foreach ($availableService as $dostepneUslugiAvailableServiceItem) {
            // validation for constraint: itemType
            if (!is_string($dostepneUslugiAvailableServiceItem)) {
                throw new \InvalidArgumentException(sprintf('The availableService property can only contain items of string, "%s" given', is_object($dostepneUslugiAvailableServiceItem) ? get_class($dostepneUslugiAvailableServiceItem) : gettype($dostepneUslugiAvailableServiceItem)), __LINE__);
            }
        }
        if (is_null($availableService) || (is_array($availableService) && empty($availableService))) {
            unset($this->availableService);
        } else {
            $this->availableService = $availableService;
        }
        return $this;
    }
    /**
     * Add item to availableService value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DostepneUslugi
     */
    public function addToAvailableService($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The availableService property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->availableService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DostepneUslugi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
