<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bledy StructType
 * @subpackage Structs
 */
class Bledy extends AbstractStructBase
{
    /**
     * The blad
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Blad[]
     */
    public $blad;
    /**
     * Constructor method for bledy
     * @uses Bledy::setBlad()
     * @param \StructType\Blad[] $blad
     */
    public function __construct(array $blad = array())
    {
        $this
            ->setBlad($blad);
    }
    /**
     * Get blad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Blad[]|null
     */
    public function getBlad()
    {
        return isset($this->blad) ? $this->blad : null;
    }
    /**
     * Set blad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Blad[] $blad
     * @return \StructType\Bledy
     */
    public function setBlad(array $blad = array())
    {
        foreach ($blad as $bledyBladItem) {
            // validation for constraint: itemType
            if (!$bledyBladItem instanceof \StructType\Blad) {
                throw new \InvalidArgumentException(sprintf('The blad property can only contain items of \StructType\Blad, "%s" given', is_object($bledyBladItem) ? get_class($bledyBladItem) : gettype($bledyBladItem)), __LINE__);
            }
        }
        if (is_null($blad) || (is_array($blad) && empty($blad))) {
            unset($this->blad);
        } else {
            $this->blad = $blad;
        }
        return $this;
    }
    /**
     * Add item to blad value
     * @throws \InvalidArgumentException
     * @param \StructType\Blad $item
     * @return \StructType\Bledy
     */
    public function addToBlad(\StructType\Blad $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Blad) {
            throw new \InvalidArgumentException(sprintf('The blad property can only contain items of \StructType\Blad, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->blad[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bledy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
