<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for blad StructType
 * @subpackage Structs
 */
class Blad extends AbstractStructBase
{
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $error;
    /**
     * The kod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kod;
    /**
     * The opis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opis;
    /**
     * Constructor method for blad
     * @uses Blad::setError()
     * @uses Blad::setKod()
     * @uses Blad::setOpis()
     * @param string $error
     * @param int $kod
     * @param string $opis
     */
    public function __construct($error = null, $kod = null, $opis = null)
    {
        $this
            ->setError($error)
            ->setKod($kod)
            ->setOpis($opis);
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \StructType\Blad
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Get kod value
     * @return int|null
     */
    public function getKod()
    {
        return $this->kod;
    }
    /**
     * Set kod value
     * @param int $kod
     * @return \StructType\Blad
     */
    public function setKod($kod = null)
    {
        // validation for constraint: int
        if (!is_null($kod) && !is_numeric($kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kod)), __LINE__);
        }
        $this->kod = $kod;
        return $this;
    }
    /**
     * Get opis value
     * @return string|null
     */
    public function getOpis()
    {
        return $this->opis;
    }
    /**
     * Set opis value
     * @param string $opis
     * @return \StructType\Blad
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opis)), __LINE__);
        }
        $this->opis = $opis;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Blad
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
