<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for argumentUslugi StructType
 * @subpackage Structs
 */
class ArgumentUslugi extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The argValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $argValue;
    /**
     * Constructor method for argumentUslugi
     * @uses ArgumentUslugi::setCode()
     * @uses ArgumentUslugi::setArgValue()
     * @param string $code
     * @param string $argValue
     */
    public function __construct($code = null, $argValue = null)
    {
        $this
            ->setCode($code)
            ->setArgValue($argValue);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ArgumentUslugi
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get argValue value
     * @return string|null
     */
    public function getArgValue()
    {
        return $this->argValue;
    }
    /**
     * Set argValue value
     * @param string $argValue
     * @return \StructType\ArgumentUslugi
     */
    public function setArgValue($argValue = null)
    {
        // validation for constraint: string
        if (!is_null($argValue) && !is_string($argValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($argValue)), __LINE__);
        }
        $this->argValue = $argValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArgumentUslugi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
