<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zapisz ServiceType
 * @subpackage Services
 */
class Zapisz extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named zapiszDokumentWydania
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapiszDokumentWydania $parameters
     * @return \StructType\ZapiszDokumentWydaniaResponse|bool
     */
    public function zapiszDokumentWydania(\StructType\ZapiszDokumentWydania $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->zapiszDokumentWydania($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapiszList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapiszList $parameters
     * @return \StructType\ZapiszListResponse|bool
     */
    public function zapiszList(\StructType\ZapiszList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->zapiszList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapiszListV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapiszListV2 $parameters
     * @return \StructType\ZapiszListV2Response|bool
     */
    public function zapiszListV2(\StructType\ZapiszListV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->zapiszListV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named zapiszListZwrotnyV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapiszListZwrotnyV2 $parameters
     * @return \StructType\ZapiszListZwrotnyV2Response|bool
     */
    public function zapiszListZwrotnyV2(\StructType\ZapiszListZwrotnyV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->zapiszListZwrotnyV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZapiszDokumentWydaniaResponse|\StructType\ZapiszListResponse|\StructType\ZapiszListV2Response|\StructType\ZapiszListZwrotnyV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
