<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wydrukj ServiceType
 * @subpackage Services
 */
class Wydrukj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named wydrukjList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WydrukjList $parameters
     * @return \StructType\WydrukjListResponse|bool
     */
    public function wydrukjList(\StructType\WydrukjList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->wydrukjList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WydrukjListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
