<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Usun ServiceType
 * @subpackage Services
 */
class Usun extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named usunKlienta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsunKlienta $parameters
     * @return \StructType\UsunKlientaResponse|bool
     */
    public function usunKlienta(\StructType\UsunKlienta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->usunKlienta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UsunKlientaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
