<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Szukaj ServiceType
 * @subpackage Services
 */
class Szukaj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named szukajKlienta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SzukajKlienta $parameters
     * @return \StructType\SzukajKlientaResponse|bool
     */
    public function szukajKlienta(\StructType\SzukajKlienta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->szukajKlienta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SzukajKlientaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
