<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dodaj ServiceType
 * @subpackage Services
 */
class Dodaj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named dodajKlienta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DodajKlienta $parameters
     * @return \StructType\DodajKlientaResponse|bool
     */
    public function dodajKlienta(\StructType\DodajKlienta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dodajKlienta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dodajZlecenie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DodajZlecenie $parameters
     * @return \StructType\DodajZlecenieResponse|bool
     */
    public function dodajZlecenie(\StructType\DodajZlecenie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dodajZlecenie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dodajZlecenieV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DodajZlecenieV2 $parameters
     * @return \StructType\DodajZlecenieV2Response|bool
     */
    public function dodajZlecenieV2(\StructType\DodajZlecenieV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->dodajZlecenieV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DodajKlientaResponse|\StructType\DodajZlecenieResponse|\StructType\DodajZlecenieV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
