<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anuluj ServiceType
 * @subpackage Services
 */
class Anuluj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named anulujZlecenie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnulujZlecenie $parameters
     * @return \StructType\AnulujZlecenieResponse|bool
     */
    public function anulujZlecenie(\StructType\AnulujZlecenie $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->anulujZlecenie($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnulujZlecenieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
