<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uslugiDodatkowe StructType
 * @subpackage Structs
 */
class UslugiDodatkowe extends AbstractStructBase
{
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UslugaDodatkowa[]
     */
    public $service;
    /**
     * Constructor method for uslugiDodatkowe
     * @uses UslugiDodatkowe::setService()
     * @param \StructType\UslugaDodatkowa[] $service
     */
    public function __construct(array $service = array())
    {
        $this
            ->setService($service);
    }
    /**
     * Get service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UslugaDodatkowa[]|null
     */
    public function getService()
    {
        return isset($this->service) ? $this->service : null;
    }
    /**
     * Set service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UslugaDodatkowa[] $service
     * @return \StructType\UslugiDodatkowe
     */
    public function setService(array $service = array())
    {
        foreach ($service as $uslugiDodatkoweServiceItem) {
            // validation for constraint: itemType
            if (!$uslugiDodatkoweServiceItem instanceof \StructType\UslugaDodatkowa) {
                throw new \InvalidArgumentException(sprintf('The service property can only contain items of \StructType\UslugaDodatkowa, "%s" given', is_object($uslugiDodatkoweServiceItem) ? get_class($uslugiDodatkoweServiceItem) : gettype($uslugiDodatkoweServiceItem)), __LINE__);
            }
        }
        if (is_null($service) || (is_array($service) && empty($service))) {
            unset($this->service);
        } else {
            $this->service = $service;
        }
        return $this;
    }
    /**
     * Add item to service value
     * @throws \InvalidArgumentException
     * @param \StructType\UslugaDodatkowa $item
     * @return \StructType\UslugiDodatkowe
     */
    public function addToService(\StructType\UslugaDodatkowa $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UslugaDodatkowa) {
            throw new \InvalidArgumentException(sprintf('The service property can only contain items of \StructType\UslugaDodatkowa, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UslugiDodatkowe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
