<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ubezpieczenieV2 StructType
 * @subpackage Structs
 */
class UbezpieczenieV2 extends AbstractStructBase
{
    /**
     * The insuranceValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insuranceValue;
    /**
     * The contentDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contentDescription;
    /**
     * Constructor method for ubezpieczenieV2
     * @uses UbezpieczenieV2::setInsuranceValue()
     * @uses UbezpieczenieV2::setContentDescription()
     * @param string $insuranceValue
     * @param string $contentDescription
     */
    public function __construct($insuranceValue = null, $contentDescription = null)
    {
        $this
            ->setInsuranceValue($insuranceValue)
            ->setContentDescription($contentDescription);
    }
    /**
     * Get insuranceValue value
     * @return string|null
     */
    public function getInsuranceValue()
    {
        return $this->insuranceValue;
    }
    /**
     * Set insuranceValue value
     * @param string $insuranceValue
     * @return \StructType\UbezpieczenieV2
     */
    public function setInsuranceValue($insuranceValue = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceValue) && !is_string($insuranceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceValue)), __LINE__);
        }
        $this->insuranceValue = $insuranceValue;
        return $this;
    }
    /**
     * Get contentDescription value
     * @return string|null
     */
    public function getContentDescription()
    {
        return $this->contentDescription;
    }
    /**
     * Set contentDescription value
     * @param string $contentDescription
     * @return \StructType\UbezpieczenieV2
     */
    public function setContentDescription($contentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentDescription) && !is_string($contentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentDescription)), __LINE__);
        }
        $this->contentDescription = $contentDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UbezpieczenieV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
