<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pobranieV2 StructType
 * @subpackage Structs
 */
class PobranieV2 extends AbstractStructBase
{
    /**
     * The codType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codType;
    /**
     * The codValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codValue;
    /**
     * The bankAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountNumber;
    /**
     * Constructor method for pobranieV2
     * @uses PobranieV2::setCodType()
     * @uses PobranieV2::setCodValue()
     * @uses PobranieV2::setBankAccountNumber()
     * @param string $codType
     * @param string $codValue
     * @param string $bankAccountNumber
     */
    public function __construct($codType = null, $codValue = null, $bankAccountNumber = null)
    {
        $this
            ->setCodType($codType)
            ->setCodValue($codValue)
            ->setBankAccountNumber($bankAccountNumber);
    }
    /**
     * Get codType value
     * @return string|null
     */
    public function getCodType()
    {
        return $this->codType;
    }
    /**
     * Set codType value
     * @param string $codType
     * @return \StructType\PobranieV2
     */
    public function setCodType($codType = null)
    {
        // validation for constraint: string
        if (!is_null($codType) && !is_string($codType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codType)), __LINE__);
        }
        $this->codType = $codType;
        return $this;
    }
    /**
     * Get codValue value
     * @return string|null
     */
    public function getCodValue()
    {
        return $this->codValue;
    }
    /**
     * Set codValue value
     * @param string $codValue
     * @return \StructType\PobranieV2
     */
    public function setCodValue($codValue = null)
    {
        // validation for constraint: string
        if (!is_null($codValue) && !is_string($codValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codValue)), __LINE__);
        }
        $this->codValue = $codValue;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\PobranieV2
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PobranieV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
