<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for platnikV2 StructType
 * @subpackage Structs
 */
class PlatnikV2 extends AbstractStructBase
{
    /**
     * The payerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerId;
    /**
     * The contactDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaneKontaktowe
     */
    public $contactDetails;
    /**
     * Constructor method for platnikV2
     * @uses PlatnikV2::setPayerId()
     * @uses PlatnikV2::setContactDetails()
     * @param string $payerId
     * @param \StructType\DaneKontaktowe $contactDetails
     */
    public function __construct($payerId = null, \StructType\DaneKontaktowe $contactDetails = null)
    {
        $this
            ->setPayerId($payerId)
            ->setContactDetails($contactDetails);
    }
    /**
     * Get payerId value
     * @return string|null
     */
    public function getPayerId()
    {
        return $this->payerId;
    }
    /**
     * Set payerId value
     * @param string $payerId
     * @return \StructType\PlatnikV2
     */
    public function setPayerId($payerId = null)
    {
        // validation for constraint: string
        if (!is_null($payerId) && !is_string($payerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payerId)), __LINE__);
        }
        $this->payerId = $payerId;
        return $this;
    }
    /**
     * Get contactDetails value
     * @return \StructType\DaneKontaktowe|null
     */
    public function getContactDetails()
    {
        return $this->contactDetails;
    }
    /**
     * Set contactDetails value
     * @param \StructType\DaneKontaktowe $contactDetails
     * @return \StructType\PlatnikV2
     */
    public function setContactDetails(\StructType\DaneKontaktowe $contactDetails = null)
    {
        $this->contactDetails = $contactDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlatnikV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
