<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczki StructType
 * @subpackage Structs
 */
class Paczki extends AbstractStructBase
{
    /**
     * The paczka
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paczka[]
     */
    public $paczka;
    /**
     * Constructor method for paczki
     * @uses Paczki::setPaczka()
     * @param \StructType\Paczka[] $paczka
     */
    public function __construct(array $paczka = array())
    {
        $this
            ->setPaczka($paczka);
    }
    /**
     * Get paczka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paczka[]|null
     */
    public function getPaczka()
    {
        return isset($this->paczka) ? $this->paczka : null;
    }
    /**
     * Set paczka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Paczka[] $paczka
     * @return \StructType\Paczki
     */
    public function setPaczka(array $paczka = array())
    {
        foreach ($paczka as $paczkiPaczkaItem) {
            // validation for constraint: itemType
            if (!$paczkiPaczkaItem instanceof \StructType\Paczka) {
                throw new \InvalidArgumentException(sprintf('The paczka property can only contain items of \StructType\Paczka, "%s" given', is_object($paczkiPaczkaItem) ? get_class($paczkiPaczkaItem) : gettype($paczkiPaczkaItem)), __LINE__);
            }
        }
        if (is_null($paczka) || (is_array($paczka) && empty($paczka))) {
            unset($this->paczka);
        } else {
            $this->paczka = $paczka;
        }
        return $this;
    }
    /**
     * Add item to paczka value
     * @throws \InvalidArgumentException
     * @param \StructType\Paczka $item
     * @return \StructType\Paczki
     */
    public function addToPaczka(\StructType\Paczka $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Paczka) {
            throw new \InvalidArgumentException(sprintf('The paczka property can only contain items of \StructType\Paczka, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paczka[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Paczki
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
