<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paczkaStatusV2 StructType
 * @subpackage Structs
 */
class PaczkaStatusV2 extends AbstractStructBase
{
    /**
     * The parcelNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcelNumber;
    /**
     * The statusDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusDate;
    /**
     * The shortStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortStatus;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The deptSymbol
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deptSymbol;
    /**
     * The recipientSignature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recipientSignature;
    /**
     * Constructor method for paczkaStatusV2
     * @uses PaczkaStatusV2::setParcelNumber()
     * @uses PaczkaStatusV2::setStatusDate()
     * @uses PaczkaStatusV2::setShortStatus()
     * @uses PaczkaStatusV2::setDescription()
     * @uses PaczkaStatusV2::setDeptSymbol()
     * @uses PaczkaStatusV2::setRecipientSignature()
     * @param int $parcelNumber
     * @param string $statusDate
     * @param string $shortStatus
     * @param string $description
     * @param string $deptSymbol
     * @param string $recipientSignature
     */
    public function __construct($parcelNumber = null, $statusDate = null, $shortStatus = null, $description = null, $deptSymbol = null, $recipientSignature = null)
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setStatusDate($statusDate)
            ->setShortStatus($shortStatus)
            ->setDescription($description)
            ->setDeptSymbol($deptSymbol)
            ->setRecipientSignature($recipientSignature);
    }
    /**
     * Get parcelNumber value
     * @return int|null
     */
    public function getParcelNumber()
    {
        return $this->parcelNumber;
    }
    /**
     * Set parcelNumber value
     * @param int $parcelNumber
     * @return \StructType\PaczkaStatusV2
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !is_numeric($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parcelNumber)), __LINE__);
        }
        $this->parcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get statusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->statusDate;
    }
    /**
     * Set statusDate value
     * @param string $statusDate
     * @return \StructType\PaczkaStatusV2
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->statusDate = $statusDate;
        return $this;
    }
    /**
     * Get shortStatus value
     * @return string|null
     */
    public function getShortStatus()
    {
        return $this->shortStatus;
    }
    /**
     * Set shortStatus value
     * @param string $shortStatus
     * @return \StructType\PaczkaStatusV2
     */
    public function setShortStatus($shortStatus = null)
    {
        // validation for constraint: string
        if (!is_null($shortStatus) && !is_string($shortStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortStatus)), __LINE__);
        }
        $this->shortStatus = $shortStatus;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PaczkaStatusV2
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deptSymbol value
     * @return string|null
     */
    public function getDeptSymbol()
    {
        return $this->deptSymbol;
    }
    /**
     * Set deptSymbol value
     * @param string $deptSymbol
     * @return \StructType\PaczkaStatusV2
     */
    public function setDeptSymbol($deptSymbol = null)
    {
        // validation for constraint: string
        if (!is_null($deptSymbol) && !is_string($deptSymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptSymbol)), __LINE__);
        }
        $this->deptSymbol = $deptSymbol;
        return $this;
    }
    /**
     * Get recipientSignature value
     * @return string|null
     */
    public function getRecipientSignature()
    {
        return $this->recipientSignature;
    }
    /**
     * Set recipientSignature value
     * @param string $recipientSignature
     * @return \StructType\PaczkaStatusV2
     */
    public function setRecipientSignature($recipientSignature = null)
    {
        // validation for constraint: string
        if (!is_null($recipientSignature) && !is_string($recipientSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientSignature)), __LINE__);
        }
        $this->recipientSignature = $recipientSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaczkaStatusV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
