<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for argumentyUslugi StructType
 * @subpackage Structs
 */
class ArgumentyUslugi extends AbstractStructBase
{
    /**
     * The serviceArgument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArgumentUslugi[]
     */
    public $serviceArgument;
    /**
     * Constructor method for argumentyUslugi
     * @uses ArgumentyUslugi::setServiceArgument()
     * @param \StructType\ArgumentUslugi[] $serviceArgument
     */
    public function __construct(array $serviceArgument = array())
    {
        $this
            ->setServiceArgument($serviceArgument);
    }
    /**
     * Get serviceArgument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArgumentUslugi[]|null
     */
    public function getServiceArgument()
    {
        return isset($this->serviceArgument) ? $this->serviceArgument : null;
    }
    /**
     * Set serviceArgument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArgumentUslugi[] $serviceArgument
     * @return \StructType\ArgumentyUslugi
     */
    public function setServiceArgument(array $serviceArgument = array())
    {
        foreach ($serviceArgument as $argumentyUslugiServiceArgumentItem) {
            // validation for constraint: itemType
            if (!$argumentyUslugiServiceArgumentItem instanceof \StructType\ArgumentUslugi) {
                throw new \InvalidArgumentException(sprintf('The serviceArgument property can only contain items of \StructType\ArgumentUslugi, "%s" given', is_object($argumentyUslugiServiceArgumentItem) ? get_class($argumentyUslugiServiceArgumentItem) : gettype($argumentyUslugiServiceArgumentItem)), __LINE__);
            }
        }
        if (is_null($serviceArgument) || (is_array($serviceArgument) && empty($serviceArgument))) {
            unset($this->serviceArgument);
        } else {
            $this->serviceArgument = $serviceArgument;
        }
        return $this;
    }
    /**
     * Add item to serviceArgument value
     * @throws \InvalidArgumentException
     * @param \StructType\ArgumentUslugi $item
     * @return \StructType\ArgumentyUslugi
     */
    public function addToServiceArgument(\StructType\ArgumentUslugi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArgumentUslugi) {
            throw new \InvalidArgumentException(sprintf('The serviceArgument property can only contain items of \StructType\ArgumentUslugi, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceArgument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArgumentyUslugi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
