<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wydrukuj ServiceType
 * @subpackage Services
 */
class Wydrukuj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named wydrukujEtykiete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WydrukujEtykiete $parameters
     * @return \StructType\WydrukujEtykieteResponse|bool
     */
    public function wydrukujEtykiete(\StructType\WydrukujEtykiete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->wydrukujEtykiete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named wydrukujEtykietePaczki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WydrukujEtykietePaczki $parameters
     * @return \StructType\WydrukujEtykietePaczkiResponse|bool
     */
    public function wydrukujEtykietePaczki(\StructType\WydrukujEtykietePaczki $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->wydrukujEtykietePaczki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WydrukujEtykietePaczkiResponse|\StructType\WydrukujEtykieteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
