<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pobierz ServiceType
 * @subpackage Services
 */
class Pobierz extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pobierzStatusyPrzesylki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzStatusyPrzesylki $parameters
     * @return \StructType\PobierzStatusyPrzesylkiResponse|bool
     */
    public function pobierzStatusyPrzesylki(\StructType\PobierzStatusyPrzesylki $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzStatusyPrzesylki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzStatusyPaczki
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzStatusyPaczki $parameters
     * @return \StructType\PobierzStatusyPaczkiResponse|bool
     */
    public function pobierzStatusyPaczki(\StructType\PobierzStatusyPaczki $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzStatusyPaczki($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzDokumentWydania
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzDokumentWydania $parameters
     * @return \StructType\PobierzDokumentWydaniaResponse|bool
     */
    public function pobierzDokumentWydania(\StructType\PobierzDokumentWydania $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzDokumentWydania($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzNumerDokumentuList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzNumerDokumentuList $parameters
     * @return \StructType\PobierzNumerDokumentuListResponse|bool
     */
    public function pobierzNumerDokumentuList(\StructType\PobierzNumerDokumentuList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzNumerDokumentuList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzDostepneUslugi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzDostepneUslugi $parameters
     * @return \StructType\PobierzDostepneUslugiResponse|bool
     */
    public function pobierzDostepneUslugi(\StructType\PobierzDostepneUslugi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzDostepneUslugi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzZbiorStatusow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzZbiorStatusow $parameters
     * @return \StructType\PobierzZbiorStatusowResponse|bool
     */
    public function pobierzZbiorStatusow(\StructType\PobierzZbiorStatusow $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzZbiorStatusow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named pobierzWersje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobierzWersje $parameters
     * @return \StructType\PobierzWersjeResponse|bool
     */
    public function pobierzWersje(\StructType\PobierzWersje $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->pobierzWersje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PobierzDokumentWydaniaResponse|\StructType\PobierzDostepneUslugiResponse|\StructType\PobierzNumerDokumentuListResponse|\StructType\PobierzStatusyPaczkiResponse|\StructType\PobierzStatusyPrzesylkiResponse|\StructType\PobierzWersjeResponse|\StructType\PobierzZbiorStatusowResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
