<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edytuj ServiceType
 * @subpackage Services
 */
class Edytuj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named edytujKlienta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EdytujKlienta $parameters
     * @return \StructType\EdytujKlientaResponse|bool
     */
    public function edytujKlienta(\StructType\EdytujKlienta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->edytujKlienta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named edytujList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EdytujList $parameters
     * @return \StructType\EdytujListResponse|bool
     */
    public function edytujList(\StructType\EdytujList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->edytujList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EdytujKlientaResponse|\StructType\EdytujListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
