<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingRequest StructType
 * Meta informations extracted from the WSDL
 * - type: s0:TrackingRequest
 * @subpackage Structs
 */
class TrackingRequest extends AbstractStructBase
{
    /**
     * The ClientDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocTypeRef_ClientDetailType
     */
    public $ClientDetail;
    /**
     * The Request
     * @var \StructType\Request
     */
    public $Request;
    /**
     * The LanguageCode
     * Meta informations extracted from the WSDL
     * - documentation: The language code requested by user. This field is mandatory when LanguageScriptCode and/or LanguageCountryCode is provided. Please refer to the Developer Guide for the supported language code | ISO Language Code
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LanguageCode;
    /**
     * The LanguageScriptCode
     * Meta informations extracted from the WSDL
     * - documentation: Script Code
     * - base: xsd:string
     * - maxLength: 4
     * - minLength: 4
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LanguageScriptCode;
    /**
     * The LanguageCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: ISO 2 character code of country
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LanguageCountryCode;
    /**
     * The AWBNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAWBNumber
     */
    public $AWBNumber;
    /**
     * The LPNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTrackingPieceID
     */
    public $LPNumber;
    /**
     * The ReferenceQuery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReferenceQuery
     */
    public $ReferenceQuery;
    /**
     * The LevelOfDetails
     * Meta informations extracted from the WSDL
     * - documentation: Checkpoint Detail Indicator
     * @var string
     */
    public $LevelOfDetails;
    /**
     * The PiecesEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Pieces Indicator
     * - minOccurs: 0
     * @var string
     */
    public $PiecesEnabled;
    /**
     * The EstimatedDeliveryDateEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Indicates if estimated delivery date (EDD) should be included in the service response (Estimated Delivery Date is not always returned and is subject to the scans by the DHL Operations team).
     * - minOccurs: 0
     * @var bool
     */
    public $EstimatedDeliveryDateEnabled;
    /**
     * Constructor method for TrackingRequest
     * @uses TrackingRequest::setClientDetail()
     * @uses TrackingRequest::setRequest()
     * @uses TrackingRequest::setLanguageCode()
     * @uses TrackingRequest::setLanguageScriptCode()
     * @uses TrackingRequest::setLanguageCountryCode()
     * @uses TrackingRequest::setAWBNumber()
     * @uses TrackingRequest::setLPNumber()
     * @uses TrackingRequest::setReferenceQuery()
     * @uses TrackingRequest::setLevelOfDetails()
     * @uses TrackingRequest::setPiecesEnabled()
     * @uses TrackingRequest::setEstimatedDeliveryDateEnabled()
     * @param \StructType\DocTypeRef_ClientDetailType $clientDetail
     * @param \StructType\Request $request
     * @param string $languageCode
     * @param string $languageScriptCode
     * @param string $languageCountryCode
     * @param \ArrayType\ArrayOfAWBNumber $aWBNumber
     * @param \ArrayType\ArrayOfTrackingPieceID $lPNumber
     * @param \StructType\ReferenceQuery $referenceQuery
     * @param string $levelOfDetails
     * @param string $piecesEnabled
     * @param bool $estimatedDeliveryDateEnabled
     */
    public function __construct(\StructType\DocTypeRef_ClientDetailType $clientDetail = null, \StructType\Request $request = null, $languageCode = null, $languageScriptCode = null, $languageCountryCode = null, \ArrayType\ArrayOfAWBNumber $aWBNumber = null, \ArrayType\ArrayOfTrackingPieceID $lPNumber = null, \StructType\ReferenceQuery $referenceQuery = null, $levelOfDetails = null, $piecesEnabled = null, $estimatedDeliveryDateEnabled = null)
    {
        $this
            ->setClientDetail($clientDetail)
            ->setRequest($request)
            ->setLanguageCode($languageCode)
            ->setLanguageScriptCode($languageScriptCode)
            ->setLanguageCountryCode($languageCountryCode)
            ->setAWBNumber($aWBNumber)
            ->setLPNumber($lPNumber)
            ->setReferenceQuery($referenceQuery)
            ->setLevelOfDetails($levelOfDetails)
            ->setPiecesEnabled($piecesEnabled)
            ->setEstimatedDeliveryDateEnabled($estimatedDeliveryDateEnabled);
    }
    /**
     * Get ClientDetail value
     * @return \StructType\DocTypeRef_ClientDetailType|null
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \StructType\DocTypeRef_ClientDetailType $clientDetail
     * @return \StructType\TrackingRequest
     */
    public function setClientDetail(\StructType\DocTypeRef_ClientDetailType $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Request value
     * @return \StructType\Request|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\Request $request
     * @return \StructType\TrackingRequest
     */
    public function setRequest(\StructType\Request $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\TrackingRequest
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($languageCode) && mb_strlen($languageCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($languageCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($languageCode) && mb_strlen($languageCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get LanguageScriptCode value
     * @return string|null
     */
    public function getLanguageScriptCode()
    {
        return $this->LanguageScriptCode;
    }
    /**
     * Set LanguageScriptCode value
     * @param string $languageScriptCode
     * @return \StructType\TrackingRequest
     */
    public function setLanguageScriptCode($languageScriptCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageScriptCode) && !is_string($languageScriptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageScriptCode, true), gettype($languageScriptCode)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($languageScriptCode) && mb_strlen($languageScriptCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($languageScriptCode)), __LINE__);
        }
        // validation for constraint: minLength(4)
        if (!is_null($languageScriptCode) && mb_strlen($languageScriptCode) < 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 4', mb_strlen($languageScriptCode)), __LINE__);
        }
        $this->LanguageScriptCode = $languageScriptCode;
        return $this;
    }
    /**
     * Get LanguageCountryCode value
     * @return string|null
     */
    public function getLanguageCountryCode()
    {
        return $this->LanguageCountryCode;
    }
    /**
     * Set LanguageCountryCode value
     * @param string $languageCountryCode
     * @return \StructType\TrackingRequest
     */
    public function setLanguageCountryCode($languageCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCountryCode) && !is_string($languageCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCountryCode, true), gettype($languageCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($languageCountryCode) && mb_strlen($languageCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($languageCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($languageCountryCode) && mb_strlen($languageCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($languageCountryCode)), __LINE__);
        }
        $this->LanguageCountryCode = $languageCountryCode;
        return $this;
    }
    /**
     * Get AWBNumber value
     * @return \ArrayType\ArrayOfAWBNumber|null
     */
    public function getAWBNumber()
    {
        return $this->AWBNumber;
    }
    /**
     * Set AWBNumber value
     * @param \ArrayType\ArrayOfAWBNumber $aWBNumber
     * @return \StructType\TrackingRequest
     */
    public function setAWBNumber(\ArrayType\ArrayOfAWBNumber $aWBNumber = null)
    {
        $this->AWBNumber = $aWBNumber;
        return $this;
    }
    /**
     * Get LPNumber value
     * @return \ArrayType\ArrayOfTrackingPieceID|null
     */
    public function getLPNumber()
    {
        return $this->LPNumber;
    }
    /**
     * Set LPNumber value
     * @param \ArrayType\ArrayOfTrackingPieceID $lPNumber
     * @return \StructType\TrackingRequest
     */
    public function setLPNumber(\ArrayType\ArrayOfTrackingPieceID $lPNumber = null)
    {
        $this->LPNumber = $lPNumber;
        return $this;
    }
    /**
     * Get ReferenceQuery value
     * @return \StructType\ReferenceQuery|null
     */
    public function getReferenceQuery()
    {
        return $this->ReferenceQuery;
    }
    /**
     * Set ReferenceQuery value
     * @param \StructType\ReferenceQuery $referenceQuery
     * @return \StructType\TrackingRequest
     */
    public function setReferenceQuery(\StructType\ReferenceQuery $referenceQuery = null)
    {
        $this->ReferenceQuery = $referenceQuery;
        return $this;
    }
    /**
     * Get LevelOfDetails value
     * @return string|null
     */
    public function getLevelOfDetails()
    {
        return $this->LevelOfDetails;
    }
    /**
     * Set LevelOfDetails value
     * @uses \EnumType\LevelOfDetails::valueIsValid()
     * @uses \EnumType\LevelOfDetails::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $levelOfDetails
     * @return \StructType\TrackingRequest
     */
    public function setLevelOfDetails($levelOfDetails = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LevelOfDetails::valueIsValid($levelOfDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LevelOfDetails', is_array($levelOfDetails) ? implode(', ', $levelOfDetails) : var_export($levelOfDetails, true), implode(', ', \EnumType\LevelOfDetails::getValidValues())), __LINE__);
        }
        $this->LevelOfDetails = $levelOfDetails;
        return $this;
    }
    /**
     * Get PiecesEnabled value
     * @return string|null
     */
    public function getPiecesEnabled()
    {
        return $this->PiecesEnabled;
    }
    /**
     * Set PiecesEnabled value
     * @uses \EnumType\PiecesEnabled::valueIsValid()
     * @uses \EnumType\PiecesEnabled::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $piecesEnabled
     * @return \StructType\TrackingRequest
     */
    public function setPiecesEnabled($piecesEnabled = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PiecesEnabled::valueIsValid($piecesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PiecesEnabled', is_array($piecesEnabled) ? implode(', ', $piecesEnabled) : var_export($piecesEnabled, true), implode(', ', \EnumType\PiecesEnabled::getValidValues())), __LINE__);
        }
        $this->PiecesEnabled = $piecesEnabled;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDateEnabled value
     * @return bool|null
     */
    public function getEstimatedDeliveryDateEnabled()
    {
        return $this->EstimatedDeliveryDateEnabled;
    }
    /**
     * Set EstimatedDeliveryDateEnabled value
     * @param bool $estimatedDeliveryDateEnabled
     * @return \StructType\TrackingRequest
     */
    public function setEstimatedDeliveryDateEnabled($estimatedDeliveryDateEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($estimatedDeliveryDateEnabled) && !is_bool($estimatedDeliveryDateEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estimatedDeliveryDateEnabled, true), gettype($estimatedDeliveryDateEnabled)), __LINE__);
        }
        $this->EstimatedDeliveryDateEnabled = $estimatedDeliveryDateEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrackingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
