<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackedBy StructType
 * @subpackage Structs
 */
class TrackedBy extends AbstractStructBase
{
    /**
     * The LPNumber
     * Meta informations extracted from the WSDL
     * - documentation: DHL Piece ID
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: preserve
     * @var string
     */
    public $LPNumber;
    /**
     * Constructor method for TrackedBy
     * @uses TrackedBy::setLPNumber()
     * @param string $lPNumber
     */
    public function __construct($lPNumber = null)
    {
        $this
            ->setLPNumber($lPNumber);
    }
    /**
     * Get LPNumber value
     * @return string|null
     */
    public function getLPNumber()
    {
        return $this->LPNumber;
    }
    /**
     * Set LPNumber value
     * @param string $lPNumber
     * @return \StructType\TrackedBy
     */
    public function setLPNumber($lPNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lPNumber) && !is_string($lPNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lPNumber, true), gettype($lPNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($lPNumber) && mb_strlen($lPNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($lPNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lPNumber) && mb_strlen($lPNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lPNumber)), __LINE__);
        }
        $this->LPNumber = $lPNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrackedBy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
