<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentInfo StructType
 * @subpackage Structs
 */
class ShipmentInfo extends AbstractStructBase
{
    /**
     * The OriginServiceArea
     * @var \StructType\OriginServiceArea
     */
    public $OriginServiceArea;
    /**
     * The DestinationServiceArea
     * @var \StructType\DestinationServiceArea
     */
    public $DestinationServiceArea;
    /**
     * The ShipperName
     * Meta informations extracted from the WSDL
     * - documentation: Shipper Name
     * - base: xsd:string
     * - maxLength: 45
     * - whiteSpace: preserve
     * @var string
     */
    public $ShipperName;
    /**
     * The ShipperAccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: Shipper’s Account Number (currently not populated for tracking)
     * - base: xsd:positiveInteger
     * - maxInclusive: 9999999999
     * - minInclusive: 100000000
     * - minOccurs: 0
     * @var int
     */
    public $ShipperAccountNumber;
    /**
     * The ConsigneeName
     * Meta informations extracted from the WSDL
     * - documentation: Receiver’s Name
     * - base: xsd:string
     * - maxLength: 45
     * - whiteSpace: preserve
     * @var string
     */
    public $ConsigneeName;
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - documentation: The shipment initiation date, local to origin
     * @var string
     */
    public $ShipmentDate;
    /**
     * The Pieces
     * Meta informations extracted from the WSDL
     * - documentation: Number of pieces in shipment
     * - minOccurs: 0
     * @var string
     */
    public $Pieces;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - documentation: Weight of shipment. Format 99999.999
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The WeightUnit
     * Meta informations extracted from the WSDL
     * - documentation: L = Pounds K = Kilogram G = Grams
     * - minOccurs: 0
     * @var string
     */
    public $WeightUnit;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: The shipping product requested for this shipment, corresponding to the DHL Global Product codes
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceType;
    /**
     * The ShipmentDescription
     * Meta informations extracted from the WSDL
     * - documentation: The description of the shipment
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentDescription;
    /**
     * The Shipper
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Shipper
     */
    public $Shipper;
    /**
     * The Consignee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Consignee
     */
    public $Consignee;
    /**
     * The ShipmentEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShipmentEvent
     */
    public $ShipmentEvent;
    /**
     * The ShipperReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \StructType\ShipperReference[]
     */
    public $ShipperReference;
    /**
     * The EstimatedDeliveryDate
     * Meta informations extracted from the WSDL
     * - documentation: Estimted delivery date (EDD)
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * The ArrayOfChildShipmentIdentificationNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChildShipmentIdentificationNumbers
     */
    public $ArrayOfChildShipmentIdentificationNumbers;
    /**
     * Constructor method for ShipmentInfo
     * @uses ShipmentInfo::setOriginServiceArea()
     * @uses ShipmentInfo::setDestinationServiceArea()
     * @uses ShipmentInfo::setShipperName()
     * @uses ShipmentInfo::setShipperAccountNumber()
     * @uses ShipmentInfo::setConsigneeName()
     * @uses ShipmentInfo::setShipmentDate()
     * @uses ShipmentInfo::setPieces()
     * @uses ShipmentInfo::setWeight()
     * @uses ShipmentInfo::setWeightUnit()
     * @uses ShipmentInfo::setServiceType()
     * @uses ShipmentInfo::setShipmentDescription()
     * @uses ShipmentInfo::setShipper()
     * @uses ShipmentInfo::setConsignee()
     * @uses ShipmentInfo::setShipmentEvent()
     * @uses ShipmentInfo::setShipperReference()
     * @uses ShipmentInfo::setEstimatedDeliveryDate()
     * @uses ShipmentInfo::setArrayOfChildShipmentIdentificationNumbers()
     * @param \StructType\OriginServiceArea $originServiceArea
     * @param \StructType\DestinationServiceArea $destinationServiceArea
     * @param string $shipperName
     * @param int $shipperAccountNumber
     * @param string $consigneeName
     * @param string $shipmentDate
     * @param string $pieces
     * @param string $weight
     * @param string $weightUnit
     * @param string $serviceType
     * @param string $shipmentDescription
     * @param \StructType\Shipper $shipper
     * @param \StructType\Consignee $consignee
     * @param \ArrayType\ArrayOfShipmentEvent $shipmentEvent
     * @param \StructType\ShipperReference[] $shipperReference
     * @param string $estimatedDeliveryDate
     * @param \ArrayType\ArrayOfChildShipmentIdentificationNumbers $arrayOfChildShipmentIdentificationNumbers
     */
    public function __construct(\StructType\OriginServiceArea $originServiceArea = null, \StructType\DestinationServiceArea $destinationServiceArea = null, $shipperName = null, $shipperAccountNumber = null, $consigneeName = null, $shipmentDate = null, $pieces = null, $weight = null, $weightUnit = null, $serviceType = null, $shipmentDescription = null, \StructType\Shipper $shipper = null, \StructType\Consignee $consignee = null, \ArrayType\ArrayOfShipmentEvent $shipmentEvent = null, array $shipperReference = array(), $estimatedDeliveryDate = null, \ArrayType\ArrayOfChildShipmentIdentificationNumbers $arrayOfChildShipmentIdentificationNumbers = null)
    {
        $this
            ->setOriginServiceArea($originServiceArea)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setShipperName($shipperName)
            ->setShipperAccountNumber($shipperAccountNumber)
            ->setConsigneeName($consigneeName)
            ->setShipmentDate($shipmentDate)
            ->setPieces($pieces)
            ->setWeight($weight)
            ->setWeightUnit($weightUnit)
            ->setServiceType($serviceType)
            ->setShipmentDescription($shipmentDescription)
            ->setShipper($shipper)
            ->setConsignee($consignee)
            ->setShipmentEvent($shipmentEvent)
            ->setShipperReference($shipperReference)
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setArrayOfChildShipmentIdentificationNumbers($arrayOfChildShipmentIdentificationNumbers);
    }
    /**
     * Get OriginServiceArea value
     * @return \StructType\OriginServiceArea|null
     */
    public function getOriginServiceArea()
    {
        return $this->OriginServiceArea;
    }
    /**
     * Set OriginServiceArea value
     * @param \StructType\OriginServiceArea $originServiceArea
     * @return \StructType\ShipmentInfo
     */
    public function setOriginServiceArea(\StructType\OriginServiceArea $originServiceArea = null)
    {
        $this->OriginServiceArea = $originServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return \StructType\DestinationServiceArea|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param \StructType\DestinationServiceArea $destinationServiceArea
     * @return \StructType\ShipmentInfo
     */
    public function setDestinationServiceArea(\StructType\DestinationServiceArea $destinationServiceArea = null)
    {
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get ShipperName value
     * @return string|null
     */
    public function getShipperName()
    {
        return $this->ShipperName;
    }
    /**
     * Set ShipperName value
     * @param string $shipperName
     * @return \StructType\ShipmentInfo
     */
    public function setShipperName($shipperName = null)
    {
        // validation for constraint: string
        if (!is_null($shipperName) && !is_string($shipperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperName, true), gettype($shipperName)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($shipperName) && mb_strlen($shipperName) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($shipperName)), __LINE__);
        }
        $this->ShipperName = $shipperName;
        return $this;
    }
    /**
     * Get ShipperAccountNumber value
     * @return int|null
     */
    public function getShipperAccountNumber()
    {
        return $this->ShipperAccountNumber;
    }
    /**
     * Set ShipperAccountNumber value
     * @param int $shipperAccountNumber
     * @return \StructType\ShipmentInfo
     */
    public function setShipperAccountNumber($shipperAccountNumber = null)
    {
        // validation for constraint: int
        if (!is_null($shipperAccountNumber) && !(is_int($shipperAccountNumber) || ctype_digit($shipperAccountNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipperAccountNumber, true), gettype($shipperAccountNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($shipperAccountNumber) && $shipperAccountNumber > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($shipperAccountNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(100000000)
        if (!is_null($shipperAccountNumber) && $shipperAccountNumber < 100000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 100000000', var_export($shipperAccountNumber, true)), __LINE__);
        }
        $this->ShipperAccountNumber = $shipperAccountNumber;
        return $this;
    }
    /**
     * Get ConsigneeName value
     * @return string|null
     */
    public function getConsigneeName()
    {
        return $this->ConsigneeName;
    }
    /**
     * Set ConsigneeName value
     * @param string $consigneeName
     * @return \StructType\ShipmentInfo
     */
    public function setConsigneeName($consigneeName = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeName) && !is_string($consigneeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeName, true), gettype($consigneeName)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($consigneeName) && mb_strlen($consigneeName) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($consigneeName)), __LINE__);
        }
        $this->ConsigneeName = $consigneeName;
        return $this;
    }
    /**
     * Get ShipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->ShipmentDate;
    }
    /**
     * Set ShipmentDate value
     * @param string $shipmentDate
     * @return \StructType\ShipmentInfo
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        $this->ShipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get Pieces value
     * @return string|null
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param string $pieces
     * @return \StructType\ShipmentInfo
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: string
        if (!is_null($pieces) && !is_string($pieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\ShipmentInfo
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @uses \EnumType\WeightUnit::valueIsValid()
     * @uses \EnumType\WeightUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightUnit
     * @return \StructType\ShipmentInfo
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WeightUnit::valueIsValid($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WeightUnit', is_array($weightUnit) ? implode(', ', $weightUnit) : var_export($weightUnit, true), implode(', ', \EnumType\WeightUnit::getValidValues())), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \StructType\ShipmentInfo
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceType) && mb_strlen($serviceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceType) && mb_strlen($serviceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get ShipmentDescription value
     * @return string|null
     */
    public function getShipmentDescription()
    {
        return $this->ShipmentDescription;
    }
    /**
     * Set ShipmentDescription value
     * @param string $shipmentDescription
     * @return \StructType\ShipmentInfo
     */
    public function setShipmentDescription($shipmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDescription) && !is_string($shipmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDescription, true), gettype($shipmentDescription)), __LINE__);
        }
        $this->ShipmentDescription = $shipmentDescription;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\Shipper|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \StructType\Shipper $shipper
     * @return \StructType\ShipmentInfo
     */
    public function setShipper(\StructType\Shipper $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get Consignee value
     * @return \StructType\Consignee|null
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param \StructType\Consignee $consignee
     * @return \StructType\ShipmentInfo
     */
    public function setConsignee(\StructType\Consignee $consignee = null)
    {
        $this->Consignee = $consignee;
        return $this;
    }
    /**
     * Get ShipmentEvent value
     * @return \ArrayType\ArrayOfShipmentEvent|null
     */
    public function getShipmentEvent()
    {
        return $this->ShipmentEvent;
    }
    /**
     * Set ShipmentEvent value
     * @param \ArrayType\ArrayOfShipmentEvent $shipmentEvent
     * @return \StructType\ShipmentInfo
     */
    public function setShipmentEvent(\ArrayType\ArrayOfShipmentEvent $shipmentEvent = null)
    {
        $this->ShipmentEvent = $shipmentEvent;
        return $this;
    }
    /**
     * Get ShipperReference value
     * @return \StructType\ShipperReference[]|null
     */
    public function getShipperReference()
    {
        return $this->ShipperReference;
    }
    /**
     * This method is responsible for validating the values passed to the setShipperReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipperReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipperReferenceForArrayConstraintsFromSetShipperReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentInfoShipperReferenceItem) {
            // validation for constraint: itemType
            if (!$shipmentInfoShipperReferenceItem instanceof \StructType\ShipperReference) {
                $invalidValues[] = is_object($shipmentInfoShipperReferenceItem) ? get_class($shipmentInfoShipperReferenceItem) : sprintf('%s(%s)', gettype($shipmentInfoShipperReferenceItem), var_export($shipmentInfoShipperReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipperReference property can only contain items of type \StructType\ShipperReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipperReference value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipperReference[] $shipperReference
     * @return \StructType\ShipmentInfo
     */
    public function setShipperReference(array $shipperReference = array())
    {
        // validation for constraint: array
        if ('' !== ($shipperReferenceArrayErrorMessage = self::validateShipperReferenceForArrayConstraintsFromSetShipperReference($shipperReference))) {
            throw new \InvalidArgumentException($shipperReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($shipperReference) && count($shipperReference) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($shipperReference)), __LINE__);
        }
        $this->ShipperReference = $shipperReference;
        return $this;
    }
    /**
     * Add item to ShipperReference value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipperReference $item
     * @return \StructType\ShipmentInfo
     */
    public function addToShipperReference(\StructType\ShipperReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipperReference) {
            throw new \InvalidArgumentException(sprintf('The ShipperReference property can only contain items of type \StructType\ShipperReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->ShipperReference) && count($this->ShipperReference) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->ShipperReference)), __LINE__);
        }
        $this->ShipperReference[] = $item;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \StructType\ShipmentInfo
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Get ArrayOfChildShipmentIdentificationNumbers value
     * @return \ArrayType\ArrayOfChildShipmentIdentificationNumbers|null
     */
    public function getArrayOfChildShipmentIdentificationNumbers()
    {
        return $this->ArrayOfChildShipmentIdentificationNumbers;
    }
    /**
     * Set ArrayOfChildShipmentIdentificationNumbers value
     * @param \ArrayType\ArrayOfChildShipmentIdentificationNumbers $arrayOfChildShipmentIdentificationNumbers
     * @return \StructType\ShipmentInfo
     */
    public function setArrayOfChildShipmentIdentificationNumbers(\ArrayType\ArrayOfChildShipmentIdentificationNumbers $arrayOfChildShipmentIdentificationNumbers = null)
    {
        $this->ArrayOfChildShipmentIdentificationNumbers = $arrayOfChildShipmentIdentificationNumbers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
