<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentEvent StructType
 * @subpackage Structs
 */
class ShipmentEvent extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - documentation: Local Date of Shipment Event
     * @var string
     */
    public $Date;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - documentation: Local Time of Shipment Event
     * @var string
     */
    public $Time;
    /**
     * The ServiceEvent
     * @var \StructType\ServiceEvent
     */
    public $ServiceEvent;
    /**
     * The Signatory
     * Meta informations extracted from the WSDL
     * - documentation: The signee for the shipment, only occurs for final disposition events (such as OK event)
     * - base: xsd:string
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $Signatory;
    /**
     * The EventRemarks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EventRemarks
     */
    public $EventRemarks;
    /**
     * The ServiceArea
     * @var \StructType\ServiceArea
     */
    public $ServiceArea;
    /**
     * Constructor method for ShipmentEvent
     * @uses ShipmentEvent::setDate()
     * @uses ShipmentEvent::setTime()
     * @uses ShipmentEvent::setServiceEvent()
     * @uses ShipmentEvent::setSignatory()
     * @uses ShipmentEvent::setEventRemarks()
     * @uses ShipmentEvent::setServiceArea()
     * @param string $date
     * @param string $time
     * @param \StructType\ServiceEvent $serviceEvent
     * @param string $signatory
     * @param \StructType\EventRemarks $eventRemarks
     * @param \StructType\ServiceArea $serviceArea
     */
    public function __construct($date = null, $time = null, \StructType\ServiceEvent $serviceEvent = null, $signatory = null, \StructType\EventRemarks $eventRemarks = null, \StructType\ServiceArea $serviceArea = null)
    {
        $this
            ->setDate($date)
            ->setTime($time)
            ->setServiceEvent($serviceEvent)
            ->setSignatory($signatory)
            ->setEventRemarks($eventRemarks)
            ->setServiceArea($serviceArea);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ShipmentEvent
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\ShipmentEvent
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get ServiceEvent value
     * @return \StructType\ServiceEvent|null
     */
    public function getServiceEvent()
    {
        return $this->ServiceEvent;
    }
    /**
     * Set ServiceEvent value
     * @param \StructType\ServiceEvent $serviceEvent
     * @return \StructType\ShipmentEvent
     */
    public function setServiceEvent(\StructType\ServiceEvent $serviceEvent = null)
    {
        $this->ServiceEvent = $serviceEvent;
        return $this;
    }
    /**
     * Get Signatory value
     * @return string|null
     */
    public function getSignatory()
    {
        return $this->Signatory;
    }
    /**
     * Set Signatory value
     * @param string $signatory
     * @return \StructType\ShipmentEvent
     */
    public function setSignatory($signatory = null)
    {
        // validation for constraint: string
        if (!is_null($signatory) && !is_string($signatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatory, true), gettype($signatory)), __LINE__);
        }
        $this->Signatory = $signatory;
        return $this;
    }
    /**
     * Get EventRemarks value
     * @return \StructType\EventRemarks|null
     */
    public function getEventRemarks()
    {
        return $this->EventRemarks;
    }
    /**
     * Set EventRemarks value
     * @param \StructType\EventRemarks $eventRemarks
     * @return \StructType\ShipmentEvent
     */
    public function setEventRemarks(\StructType\EventRemarks $eventRemarks = null)
    {
        $this->EventRemarks = $eventRemarks;
        return $this;
    }
    /**
     * Get ServiceArea value
     * @return \StructType\ServiceArea|null
     */
    public function getServiceArea()
    {
        return $this->ServiceArea;
    }
    /**
     * Set ServiceArea value
     * @param \StructType\ServiceArea $serviceArea
     * @return \StructType\ShipmentEvent
     */
    public function setServiceArea(\StructType\ServiceArea $serviceArea = null)
    {
        $this->ServiceArea = $serviceArea;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
