<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceHeader StructType
 * @subpackage Structs
 */
class ServiceHeader extends AbstractStructBase
{
    /**
     * The MessageTime
     * @var string
     */
    public $MessageTime;
    /**
     * The MessageReference
     * Meta informations extracted from the WSDL
     * - documentation: The unique message reference
     * - base: xsd:string
     * - maxLength: 36
     * - minLength: 28
     * - whiteSpace: preserve
     * @var string
     */
    public $MessageReference;
    /**
     * The WebstorePlatform
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $WebstorePlatform;
    /**
     * The WebstorePlatformVersion
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minOccurs: 0
     * @var string
     */
    public $WebstorePlatformVersion;
    /**
     * The ShippingSystemPlatform
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $ShippingSystemPlatform;
    /**
     * The ShippingSystemPlatformVersion
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minOccurs: 0
     * @var string
     */
    public $ShippingSystemPlatformVersion;
    /**
     * The PlugIn
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $PlugIn;
    /**
     * The PlugInVersion
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minOccurs: 0
     * @var string
     */
    public $PlugInVersion;
    /**
     * Constructor method for ServiceHeader
     * @uses ServiceHeader::setMessageTime()
     * @uses ServiceHeader::setMessageReference()
     * @uses ServiceHeader::setWebstorePlatform()
     * @uses ServiceHeader::setWebstorePlatformVersion()
     * @uses ServiceHeader::setShippingSystemPlatform()
     * @uses ServiceHeader::setShippingSystemPlatformVersion()
     * @uses ServiceHeader::setPlugIn()
     * @uses ServiceHeader::setPlugInVersion()
     * @param string $messageTime
     * @param string $messageReference
     * @param string $webstorePlatform
     * @param string $webstorePlatformVersion
     * @param string $shippingSystemPlatform
     * @param string $shippingSystemPlatformVersion
     * @param string $plugIn
     * @param string $plugInVersion
     */
    public function __construct($messageTime = null, $messageReference = null, $webstorePlatform = null, $webstorePlatformVersion = null, $shippingSystemPlatform = null, $shippingSystemPlatformVersion = null, $plugIn = null, $plugInVersion = null)
    {
        $this
            ->setMessageTime($messageTime)
            ->setMessageReference($messageReference)
            ->setWebstorePlatform($webstorePlatform)
            ->setWebstorePlatformVersion($webstorePlatformVersion)
            ->setShippingSystemPlatform($shippingSystemPlatform)
            ->setShippingSystemPlatformVersion($shippingSystemPlatformVersion)
            ->setPlugIn($plugIn)
            ->setPlugInVersion($plugInVersion);
    }
    /**
     * Get MessageTime value
     * @return string|null
     */
    public function getMessageTime()
    {
        return $this->MessageTime;
    }
    /**
     * Set MessageTime value
     * @param string $messageTime
     * @return \StructType\ServiceHeader
     */
    public function setMessageTime($messageTime = null)
    {
        // validation for constraint: string
        if (!is_null($messageTime) && !is_string($messageTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageTime, true), gettype($messageTime)), __LINE__);
        }
        $this->MessageTime = $messageTime;
        return $this;
    }
    /**
     * Get MessageReference value
     * @return string|null
     */
    public function getMessageReference()
    {
        return $this->MessageReference;
    }
    /**
     * Set MessageReference value
     * @param string $messageReference
     * @return \StructType\ServiceHeader
     */
    public function setMessageReference($messageReference = null)
    {
        // validation for constraint: string
        if (!is_null($messageReference) && !is_string($messageReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageReference, true), gettype($messageReference)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($messageReference) && mb_strlen($messageReference) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($messageReference)), __LINE__);
        }
        // validation for constraint: minLength(28)
        if (!is_null($messageReference) && mb_strlen($messageReference) < 28) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 28', mb_strlen($messageReference)), __LINE__);
        }
        $this->MessageReference = $messageReference;
        return $this;
    }
    /**
     * Get WebstorePlatform value
     * @return string|null
     */
    public function getWebstorePlatform()
    {
        return $this->WebstorePlatform;
    }
    /**
     * Set WebstorePlatform value
     * @param string $webstorePlatform
     * @return \StructType\ServiceHeader
     */
    public function setWebstorePlatform($webstorePlatform = null)
    {
        // validation for constraint: string
        if (!is_null($webstorePlatform) && !is_string($webstorePlatform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webstorePlatform, true), gettype($webstorePlatform)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($webstorePlatform) && mb_strlen($webstorePlatform) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($webstorePlatform)), __LINE__);
        }
        $this->WebstorePlatform = $webstorePlatform;
        return $this;
    }
    /**
     * Get WebstorePlatformVersion value
     * @return string|null
     */
    public function getWebstorePlatformVersion()
    {
        return $this->WebstorePlatformVersion;
    }
    /**
     * Set WebstorePlatformVersion value
     * @param string $webstorePlatformVersion
     * @return \StructType\ServiceHeader
     */
    public function setWebstorePlatformVersion($webstorePlatformVersion = null)
    {
        // validation for constraint: string
        if (!is_null($webstorePlatformVersion) && !is_string($webstorePlatformVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webstorePlatformVersion, true), gettype($webstorePlatformVersion)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($webstorePlatformVersion) && mb_strlen($webstorePlatformVersion) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($webstorePlatformVersion)), __LINE__);
        }
        $this->WebstorePlatformVersion = $webstorePlatformVersion;
        return $this;
    }
    /**
     * Get ShippingSystemPlatform value
     * @return string|null
     */
    public function getShippingSystemPlatform()
    {
        return $this->ShippingSystemPlatform;
    }
    /**
     * Set ShippingSystemPlatform value
     * @param string $shippingSystemPlatform
     * @return \StructType\ServiceHeader
     */
    public function setShippingSystemPlatform($shippingSystemPlatform = null)
    {
        // validation for constraint: string
        if (!is_null($shippingSystemPlatform) && !is_string($shippingSystemPlatform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingSystemPlatform, true), gettype($shippingSystemPlatform)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($shippingSystemPlatform) && mb_strlen($shippingSystemPlatform) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($shippingSystemPlatform)), __LINE__);
        }
        $this->ShippingSystemPlatform = $shippingSystemPlatform;
        return $this;
    }
    /**
     * Get ShippingSystemPlatformVersion value
     * @return string|null
     */
    public function getShippingSystemPlatformVersion()
    {
        return $this->ShippingSystemPlatformVersion;
    }
    /**
     * Set ShippingSystemPlatformVersion value
     * @param string $shippingSystemPlatformVersion
     * @return \StructType\ServiceHeader
     */
    public function setShippingSystemPlatformVersion($shippingSystemPlatformVersion = null)
    {
        // validation for constraint: string
        if (!is_null($shippingSystemPlatformVersion) && !is_string($shippingSystemPlatformVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingSystemPlatformVersion, true), gettype($shippingSystemPlatformVersion)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($shippingSystemPlatformVersion) && mb_strlen($shippingSystemPlatformVersion) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($shippingSystemPlatformVersion)), __LINE__);
        }
        $this->ShippingSystemPlatformVersion = $shippingSystemPlatformVersion;
        return $this;
    }
    /**
     * Get PlugIn value
     * @return string|null
     */
    public function getPlugIn()
    {
        return $this->PlugIn;
    }
    /**
     * Set PlugIn value
     * @param string $plugIn
     * @return \StructType\ServiceHeader
     */
    public function setPlugIn($plugIn = null)
    {
        // validation for constraint: string
        if (!is_null($plugIn) && !is_string($plugIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plugIn, true), gettype($plugIn)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($plugIn) && mb_strlen($plugIn) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($plugIn)), __LINE__);
        }
        $this->PlugIn = $plugIn;
        return $this;
    }
    /**
     * Get PlugInVersion value
     * @return string|null
     */
    public function getPlugInVersion()
    {
        return $this->PlugInVersion;
    }
    /**
     * Set PlugInVersion value
     * @param string $plugInVersion
     * @return \StructType\ServiceHeader
     */
    public function setPlugInVersion($plugInVersion = null)
    {
        // validation for constraint: string
        if (!is_null($plugInVersion) && !is_string($plugInVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plugInVersion, true), gettype($plugInVersion)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($plugInVersion) && mb_strlen($plugInVersion) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($plugInVersion)), __LINE__);
        }
        $this->PlugInVersion = $plugInVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
