<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceArea StructType
 * @subpackage Structs
 */
class ServiceArea extends AbstractStructBase
{
    /**
     * The ServiceAreaCode
     * Meta informations extracted from the WSDL
     * - documentation: The DHL Service Area Code for the origin/destination of the Shipment
     * - base: xsd:string
     * - length: 3
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: The description of the service area code.
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ServiceArea
     * @uses ServiceArea::setServiceAreaCode()
     * @uses ServiceArea::setDescription()
     * @param string $serviceAreaCode
     * @param string $description
     */
    public function __construct($serviceAreaCode = null, $description = null)
    {
        $this
            ->setServiceAreaCode($serviceAreaCode)
            ->setDescription($description);
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \StructType\ServiceArea
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($serviceAreaCode) && mb_strlen($serviceAreaCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ServiceArea
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
