<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceQuery StructType
 * @subpackage Structs
 */
class ReferenceQuery extends AbstractStructBase
{
    /**
     * The ShipperAccountNumber
     * Meta informations extracted from the WSDL
     * - documentation: The account number of the shipper
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipperAccountNumber;
    /**
     * The ShipmentReferences
     * @var \StructType\Reference
     */
    public $ShipmentReferences;
    /**
     * The ShipmentDateRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentDate
     */
    public $ShipmentDateRange;
    /**
     * Constructor method for ReferenceQuery
     * @uses ReferenceQuery::setShipperAccountNumber()
     * @uses ReferenceQuery::setShipmentReferences()
     * @uses ReferenceQuery::setShipmentDateRange()
     * @param string $shipperAccountNumber
     * @param \StructType\Reference $shipmentReferences
     * @param \StructType\ShipmentDate $shipmentDateRange
     */
    public function __construct($shipperAccountNumber = null, \StructType\Reference $shipmentReferences = null, \StructType\ShipmentDate $shipmentDateRange = null)
    {
        $this
            ->setShipperAccountNumber($shipperAccountNumber)
            ->setShipmentReferences($shipmentReferences)
            ->setShipmentDateRange($shipmentDateRange);
    }
    /**
     * Get ShipperAccountNumber value
     * @return string|null
     */
    public function getShipperAccountNumber()
    {
        return $this->ShipperAccountNumber;
    }
    /**
     * Set ShipperAccountNumber value
     * @param string $shipperAccountNumber
     * @return \StructType\ReferenceQuery
     */
    public function setShipperAccountNumber($shipperAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperAccountNumber) && !is_string($shipperAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperAccountNumber, true), gettype($shipperAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($shipperAccountNumber) && mb_strlen($shipperAccountNumber) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($shipperAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($shipperAccountNumber) && mb_strlen($shipperAccountNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($shipperAccountNumber)), __LINE__);
        }
        $this->ShipperAccountNumber = $shipperAccountNumber;
        return $this;
    }
    /**
     * Get ShipmentReferences value
     * @return \StructType\Reference|null
     */
    public function getShipmentReferences()
    {
        return $this->ShipmentReferences;
    }
    /**
     * Set ShipmentReferences value
     * @param \StructType\Reference $shipmentReferences
     * @return \StructType\ReferenceQuery
     */
    public function setShipmentReferences(\StructType\Reference $shipmentReferences = null)
    {
        $this->ShipmentReferences = $shipmentReferences;
        return $this;
    }
    /**
     * Get ShipmentDateRange value
     * @return \StructType\ShipmentDate|null
     */
    public function getShipmentDateRange()
    {
        return $this->ShipmentDateRange;
    }
    /**
     * Set ShipmentDateRange value
     * @param \StructType\ShipmentDate $shipmentDateRange
     * @return \StructType\ReferenceQuery
     */
    public function setShipmentDateRange(\StructType\ShipmentDate $shipmentDateRange = null)
    {
        $this->ShipmentDateRange = $shipmentDateRange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
