<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceFault StructType
 * @subpackage Structs
 */
class PieceFault extends AbstractStructBase
{
    /**
     * The PieceID
     * Meta informations extracted from the WSDL
     * - documentation: License Plate Number | DHL Piece ID
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: preserve
     * @var string
     */
    public $PieceID;
    /**
     * The ConditionCode
     * Meta informations extracted from the WSDL
     * - documentation: Error code
     * @var string
     */
    public $ConditionCode;
    /**
     * The ConditionData
     * Meta informations extracted from the WSDL
     * - documentation: Error Messsage
     * @var string
     */
    public $ConditionData;
    /**
     * Constructor method for PieceFault
     * @uses PieceFault::setPieceID()
     * @uses PieceFault::setConditionCode()
     * @uses PieceFault::setConditionData()
     * @param string $pieceID
     * @param string $conditionCode
     * @param string $conditionData
     */
    public function __construct($pieceID = null, $conditionCode = null, $conditionData = null)
    {
        $this
            ->setPieceID($pieceID)
            ->setConditionCode($conditionCode)
            ->setConditionData($conditionData);
    }
    /**
     * Get PieceID value
     * @return string|null
     */
    public function getPieceID()
    {
        return $this->PieceID;
    }
    /**
     * Set PieceID value
     * @param string $pieceID
     * @return \StructType\PieceFault
     */
    public function setPieceID($pieceID = null)
    {
        // validation for constraint: string
        if (!is_null($pieceID) && !is_string($pieceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pieceID, true), gettype($pieceID)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($pieceID) && mb_strlen($pieceID) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($pieceID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pieceID) && mb_strlen($pieceID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pieceID)), __LINE__);
        }
        $this->PieceID = $pieceID;
        return $this;
    }
    /**
     * Get ConditionCode value
     * @return string|null
     */
    public function getConditionCode()
    {
        return $this->ConditionCode;
    }
    /**
     * Set ConditionCode value
     * @param string $conditionCode
     * @return \StructType\PieceFault
     */
    public function setConditionCode($conditionCode = null)
    {
        // validation for constraint: string
        if (!is_null($conditionCode) && !is_string($conditionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionCode, true), gettype($conditionCode)), __LINE__);
        }
        $this->ConditionCode = $conditionCode;
        return $this;
    }
    /**
     * Get ConditionData value
     * @return string|null
     */
    public function getConditionData()
    {
        return $this->ConditionData;
    }
    /**
     * Set ConditionData value
     * @param string $conditionData
     * @return \StructType\PieceFault
     */
    public function setConditionData($conditionData = null)
    {
        // validation for constraint: string
        if (!is_null($conditionData) && !is_string($conditionData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionData, true), gettype($conditionData)), __LINE__);
        }
        $this->ConditionData = $conditionData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PieceFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
