<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRemarks StructType
 * @subpackage Structs
 */
class EventRemarks extends AbstractStructBase
{
    /**
     * The FurtherDetails
     * Meta informations extracted from the WSDL
     * - documentation: The further details describe from the event description
     * - base: xsd:string
     * @var string
     */
    public $FurtherDetails;
    /**
     * The NextSteps
     * Meta informations extracted from the WSDL
     * - documentation: Explained the next step for the shipment
     * - base: xsd:string
     * @var string
     */
    public $NextSteps;
    /**
     * Constructor method for EventRemarks
     * @uses EventRemarks::setFurtherDetails()
     * @uses EventRemarks::setNextSteps()
     * @param string $furtherDetails
     * @param string $nextSteps
     */
    public function __construct($furtherDetails = null, $nextSteps = null)
    {
        $this
            ->setFurtherDetails($furtherDetails)
            ->setNextSteps($nextSteps);
    }
    /**
     * Get FurtherDetails value
     * @return string|null
     */
    public function getFurtherDetails()
    {
        return $this->FurtherDetails;
    }
    /**
     * Set FurtherDetails value
     * @param string $furtherDetails
     * @return \StructType\EventRemarks
     */
    public function setFurtherDetails($furtherDetails = null)
    {
        // validation for constraint: string
        if (!is_null($furtherDetails) && !is_string($furtherDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($furtherDetails, true), gettype($furtherDetails)), __LINE__);
        }
        $this->FurtherDetails = $furtherDetails;
        return $this;
    }
    /**
     * Get NextSteps value
     * @return string|null
     */
    public function getNextSteps()
    {
        return $this->NextSteps;
    }
    /**
     * Set NextSteps value
     * @param string $nextSteps
     * @return \StructType\EventRemarks
     */
    public function setNextSteps($nextSteps = null)
    {
        // validation for constraint: string
        if (!is_null($nextSteps) && !is_string($nextSteps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextSteps, true), gettype($nextSteps)), __LINE__);
        }
        $this->NextSteps = $nextSteps;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventRemarks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
